/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.BlockType;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoStriped;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.ErasureCodingPolicyManager;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.hdfs.server.namenode.TestINodeFile;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestStripedINodeFile {
    public static final Logger LOG = LoggerFactory.getLogger(TestINodeFile.class);
    private static final PermissionStatus perm = new PermissionStatus("userName", null, FsPermission.getDefault());
    private final BlockStoragePolicySuite defaultSuite = BlockStoragePolicySuite.createDefaultSuite();
    private final BlockStoragePolicy defaultPolicy = this.defaultSuite.getDefaultPolicy();
    private static final ErasureCodingPolicy testECPolicy = StripedFileTestUtil.getDefaultECPolicy();
    @Rule
    public Timeout globalTimeout = new Timeout(300000);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    private static INodeFile createStripedINodeFile() {
        return new INodeFile(0L, null, perm, 0L, 0L, null, null, Byte.valueOf(StripedFileTestUtil.getDefaultECPolicy().getId()), 1024L, 2, BlockType.STRIPED);
    }

    @Before
    public void init() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        ErasureCodingPolicyManager.getInstance().init((Configuration)conf);
    }

    @Test
    public void testInvalidECPolicy() throws IllegalArgumentException {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Could not find EC policy with ID 0xbb");
        new INodeFile(0L, null, perm, 0L, 0L, null, null, Byte.valueOf((byte)-69), 1024L, 2, BlockType.STRIPED);
    }

    @Test
    public void testBlockStripedFeature() throws IOException, InterruptedException {
        INodeFile inf = TestStripedINodeFile.createStripedINodeFile();
        Assert.assertTrue((boolean)inf.isStriped());
    }

    @Test
    public void testBlockStripedTotalBlockCount() {
        Block blk = new Block(1L);
        BlockInfoStriped blockInfoStriped = new BlockInfoStriped(blk, testECPolicy);
        Assert.assertEquals((long)9L, (long)blockInfoStriped.getTotalBlockNum());
    }

    @Test
    public void testStripedLayoutRedundancy() {
        try {
            new INodeFile(0L, null, perm, 0L, 0L, null, new Short(3), Byte.valueOf(StripedFileTestUtil.getDefaultECPolicy().getId()), 1024L, 5, BlockType.STRIPED);
            Assert.fail((String)"INodeFile construction should fail when both replication and ECPolicy requested!");
        }
        catch (IllegalArgumentException iae) {
            LOG.info("Expected exception: ", (Throwable)iae);
        }
        try {
            new INodeFile(0L, null, perm, 0L, 0L, null, null, null, 1024L, 5, BlockType.STRIPED);
            Assert.fail((String)"INodeFile construction should fail when EC Policy param not provided for striped layout!");
        }
        catch (IllegalArgumentException iae) {
            LOG.info("Expected exception: ", (Throwable)iae);
        }
        try {
            new INodeFile(0L, null, perm, 0L, 0L, null, null, Byte.valueOf((byte)127), 1024L, 5, BlockType.STRIPED);
            Assert.fail((String)"INodeFile construction should fail when EC Policy is not in the supported list!");
        }
        catch (IllegalArgumentException iae) {
            LOG.info("Expected exception: ", (Throwable)iae);
        }
        Byte ecPolicyID = StripedFileTestUtil.getDefaultECPolicy().getId();
        try {
            new INodeFile(0L, null, perm, 0L, 0L, null, null, ecPolicyID, 1024L, 5, BlockType.CONTIGUOUS);
            Assert.fail((String)"INodeFile construction should fail when replication param is provided for striped layout!");
        }
        catch (IllegalArgumentException iae) {
            LOG.info("Expected exception: ", (Throwable)iae);
        }
        INodeFile inodeFile = new INodeFile(0L, null, perm, 0L, 0L, null, null, ecPolicyID, 1024L, 5, BlockType.STRIPED);
        Assert.assertTrue((boolean)inodeFile.isStriped());
        Assert.assertEquals((long)ecPolicyID.byteValue(), (long)inodeFile.getErasureCodingPolicyID());
    }

    @Test
    public void testBlockStripedLength() throws IOException, InterruptedException {
        INodeFile inf = TestStripedINodeFile.createStripedINodeFile();
        Block blk = new Block(1L);
        BlockInfoStriped blockInfoStriped = new BlockInfoStriped(blk, testECPolicy);
        inf.addBlock((BlockInfo)blockInfoStriped);
        Assert.assertEquals((long)1L, (long)inf.getBlocks().length);
    }

    @Test
    public void testBlockStripedConsumedSpace() throws IOException, InterruptedException {
        INodeFile inf = TestStripedINodeFile.createStripedINodeFile();
        Block blk = new Block(1L);
        BlockInfoStriped blockInfoStriped = new BlockInfoStriped(blk, testECPolicy);
        blockInfoStriped.setNumBytes(1L);
        inf.addBlock((BlockInfo)blockInfoStriped);
        Assert.assertEquals((long)4L, (long)inf.storagespaceConsumedStriped().getStorageSpace());
        Assert.assertEquals((long)4L, (long)inf.storagespaceConsumed(this.defaultPolicy).getStorageSpace());
    }

    @Test
    public void testMultipleBlockStripedConsumedSpace() throws IOException, InterruptedException {
        INodeFile inf = TestStripedINodeFile.createStripedINodeFile();
        Block blk1 = new Block(1L);
        BlockInfoStriped blockInfoStriped1 = new BlockInfoStriped(blk1, testECPolicy);
        blockInfoStriped1.setNumBytes(1L);
        Block blk2 = new Block(2L);
        BlockInfoStriped blockInfoStriped2 = new BlockInfoStriped(blk2, testECPolicy);
        blockInfoStriped2.setNumBytes(1L);
        inf.addBlock((BlockInfo)blockInfoStriped1);
        inf.addBlock((BlockInfo)blockInfoStriped2);
        Assert.assertEquals((long)8L, (long)inf.storagespaceConsumedStriped().getStorageSpace());
        Assert.assertEquals((long)8L, (long)inf.storagespaceConsumed(this.defaultPolicy).getStorageSpace());
    }

    @Test
    public void testBlockStripedFileSize() throws IOException, InterruptedException {
        INodeFile inf = TestStripedINodeFile.createStripedINodeFile();
        Block blk = new Block(1L);
        BlockInfoStriped blockInfoStriped = new BlockInfoStriped(blk, testECPolicy);
        blockInfoStriped.setNumBytes(100L);
        inf.addBlock((BlockInfo)blockInfoStriped);
        Assert.assertEquals((long)100L, (long)inf.computeFileSize());
        Assert.assertEquals((long)100L, (long)inf.computeFileSize(false, false));
    }

    @Test
    public void testBlockStripedUCFileSize() throws IOException, InterruptedException {
        INodeFile inf = TestStripedINodeFile.createStripedINodeFile();
        Block blk = new Block(1L);
        BlockInfoStriped bInfoUCStriped = new BlockInfoStriped(blk, testECPolicy);
        bInfoUCStriped.convertToBlockUnderConstruction(HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION, null);
        bInfoUCStriped.setNumBytes(100L);
        inf.addBlock((BlockInfo)bInfoUCStriped);
        Assert.assertEquals((long)100L, (long)inf.computeFileSize());
        Assert.assertEquals((long)0L, (long)inf.computeFileSize(false, false));
    }

    @Test
    public void testBlockStripedComputeQuotaUsage() throws IOException, InterruptedException {
        INodeFile inf = TestStripedINodeFile.createStripedINodeFile();
        Block blk = new Block(1L);
        BlockInfoStriped blockInfoStriped = new BlockInfoStriped(blk, testECPolicy);
        blockInfoStriped.setNumBytes(100L);
        inf.addBlock((BlockInfo)blockInfoStriped);
        QuotaCounts counts = inf.computeQuotaUsageWithStriped(this.defaultPolicy, new QuotaCounts.Builder().build());
        Assert.assertEquals((long)1L, (long)counts.getNameSpace());
        Assert.assertEquals((long)400L, (long)counts.getStorageSpace());
    }

    @Test
    public void testBlockStripedUCComputeQuotaUsage() throws IOException, InterruptedException {
        INodeFile inf = TestStripedINodeFile.createStripedINodeFile();
        Block blk = new Block(1L);
        BlockInfoStriped bInfoUCStriped = new BlockInfoStriped(blk, testECPolicy);
        bInfoUCStriped.convertToBlockUnderConstruction(HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION, null);
        bInfoUCStriped.setNumBytes(100L);
        inf.addBlock((BlockInfo)bInfoUCStriped);
        QuotaCounts counts = inf.computeQuotaUsageWithStriped(this.defaultPolicy, new QuotaCounts.Builder().build());
        Assert.assertEquals((long)1024L, (long)inf.getPreferredBlockSize());
        Assert.assertEquals((long)1L, (long)counts.getNameSpace());
        Assert.assertEquals((long)9216L, (long)counts.getStorageSpace());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testDeleteOp() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            BlockInfo[] contiguousBlks;
            BlockInfo[] stripedBlks;
            int len = 1024;
            Path parentDir = new Path("/parentDir");
            Path ecDir = new Path(parentDir, "ecDir");
            Path ecFile = new Path(ecDir, "ecFile");
            Path contiguousFile = new Path(parentDir, "someFile");
            Configuration conf = new Configuration();
            short GROUP_SIZE = (short)(testECPolicy.getNumDataUnits() + testECPolicy.getNumParityUnits());
            conf.setInt("dfs.namenode.fs-limits.max-xattrs-per-inode", 2);
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(GROUP_SIZE).build();
            cluster.waitActive();
            FSNamesystem fsn = cluster.getNamesystem();
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
            dfs.mkdirs(ecDir);
            dfs.setErasureCodingPolicy(ecDir, StripedFileTestUtil.getDefaultECPolicy().getName());
            DFSTestUtil.createFile((FileSystem)dfs, ecFile, 1024L, (short)1, 65261L);
            DFSTestUtil.createFile((FileSystem)dfs, contiguousFile, 1024L, (short)1, 65261L);
            FSDirectory fsd = fsn.getFSDirectory();
            INode inodeStriped = fsd.getINode("/parentDir/ecDir/ecFile");
            Assert.assertTrue((String)"Failed to get INodeFile for /parentDir/ecDir/ecFile", (boolean)(inodeStriped instanceof INodeFile));
            INodeFile inodeStripedFile = (INodeFile)inodeStriped;
            for (BlockInfo blockInfo : stripedBlks = inodeStripedFile.getBlocks()) {
                Assert.assertFalse((String)"Mistakenly marked the block as deleted!", (boolean)blockInfo.isDeleted());
            }
            dfs.delete(ecDir, true);
            for (BlockInfo blockInfo : stripedBlks) {
                Assert.assertTrue((String)"Didn't mark the block as deleted!", (boolean)blockInfo.isDeleted());
            }
            INode inode = fsd.getINode("/parentDir/someFile");
            Assert.assertTrue((String)"Failed to get INodeFile for /parentDir/someFile", (boolean)(inode instanceof INodeFile));
            INodeFile inodeFile = (INodeFile)inode;
            for (BlockInfo blockInfo : contiguousBlks = inodeFile.getBlocks()) {
                Assert.assertFalse((String)"Mistakenly marked the block as deleted!", (boolean)blockInfo.isDeleted());
            }
            dfs.delete(parentDir, true);
            for (BlockInfo blockInfo : contiguousBlks) {
                Assert.assertTrue((String)"Didn't mark the block as deleted!", (boolean)blockInfo.isDeleted());
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testUnsuitableStoragePoliciesWithECStripedMode() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        int defaultStripedBlockSize = testECPolicy.getCellSize() * 4;
        conf.setLong("dfs.blocksize", (long)defaultStripedBlockSize);
        conf.setLong("dfs.heartbeat.interval", 1L);
        conf.setLong("dfs.namenode.redundancy.interval.seconds", 1L);
        conf.setBoolean("dfs.namenode.redundancy.considerLoad", false);
        int numOfDatanodes = 10;
        int storagesPerDatanode = 2;
        long capacity = 10 * defaultStripedBlockSize;
        long[][] capacities = new long[numOfDatanodes][storagesPerDatanode];
        for (int i = 0; i < numOfDatanodes; ++i) {
            for (int j = 0; j < storagesPerDatanode; ++j) {
                capacities[i][j] = capacity;
            }
        }
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(numOfDatanodes).storagesPerDatanode(storagesPerDatanode).storageTypes(new StorageType[][]{{StorageType.SSD, StorageType.DISK}, {StorageType.SSD, StorageType.DISK}, {StorageType.SSD, StorageType.DISK}, {StorageType.SSD, StorageType.DISK}, {StorageType.SSD, StorageType.DISK}, {StorageType.DISK, StorageType.SSD}, {StorageType.DISK, StorageType.SSD}, {StorageType.DISK, StorageType.SSD}, {StorageType.DISK, StorageType.SSD}, {StorageType.DISK, StorageType.SSD}}).storageCapacities(capacities).build();
        try {
            cluster.waitActive();
            cluster.getFileSystem().enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
            ClientProtocol client = (ClientProtocol)NameNodeProxies.createProxy((Configuration)conf, (URI)cluster.getFileSystem(0).getUri(), ClientProtocol.class).getProxy();
            String fooDir = "/foo";
            client.mkdirs(fooDir, new FsPermission(777), true);
            client.setStoragePolicy(fooDir, "ONE_SSD");
            client.setErasureCodingPolicy(fooDir, StripedFileTestUtil.getDefaultECPolicy().getName());
            String barFile = "/foo/bar";
            long fileLen = 20 * defaultStripedBlockSize;
            DFSTestUtil.createFile((FileSystem)cluster.getFileSystem(), new Path("/foo/bar"), fileLen, (short)3, 0L);
            LocatedBlocks locatedBlocks = client.getBlockLocations("/foo/bar", 0L, fileLen);
            for (LocatedBlock lb : locatedBlocks.getLocatedBlocks()) {
                for (StorageType type : lb.getStorageTypes()) {
                    Assert.assertEquals((Object)StorageType.DISK, (Object)type);
                }
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

