/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.VolumeScanner;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeReference;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class BlockScanner {
    public static final Logger LOG = LoggerFactory.getLogger(BlockScanner.class);
    private final DataNode datanode;
    private final TreeMap<String, VolumeScanner> scanners = new TreeMap();
    private Conf conf;

    @VisibleForTesting
    void setConf(Conf conf) {
        this.conf = conf;
        for (Map.Entry<String, VolumeScanner> entry : this.scanners.entrySet()) {
            entry.getValue().setConf(conf);
        }
    }

    public BlockScanner(DataNode datanode) {
        this(datanode, datanode.getConf());
    }

    public BlockScanner(DataNode datanode, Configuration conf) {
        this.datanode = datanode;
        this.conf = new Conf(conf);
        if (this.isEnabled()) {
            LOG.info("Initialized block scanner with targetBytesPerSec {}", (Object)this.conf.targetBytesPerSec);
        } else {
            LOG.info("Disabled block scanner.");
        }
    }

    public boolean isEnabled() {
        return this.conf.scanPeriodMs > 0L && this.conf.targetBytesPerSec > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void addVolumeScanner(FsVolumeReference ref) {
        VolumeScanner scanner;
        FsVolumeSpi volume;
        block5: {
            boolean success;
            block4: {
                success = false;
                try {
                    volume = ref.getVolume();
                    if (this.isEnabled()) break block4;
                    LOG.debug("Not adding volume scanner for {}, because the block scanner is disabled.", (Object)volume);
                    if (success) return;
                }
                catch (Throwable throwable) {
                    if (success) throw throwable;
                    IOUtils.cleanup(null, (Closeable[])new Closeable[]{ref});
                    throw throwable;
                }
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{ref});
                return;
            }
            scanner = this.scanners.get(volume.getStorageID());
            if (scanner == null) break block5;
            LOG.error("Already have a scanner for volume {}.", (Object)volume);
            if (success) return;
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{ref});
            return;
        }
        LOG.debug("Adding scanner for volume {} (StorageID {})", (Object)volume, (Object)volume.getStorageID());
        scanner = new VolumeScanner(this.conf, this.datanode, ref);
        scanner.start();
        this.scanners.put(volume.getStorageID(), scanner);
    }

    public synchronized void removeVolumeScanner(FsVolumeSpi volume) {
        if (!this.isEnabled()) {
            LOG.debug("Not removing volume scanner for {}, because the block scanner is disabled.", (Object)volume.getStorageID());
            return;
        }
        VolumeScanner scanner = this.scanners.get(volume.getStorageID());
        if (scanner == null) {
            LOG.warn("No scanner found to remove for volumeId {}", (Object)volume.getStorageID());
            return;
        }
        LOG.info("Removing scanner for volume {} (StorageID {})", (Object)volume, (Object)volume.getStorageID());
        scanner.shutdown();
        this.scanners.remove(volume.getStorageID());
        Uninterruptibles.joinUninterruptibly((Thread)scanner, (long)5L, (TimeUnit)TimeUnit.MINUTES);
    }

    public synchronized void removeAllVolumeScanners() {
        for (Map.Entry<String, VolumeScanner> entry : this.scanners.entrySet()) {
            entry.getValue().shutdown();
        }
        for (Map.Entry<String, VolumeScanner> entry : this.scanners.entrySet()) {
            Uninterruptibles.joinUninterruptibly((Thread)entry.getValue(), (long)5L, (TimeUnit)TimeUnit.MINUTES);
        }
        this.scanners.clear();
    }

    synchronized void enableBlockPoolId(String bpid) {
        Preconditions.checkNotNull((Object)bpid);
        for (VolumeScanner scanner : this.scanners.values()) {
            scanner.enableBlockPoolId(bpid);
        }
    }

    synchronized void disableBlockPoolId(String bpid) {
        Preconditions.checkNotNull((Object)bpid);
        for (VolumeScanner scanner : this.scanners.values()) {
            scanner.disableBlockPoolId(bpid);
        }
    }

    @VisibleForTesting
    synchronized VolumeScanner.Statistics getVolumeStats(String volumeId) {
        VolumeScanner scanner = this.scanners.get(volumeId);
        if (scanner == null) {
            return null;
        }
        return scanner.getStatistics();
    }

    synchronized void printStats(StringBuilder p) {
        for (Map.Entry<String, VolumeScanner> entry : this.scanners.entrySet()) {
            entry.getValue().printStats(p);
        }
    }

    synchronized void markSuspectBlock(String storageId, ExtendedBlock block) {
        if (!this.isEnabled()) {
            LOG.debug("Not scanning suspicious block {} on {}, because the block scanner is disabled.", (Object)block, (Object)storageId);
            return;
        }
        VolumeScanner scanner = this.scanners.get(storageId);
        if (scanner == null) {
            LOG.info("Not scanning suspicious block {} on {}, because there is no volume scanner for that storageId.", (Object)block, (Object)storageId);
            return;
        }
        scanner.markSuspectBlock(block);
    }

    @InterfaceAudience.Private
    public static class Servlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
            response.setContentType("text/plain");
            DataNode datanode = (DataNode)this.getServletContext().getAttribute("datanode");
            BlockScanner blockScanner = datanode.getBlockScanner();
            StringBuilder buffer = new StringBuilder(8192);
            if (!blockScanner.isEnabled()) {
                LOG.warn("Periodic block scanner is not running");
                buffer.append("Periodic block scanner is not running. Please check the datanode log if this is unexpected.");
            } else {
                buffer.append("Block Scanner Statistics\n\n");
                blockScanner.printStats(buffer);
            }
            String resp = buffer.toString();
            LOG.trace("Returned Servlet info {}", (Object)resp);
            response.getWriter().write(resp);
        }
    }

    static class Conf {
        @VisibleForTesting
        static final String INTERNAL_DFS_DATANODE_SCAN_PERIOD_MS = "internal.dfs.datanode.scan.period.ms.key";
        @VisibleForTesting
        static final String INTERNAL_VOLUME_SCANNER_SCAN_RESULT_HANDLER = "internal.volume.scanner.scan.result.handler";
        @VisibleForTesting
        static final String INTERNAL_DFS_BLOCK_SCANNER_MAX_STALENESS_MS = "internal.dfs.block.scanner.max_staleness.ms";
        @VisibleForTesting
        static final long INTERNAL_DFS_BLOCK_SCANNER_MAX_STALENESS_MS_DEFAULT = TimeUnit.MILLISECONDS.convert(15L, TimeUnit.MINUTES);
        @VisibleForTesting
        static final String INTERNAL_DFS_BLOCK_SCANNER_CURSOR_SAVE_INTERVAL_MS = "dfs.block.scanner.cursor.save.interval.ms";
        @VisibleForTesting
        static final long INTERNAL_DFS_BLOCK_SCANNER_CURSOR_SAVE_INTERVAL_MS_DEFAULT = TimeUnit.MILLISECONDS.convert(10L, TimeUnit.MINUTES);
        static boolean allowUnitTestSettings = false;
        final long targetBytesPerSec;
        final long maxStalenessMs;
        final long scanPeriodMs;
        final long cursorSaveMs;
        final Class<? extends VolumeScanner.ScanResultHandler> resultHandler;

        private static long getUnitTestLong(Configuration conf, String key, long defVal) {
            if (allowUnitTestSettings) {
                return conf.getLong(key, defVal);
            }
            return defVal;
        }

        private static long getConfiguredScanPeriodMs(Configuration conf) {
            long tempScanPeriodMs = Conf.getUnitTestLong(conf, INTERNAL_DFS_DATANODE_SCAN_PERIOD_MS, TimeUnit.MILLISECONDS.convert(conf.getLong("dfs.datanode.scan.period.hours", 504L), TimeUnit.HOURS));
            if (tempScanPeriodMs == 0L) {
                tempScanPeriodMs = TimeUnit.MILLISECONDS.convert(504L, TimeUnit.HOURS);
            }
            return tempScanPeriodMs;
        }

        Conf(Configuration conf) {
            this.targetBytesPerSec = Math.max(0L, conf.getLong("dfs.block.scanner.volume.bytes.per.second", 0x100000L));
            this.maxStalenessMs = Math.max(0L, Conf.getUnitTestLong(conf, INTERNAL_DFS_BLOCK_SCANNER_MAX_STALENESS_MS, INTERNAL_DFS_BLOCK_SCANNER_MAX_STALENESS_MS_DEFAULT));
            this.scanPeriodMs = Conf.getConfiguredScanPeriodMs(conf);
            this.cursorSaveMs = Math.max(0L, Conf.getUnitTestLong(conf, INTERNAL_DFS_BLOCK_SCANNER_CURSOR_SAVE_INTERVAL_MS, INTERNAL_DFS_BLOCK_SCANNER_CURSOR_SAVE_INTERVAL_MS_DEFAULT));
            this.resultHandler = allowUnitTestSettings ? conf.getClass(INTERNAL_VOLUME_SCANNER_SCAN_RESULT_HANDLER, VolumeScanner.ScanResultHandler.class) : VolumeScanner.ScanResultHandler.class;
        }
    }
}

