/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.kms.server.KMS;
import org.apache.hadoop.crypto.key.kms.server.KMSACLs;
import org.apache.hadoop.crypto.key.kms.server.KMSConfiguration;
import org.apache.hadoop.crypto.key.kms.server.KMSWebApp;
import org.apache.hadoop.crypto.key.kms.server.KeyAuthorizationKeyProvider;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Private
public class KMSACLs
implements Runnable,
KeyAuthorizationKeyProvider.KeyACLs {
    private static final Logger LOG = LoggerFactory.getLogger(KMSACLs.class);
    private static final String UNAUTHORIZED_MSG_WITH_KEY = "User:%s not allowed to do '%s' on '%s'";
    private static final String UNAUTHORIZED_MSG_WITHOUT_KEY = "User:%s not allowed to do '%s'";
    public static final String ACL_DEFAULT = "*";
    public static final int RELOADER_SLEEP_MILLIS = 1000;
    private volatile Map<Type, AccessControlList> acls;
    private volatile Map<Type, AccessControlList> blacklistedAcls;
    @VisibleForTesting
    volatile Map<String, HashMap<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList>> keyAcls;
    private final Map<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList> defaultKeyAcls = new HashMap();
    private final Map<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList> whitelistKeyAcls = new HashMap();
    private ScheduledExecutorService executorService;
    private long lastReload;

    KMSACLs(Configuration conf) {
        if (conf == null) {
            conf = this.loadACLs();
        }
        this.setKMSACLs(conf);
        this.setKeyACLs(conf);
    }

    public KMSACLs() {
        this(null);
    }

    private void setKMSACLs(Configuration conf) {
        HashMap<Type, AccessControlList> tempAcls = new HashMap<Type, AccessControlList>();
        HashMap<Type, AccessControlList> tempBlacklist = new HashMap<Type, AccessControlList>();
        for (Type aclType : Type.values()) {
            String aclStr = conf.get(aclType.getAclConfigKey(), "*");
            tempAcls.put(aclType, new AccessControlList(aclStr));
            String blacklistStr = conf.get(aclType.getBlacklistConfigKey());
            if (blacklistStr != null) {
                tempBlacklist.put(aclType, new AccessControlList(blacklistStr));
                LOG.info("'{}' Blacklist '{}'", (Object)aclType, (Object)blacklistStr);
            }
            LOG.info("'{}' ACL '{}'", (Object)aclType, (Object)aclStr);
        }
        this.acls = tempAcls;
        this.blacklistedAcls = tempBlacklist;
    }

    private void setKeyACLs(Configuration conf) {
        String aclStr;
        HashMap<String, HashMap<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList>> tempKeyAcls = new HashMap<String, HashMap<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList>>();
        Map allKeyACLS = conf.getValByRegex("^key\\.acl\\..+");
        for (Map.Entry keyAcl : allKeyACLS.entrySet()) {
            int keyNameEnds;
            String k = (String)keyAcl.getKey();
            int keyNameStarts = "key.acl.".length();
            if (keyNameStarts >= (keyNameEnds = k.lastIndexOf("."))) {
                LOG.warn("Invalid key name '{}'", (Object)k);
                continue;
            }
            aclStr = (String)keyAcl.getValue();
            String keyName = k.substring(keyNameStarts, keyNameEnds);
            String keyOp = k.substring(keyNameEnds + 1);
            KeyAuthorizationKeyProvider.KeyOpType aclType = null;
            try {
                aclType = KeyAuthorizationKeyProvider.KeyOpType.valueOf((String)keyOp);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Invalid key Operation '{}'", (Object)keyOp);
            }
            if (aclType == null) continue;
            HashMap<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList> aclMap = (HashMap<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList>)tempKeyAcls.get(keyName);
            if (aclMap == null) {
                aclMap = new HashMap<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList>();
                tempKeyAcls.put(keyName, aclMap);
            }
            aclMap.put(aclType, new AccessControlList(aclStr));
            LOG.info("KEY_NAME '{}' KEY_OP '{}' ACL '{}'", new Object[]{keyName, aclType, aclStr});
        }
        this.keyAcls = tempKeyAcls;
        for (KeyAuthorizationKeyProvider.KeyOpType keyOp : KeyAuthorizationKeyProvider.KeyOpType.values()) {
            String confKey;
            if (!this.defaultKeyAcls.containsKey(keyOp) && (aclStr = conf.get(confKey = "default.key.acl." + keyOp)) != null) {
                if (keyOp == KeyAuthorizationKeyProvider.KeyOpType.ALL) {
                    LOG.warn("Should not configure default key ACL for KEY_OP '{}'", (Object)keyOp);
                } else {
                    if (aclStr.equals("*")) {
                        LOG.info("Default Key ACL for KEY_OP '{}' is set to '*'", (Object)keyOp);
                    }
                    this.defaultKeyAcls.put(keyOp, new AccessControlList(aclStr));
                }
            }
            if (this.whitelistKeyAcls.containsKey(keyOp) || (aclStr = conf.get(confKey = "whitelist.key.acl." + keyOp)) == null) continue;
            if (keyOp == KeyAuthorizationKeyProvider.KeyOpType.ALL) {
                LOG.warn("Should not configure whitelist key ACL for KEY_OP '{}'", (Object)keyOp);
                continue;
            }
            if (aclStr.equals("*")) {
                LOG.info("Whitelist Key ACL for KEY_OP '{}' is set to '*'", (Object)keyOp);
            }
            this.whitelistKeyAcls.put(keyOp, new AccessControlList(aclStr));
        }
    }

    @Override
    public void run() {
        try {
            if (KMSConfiguration.isACLsFileNewer((long)this.lastReload)) {
                this.setKMSACLs(this.loadACLs());
                this.setKeyACLs(this.loadACLs());
            }
        }
        catch (Exception ex) {
            LOG.warn(String.format("Could not reload ACLs file: '%s'", ex.toString()), (Throwable)ex);
        }
    }

    public synchronized void startReloader() {
        if (this.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1);
            this.executorService.scheduleAtFixedRate((Runnable)this, 1000L, 1000L, TimeUnit.MILLISECONDS);
        }
    }

    public synchronized void stopReloader() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }

    private Configuration loadACLs() {
        LOG.debug("Loading ACLs file");
        this.lastReload = System.currentTimeMillis();
        Configuration conf = KMSConfiguration.getACLsConf();
        conf.get(Type.CREATE.getAclConfigKey());
        return conf;
    }

    public boolean hasAccess(Type type, UserGroupInformation ugi) {
        boolean access = ((AccessControlList)this.acls.get(type)).isUserAllowed(ugi);
        if (access) {
            AccessControlList blacklist = (AccessControlList)this.blacklistedAcls.get(type);
            access = blacklist == null || !blacklist.isUserInList(ugi);
        }
        return access;
    }

    public void assertAccess(Type aclType, UserGroupInformation ugi, KMS.KMSOp operation, String key) throws AccessControlException {
        if (!KMSWebApp.getACLs().hasAccess(aclType, ugi)) {
            KMSWebApp.getUnauthorizedCallsMeter().mark();
            KMSWebApp.getKMSAudit().unauthorized(ugi, operation, key);
            throw new AuthorizationException(String.format(key != null ? "User:%s not allowed to do '%s' on '%s'" : "User:%s not allowed to do '%s'", ugi.getShortUserName(), operation, key));
        }
    }

    public boolean hasAccessToKey(String keyName, UserGroupInformation ugi, KeyAuthorizationKeyProvider.KeyOpType opType) {
        return this.checkKeyAccess(keyName, ugi, opType) || this.checkKeyAccess(this.whitelistKeyAcls, ugi, opType);
    }

    private boolean checkKeyAccess(String keyName, UserGroupInformation ugi, KeyAuthorizationKeyProvider.KeyOpType opType) {
        Map keyAcl = (Map)this.keyAcls.get(keyName);
        if (keyAcl == null) {
            keyAcl = this.defaultKeyAcls;
        }
        return this.checkKeyAccess(keyAcl, ugi, opType);
    }

    private boolean checkKeyAccess(Map<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList> keyAcl, UserGroupInformation ugi, KeyAuthorizationKeyProvider.KeyOpType opType) {
        AccessControlList acl = keyAcl.get(opType);
        if (acl == null) {
            return false;
        }
        return acl.isUserAllowed(ugi);
    }

    public boolean isACLPresent(String keyName, KeyAuthorizationKeyProvider.KeyOpType opType) {
        return this.keyAcls.containsKey(keyName) || this.defaultKeyAcls.containsKey(opType) || this.whitelistKeyAcls.containsKey(opType);
    }
}

