/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import java.io.File;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import org.apache.curator.test.TestingServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.kms.server.KMSACLs;
import org.apache.hadoop.crypto.key.kms.server.MiniKMS;
import org.apache.hadoop.crypto.key.kms.server.TestKMS;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticatedURL;
import org.junit.Test;

public class TestKMSWithZK {
    protected Configuration createBaseKMSConf(File keyStoreDir) throws Exception {
        Configuration conf = new Configuration(false);
        conf.set("hadoop.kms.key.provider.uri", "jceks://file@" + new Path(keyStoreDir.getAbsolutePath(), "kms.keystore").toUri());
        conf.set("hadoop.kms.authentication.type", "simple");
        conf.setBoolean("hadoop.kms.key.authorization.enable", false);
        conf.set(KMSACLs.Type.GET_KEYS.getAclConfigKey(), "foo");
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleKMSInstancesWithZKSigner() throws Exception {
        File testDir = TestKMS.getTestDir();
        Configuration conf = this.createBaseKMSConf(testDir);
        TestingServer zkServer = new TestingServer();
        zkServer.start();
        MiniKMS kms1 = null;
        MiniKMS kms2 = null;
        conf.set("hadoop.kms.authentication.signer.secret.provider", "zookeeper");
        conf.set("hadoop.kms.authentication.signer.secret.provider.zookeeper.connection.string", zkServer.getConnectString());
        conf.set("hadoop.kms.authentication.signer.secret.provider.zookeeper.path", "/secret");
        TestKMS.writeConf((File)testDir, (Configuration)conf);
        try {
            kms1 = new MiniKMS.Builder().setKmsConfDir(testDir).setLog4jConfFile("log4j.properties").build();
            kms1.start();
            kms2 = new MiniKMS.Builder().setKmsConfDir(testDir).setLog4jConfFile("log4j.properties").build();
            kms2.start();
            URL url1 = new URL(kms1.getKMSUrl().toExternalForm() + "/v1" + "/" + "keys/names");
            URL url2 = new URL(kms2.getKMSUrl().toExternalForm() + "/v1" + "/" + "keys/names");
            DelegationTokenAuthenticatedURL.Token token = new DelegationTokenAuthenticatedURL.Token();
            DelegationTokenAuthenticatedURL aUrl = new DelegationTokenAuthenticatedURL();
            UserGroupInformation ugiFoo = UserGroupInformation.createUserForTesting((String)"foo", (String[])new String[]{"gfoo"});
            UserGroupInformation ugiBar = UserGroupInformation.createUserForTesting((String)"bar", (String[])new String[]{"gBar"});
            ugiFoo.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
            ugiBar.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
            ugiBar.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
        }
        finally {
            if (kms2 != null) {
                kms2.stop();
            }
            if (kms1 != null) {
                kms1.stop();
            }
            zkServer.stop();
        }
    }
}

