/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.delegation.web.HttpUserGroupInformation;

@InterfaceAudience.Private
public class KMSMDCFilter
implements Filter {
    private static ThreadLocal<Data> DATA_TL = new ThreadLocal();

    public static UserGroupInformation getUgi() {
        return DATA_TL.get().ugi;
    }

    public static String getMethod() {
        return DATA_TL.get().method;
    }

    public static String getURL() {
        return DATA_TL.get().url.toString();
    }

    public void init(FilterConfig config) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            DATA_TL.remove();
            UserGroupInformation ugi = HttpUserGroupInformation.get();
            String method = ((HttpServletRequest)request).getMethod();
            StringBuffer requestURL = ((HttpServletRequest)request).getRequestURL();
            String queryString = ((HttpServletRequest)request).getQueryString();
            if (queryString != null) {
                requestURL.append("?").append(queryString);
            }
            DATA_TL.set(new Data(ugi, method, requestURL));
            chain.doFilter(request, response);
        }
        finally {
            DATA_TL.remove();
        }
    }

    public void destroy() {
    }

    private static class Data {
        private UserGroupInformation ugi;
        private String method;
        private StringBuffer url;

        private Data(UserGroupInformation ugi, String method, StringBuffer url) {
            this.ugi = ugi;
            this.method = method;
            this.url = url;
        }
    }
}

