/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import java.net.URI;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.crypto.key.UserProvider;
import org.apache.hadoop.crypto.key.kms.server.KeyAuthorizationKeyProvider;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Test;
import org.mockito.Mockito;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestKeyAuthorizationKeyProvider {
    private static final String CIPHER = "AES";

    @Test
    public void testCreateKey() throws Exception {
        Configuration conf = new Configuration();
        KeyProvider kp = new UserProvider.Factory().createProvider(new URI("user:///"), conf);
        KeyAuthorizationKeyProvider.KeyACLs mock = (KeyAuthorizationKeyProvider.KeyACLs)Mockito.mock(KeyAuthorizationKeyProvider.KeyACLs.class);
        Mockito.when((Object)mock.isACLPresent("foo", KeyAuthorizationKeyProvider.KeyOpType.MANAGEMENT)).thenReturn((Object)true);
        UserGroupInformation u1 = UserGroupInformation.createRemoteUser((String)"u1");
        Mockito.when((Object)mock.hasAccessToKey("foo", u1, KeyAuthorizationKeyProvider.KeyOpType.MANAGEMENT)).thenReturn((Object)true);
        KeyAuthorizationKeyProvider kpExt = new KeyAuthorizationKeyProvider(KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)kp), mock);
        u1.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
        UserGroupInformation.createRemoteUser((String)"badGuy").doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Test
    public void testOpsWhenACLAttributeExists() throws Exception {
        Configuration conf = new Configuration();
        KeyProvider kp = new UserProvider.Factory().createProvider(new URI("user:///"), conf);
        KeyAuthorizationKeyProvider.KeyACLs mock = (KeyAuthorizationKeyProvider.KeyACLs)Mockito.mock(KeyAuthorizationKeyProvider.KeyACLs.class);
        Mockito.when((Object)mock.isACLPresent("testKey", KeyAuthorizationKeyProvider.KeyOpType.MANAGEMENT)).thenReturn((Object)true);
        Mockito.when((Object)mock.isACLPresent("testKey", KeyAuthorizationKeyProvider.KeyOpType.GENERATE_EEK)).thenReturn((Object)true);
        Mockito.when((Object)mock.isACLPresent("testKey", KeyAuthorizationKeyProvider.KeyOpType.DECRYPT_EEK)).thenReturn((Object)true);
        Mockito.when((Object)mock.isACLPresent("testKey", KeyAuthorizationKeyProvider.KeyOpType.ALL)).thenReturn((Object)true);
        UserGroupInformation u1 = UserGroupInformation.createRemoteUser((String)"u1");
        UserGroupInformation u2 = UserGroupInformation.createRemoteUser((String)"u2");
        UserGroupInformation u3 = UserGroupInformation.createRemoteUser((String)"u3");
        UserGroupInformation sudo = UserGroupInformation.createRemoteUser((String)"sudo");
        Mockito.when((Object)mock.hasAccessToKey("testKey", u1, KeyAuthorizationKeyProvider.KeyOpType.MANAGEMENT)).thenReturn((Object)true);
        Mockito.when((Object)mock.hasAccessToKey("testKey", u2, KeyAuthorizationKeyProvider.KeyOpType.GENERATE_EEK)).thenReturn((Object)true);
        Mockito.when((Object)mock.hasAccessToKey("testKey", u3, KeyAuthorizationKeyProvider.KeyOpType.DECRYPT_EEK)).thenReturn((Object)true);
        Mockito.when((Object)mock.hasAccessToKey("testKey", sudo, KeyAuthorizationKeyProvider.KeyOpType.ALL)).thenReturn((Object)true);
        KeyAuthorizationKeyProvider kpExt = new KeyAuthorizationKeyProvider(KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)kp), mock);
        KeyProvider.KeyVersion barKv = (KeyProvider.KeyVersion)u1.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
        KeyProviderCryptoExtension.EncryptedKeyVersion barEKv = (KeyProviderCryptoExtension.EncryptedKeyVersion)u2.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
        u3.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
        sudo.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
    }

    private static KeyProvider.Options newOptions(Configuration conf) {
        KeyProvider.Options options = new KeyProvider.Options(conf);
        options.setCipher("AES");
        options.setBitLength(128);
        return options;
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDecryptWithKeyVersionNameKeyMismatch() throws Exception {
        Configuration conf = new Configuration();
        KeyProvider kp = new UserProvider.Factory().createProvider(new URI("user:///"), conf);
        KeyAuthorizationKeyProvider.KeyACLs mock = (KeyAuthorizationKeyProvider.KeyACLs)Mockito.mock(KeyAuthorizationKeyProvider.KeyACLs.class);
        Mockito.when((Object)mock.isACLPresent("testKey", KeyAuthorizationKeyProvider.KeyOpType.MANAGEMENT)).thenReturn((Object)true);
        Mockito.when((Object)mock.isACLPresent("testKey", KeyAuthorizationKeyProvider.KeyOpType.GENERATE_EEK)).thenReturn((Object)true);
        Mockito.when((Object)mock.isACLPresent("testKey", KeyAuthorizationKeyProvider.KeyOpType.DECRYPT_EEK)).thenReturn((Object)true);
        Mockito.when((Object)mock.isACLPresent("testKey", KeyAuthorizationKeyProvider.KeyOpType.ALL)).thenReturn((Object)true);
        UserGroupInformation u1 = UserGroupInformation.createRemoteUser((String)"u1");
        UserGroupInformation u2 = UserGroupInformation.createRemoteUser((String)"u2");
        UserGroupInformation u3 = UserGroupInformation.createRemoteUser((String)"u3");
        UserGroupInformation sudo = UserGroupInformation.createRemoteUser((String)"sudo");
        Mockito.when((Object)mock.hasAccessToKey("testKey", u1, KeyAuthorizationKeyProvider.KeyOpType.MANAGEMENT)).thenReturn((Object)true);
        Mockito.when((Object)mock.hasAccessToKey("testKey", u2, KeyAuthorizationKeyProvider.KeyOpType.GENERATE_EEK)).thenReturn((Object)true);
        Mockito.when((Object)mock.hasAccessToKey("testKey", u3, KeyAuthorizationKeyProvider.KeyOpType.DECRYPT_EEK)).thenReturn((Object)true);
        Mockito.when((Object)mock.hasAccessToKey("testKey", sudo, KeyAuthorizationKeyProvider.KeyOpType.ALL)).thenReturn((Object)true);
        KeyAuthorizationKeyProvider kpExt = new KeyAuthorizationKeyProvider(KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)kp), mock);
        sudo.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ KeyProvider.Options access$000(Configuration x0) {
        return TestKeyAuthorizationKeyProvider.newOptions((Configuration)x0);
    }
}

