/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import java.io.IOException;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.crypto.key.UserProvider;
import org.apache.hadoop.crypto.key.kms.server.KeyAuthorizationKeyProvider;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestKeyAuthorizationKeyProvider {
    private static final String CIPHER = "AES";

    @Test
    public void testCreateKey() throws Exception {
        Configuration conf = new Configuration();
        KeyProvider kp = new UserProvider.Factory().createProvider(new URI("user:///"), conf);
        KeyAuthorizationKeyProvider.KeyACLs mock = (KeyAuthorizationKeyProvider.KeyACLs)Mockito.mock(KeyAuthorizationKeyProvider.KeyACLs.class);
        Mockito.when((Object)mock.isACLPresent("foo", KeyAuthorizationKeyProvider.KeyOpType.MANAGEMENT)).thenReturn((Object)true);
        UserGroupInformation u1 = UserGroupInformation.createRemoteUser((String)"u1");
        Mockito.when((Object)mock.hasAccessToKey("foo", u1, KeyAuthorizationKeyProvider.KeyOpType.MANAGEMENT)).thenReturn((Object)true);
        KeyAuthorizationKeyProvider kpExt = new KeyAuthorizationKeyProvider(KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)kp), mock);
        u1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>((KeyProviderCryptoExtension)kpExt, conf){
            final /* synthetic */ KeyProviderCryptoExtension val$kpExt;
            final /* synthetic */ Configuration val$conf;
            {
                this.val$kpExt = keyProviderCryptoExtension;
                this.val$conf = configuration;
            }

            @Override
            public Void run() throws Exception {
                try {
                    this.val$kpExt.createKey("foo", SecureRandom.getSeed(16), TestKeyAuthorizationKeyProvider.newOptions(this.val$conf));
                }
                catch (IOException ioe) {
                    Assert.fail((String)"User should be Authorized !!");
                }
                try {
                    this.val$kpExt.createKey("bar", SecureRandom.getSeed(16), TestKeyAuthorizationKeyProvider.newOptions(this.val$conf));
                    Assert.fail((String)"User should NOT be Authorized !!");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        });
        UserGroupInformation.createRemoteUser((String)"badGuy").doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>((KeyProviderCryptoExtension)kpExt, conf){
            final /* synthetic */ KeyProviderCryptoExtension val$kpExt;
            final /* synthetic */ Configuration val$conf;
            {
                this.val$kpExt = keyProviderCryptoExtension;
                this.val$conf = configuration;
            }

            @Override
            public Void run() throws Exception {
                try {
                    this.val$kpExt.createKey("foo", SecureRandom.getSeed(16), TestKeyAuthorizationKeyProvider.newOptions(this.val$conf));
                    Assert.fail((String)"User should NOT be Authorized !!");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    @Test
    public void testOpsWhenACLAttributeExists() throws Exception {
        final Configuration conf = new Configuration();
        KeyProvider kp = new UserProvider.Factory().createProvider(new URI("user:///"), conf);
        KeyAuthorizationKeyProvider.KeyACLs mock = (KeyAuthorizationKeyProvider.KeyACLs)Mockito.mock(KeyAuthorizationKeyProvider.KeyACLs.class);
        Mockito.when((Object)mock.isACLPresent("testKey", KeyAuthorizationKeyProvider.KeyOpType.MANAGEMENT)).thenReturn((Object)true);
        Mockito.when((Object)mock.isACLPresent("testKey", KeyAuthorizationKeyProvider.KeyOpType.GENERATE_EEK)).thenReturn((Object)true);
        Mockito.when((Object)mock.isACLPresent("testKey", KeyAuthorizationKeyProvider.KeyOpType.DECRYPT_EEK)).thenReturn((Object)true);
        Mockito.when((Object)mock.isACLPresent("testKey", KeyAuthorizationKeyProvider.KeyOpType.ALL)).thenReturn((Object)true);
        UserGroupInformation u1 = UserGroupInformation.createRemoteUser((String)"u1");
        UserGroupInformation u2 = UserGroupInformation.createRemoteUser((String)"u2");
        UserGroupInformation u3 = UserGroupInformation.createRemoteUser((String)"u3");
        UserGroupInformation sudo = UserGroupInformation.createRemoteUser((String)"sudo");
        Mockito.when((Object)mock.hasAccessToKey("testKey", u1, KeyAuthorizationKeyProvider.KeyOpType.MANAGEMENT)).thenReturn((Object)true);
        Mockito.when((Object)mock.hasAccessToKey("testKey", u2, KeyAuthorizationKeyProvider.KeyOpType.GENERATE_EEK)).thenReturn((Object)true);
        Mockito.when((Object)mock.hasAccessToKey("testKey", u3, KeyAuthorizationKeyProvider.KeyOpType.DECRYPT_EEK)).thenReturn((Object)true);
        Mockito.when((Object)mock.hasAccessToKey("testKey", sudo, KeyAuthorizationKeyProvider.KeyOpType.ALL)).thenReturn((Object)true);
        KeyAuthorizationKeyProvider kpExt = new KeyAuthorizationKeyProvider(KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)kp), mock);
        KeyProvider.KeyVersion barKv = (KeyProvider.KeyVersion)u1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<KeyProvider.KeyVersion>((KeyProviderCryptoExtension)kpExt){
            final /* synthetic */ KeyProviderCryptoExtension val$kpExt;
            {
                this.val$kpExt = keyProviderCryptoExtension;
            }

            @Override
            public KeyProvider.KeyVersion run() throws Exception {
                KeyProvider.Options opt = TestKeyAuthorizationKeyProvider.newOptions(conf);
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("key.acl.name", "testKey");
                opt.setAttributes(m);
                try {
                    KeyProvider.KeyVersion kv = this.val$kpExt.createKey("foo", SecureRandom.getSeed(16), opt);
                    this.val$kpExt.rollNewVersion(kv.getName());
                    this.val$kpExt.rollNewVersion(kv.getName(), SecureRandom.getSeed(16));
                    this.val$kpExt.deleteKey(kv.getName());
                }
                catch (IOException ioe) {
                    Assert.fail((String)"User should be Authorized !!");
                }
                KeyProvider.KeyVersion retkv = null;
                try {
                    retkv = this.val$kpExt.createKey("bar", SecureRandom.getSeed(16), opt);
                    this.val$kpExt.generateEncryptedKey(retkv.getName());
                    Assert.fail((String)"User should NOT be Authorized to generate EEK !!");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Assert.assertNotNull(retkv);
                return retkv;
            }
        });
        KeyProviderCryptoExtension.EncryptedKeyVersion barEKv = (KeyProviderCryptoExtension.EncryptedKeyVersion)u2.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<KeyProviderCryptoExtension.EncryptedKeyVersion>((KeyProviderCryptoExtension)kpExt, barKv){
            final /* synthetic */ KeyProviderCryptoExtension val$kpExt;
            final /* synthetic */ KeyProvider.KeyVersion val$barKv;
            {
                this.val$kpExt = keyProviderCryptoExtension;
                this.val$barKv = keyVersion;
            }

            @Override
            public KeyProviderCryptoExtension.EncryptedKeyVersion run() throws Exception {
                try {
                    this.val$kpExt.deleteKey(this.val$barKv.getName());
                    Assert.fail((String)"User should NOT be Authorized to perform any other operation !!");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return this.val$kpExt.generateEncryptedKey(this.val$barKv.getName());
            }
        });
        u3.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<KeyProvider.KeyVersion>((KeyProviderCryptoExtension)kpExt, barKv, barEKv){
            final /* synthetic */ KeyProviderCryptoExtension val$kpExt;
            final /* synthetic */ KeyProvider.KeyVersion val$barKv;
            final /* synthetic */ KeyProviderCryptoExtension.EncryptedKeyVersion val$barEKv;
            {
                this.val$kpExt = keyProviderCryptoExtension;
                this.val$barKv = keyVersion;
                this.val$barEKv = encryptedKeyVersion;
            }

            @Override
            public KeyProvider.KeyVersion run() throws Exception {
                try {
                    this.val$kpExt.deleteKey(this.val$barKv.getName());
                    Assert.fail((String)"User should NOT be Authorized to perform any other operation !!");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return this.val$kpExt.decryptEncryptedKey(this.val$barEKv);
            }
        });
        sudo.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>((KeyProviderCryptoExtension)kpExt){
            final /* synthetic */ KeyProviderCryptoExtension val$kpExt;
            {
                this.val$kpExt = keyProviderCryptoExtension;
            }

            @Override
            public Void run() throws Exception {
                KeyProvider.Options opt = TestKeyAuthorizationKeyProvider.newOptions(conf);
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("key.acl.name", "testKey");
                opt.setAttributes(m);
                try {
                    KeyProvider.KeyVersion kv = this.val$kpExt.createKey("foo", SecureRandom.getSeed(16), opt);
                    this.val$kpExt.rollNewVersion(kv.getName());
                    this.val$kpExt.rollNewVersion(kv.getName(), SecureRandom.getSeed(16));
                    KeyProviderCryptoExtension.EncryptedKeyVersion ekv = this.val$kpExt.generateEncryptedKey(kv.getName());
                    this.val$kpExt.decryptEncryptedKey(ekv);
                    this.val$kpExt.deleteKey(kv.getName());
                }
                catch (IOException ioe) {
                    Assert.fail((String)"User should be Allowed to do everything !!");
                }
                return null;
            }
        });
    }

    private static KeyProvider.Options newOptions(Configuration conf) {
        KeyProvider.Options options = new KeyProvider.Options(conf);
        options.setCipher(CIPHER);
        options.setBitLength(128);
        return options;
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDecryptWithKeyVersionNameKeyMismatch() throws Exception {
        final Configuration conf = new Configuration();
        KeyProvider kp = new UserProvider.Factory().createProvider(new URI("user:///"), conf);
        KeyAuthorizationKeyProvider.KeyACLs mock = (KeyAuthorizationKeyProvider.KeyACLs)Mockito.mock(KeyAuthorizationKeyProvider.KeyACLs.class);
        Mockito.when((Object)mock.isACLPresent("testKey", KeyAuthorizationKeyProvider.KeyOpType.MANAGEMENT)).thenReturn((Object)true);
        Mockito.when((Object)mock.isACLPresent("testKey", KeyAuthorizationKeyProvider.KeyOpType.GENERATE_EEK)).thenReturn((Object)true);
        Mockito.when((Object)mock.isACLPresent("testKey", KeyAuthorizationKeyProvider.KeyOpType.DECRYPT_EEK)).thenReturn((Object)true);
        Mockito.when((Object)mock.isACLPresent("testKey", KeyAuthorizationKeyProvider.KeyOpType.ALL)).thenReturn((Object)true);
        UserGroupInformation u1 = UserGroupInformation.createRemoteUser((String)"u1");
        UserGroupInformation u2 = UserGroupInformation.createRemoteUser((String)"u2");
        UserGroupInformation u3 = UserGroupInformation.createRemoteUser((String)"u3");
        UserGroupInformation sudo = UserGroupInformation.createRemoteUser((String)"sudo");
        Mockito.when((Object)mock.hasAccessToKey("testKey", u1, KeyAuthorizationKeyProvider.KeyOpType.MANAGEMENT)).thenReturn((Object)true);
        Mockito.when((Object)mock.hasAccessToKey("testKey", u2, KeyAuthorizationKeyProvider.KeyOpType.GENERATE_EEK)).thenReturn((Object)true);
        Mockito.when((Object)mock.hasAccessToKey("testKey", u3, KeyAuthorizationKeyProvider.KeyOpType.DECRYPT_EEK)).thenReturn((Object)true);
        Mockito.when((Object)mock.hasAccessToKey("testKey", sudo, KeyAuthorizationKeyProvider.KeyOpType.ALL)).thenReturn((Object)true);
        KeyAuthorizationKeyProvider kpExt = new KeyAuthorizationKeyProvider(KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)kp), mock);
        sudo.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>((KeyProviderCryptoExtension)kpExt){
            final /* synthetic */ KeyProviderCryptoExtension val$kpExt;
            {
                this.val$kpExt = keyProviderCryptoExtension;
            }

            @Override
            public Void run() throws Exception {
                KeyProvider.Options opt = TestKeyAuthorizationKeyProvider.newOptions(conf);
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("key.acl.name", "testKey");
                opt.setAttributes(m);
                KeyProvider.KeyVersion kv = this.val$kpExt.createKey("foo", SecureRandom.getSeed(16), opt);
                this.val$kpExt.rollNewVersion(kv.getName());
                this.val$kpExt.rollNewVersion(kv.getName(), SecureRandom.getSeed(16));
                KeyProviderCryptoExtension.EncryptedKeyVersion ekv = this.val$kpExt.generateEncryptedKey(kv.getName());
                ekv = KeyProviderCryptoExtension.EncryptedKeyVersion.createForDecryption((String)(ekv.getEncryptionKeyName() + "x"), (String)ekv.getEncryptionKeyVersionName(), (byte[])ekv.getEncryptedKeyIv(), (byte[])ekv.getEncryptedKeyVersion().getMaterial());
                this.val$kpExt.decryptEncryptedKey(ekv);
                return null;
            }
        });
    }
}

