/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.GuiceServletContextListener;
import com.google.inject.servlet.ServletModule;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.test.framework.AppDescriptor;
import com.sun.jersey.test.framework.JerseyTest;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.MockAppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.webapp.AMWebServices;
import org.apache.hadoop.mapreduce.v2.app.webapp.JAXBContextResolver;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestAMWebServicesJobConf
extends JerseyTest {
    private static Configuration conf = new Configuration();
    private static AppContext appContext;
    private static File testConfDir;
    private Injector injector = Guice.createInjector((Module[])new Module[]{new ServletModule(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void configureServlets() {
            Path confPath = new Path(testConfDir.toString(), "job.xml");
            Configuration config = new Configuration();
            try {
                LocalFileSystem localFs = FileSystem.getLocal((Configuration)config);
                confPath = localFs.makeQualified(confPath);
                try (FSDataOutputStream out = localFs.create(confPath);){
                    conf.writeXml((OutputStream)out);
                }
                if (!localFs.exists(confPath)) {
                    Assert.fail((String)("error creating config file: " + confPath));
                }
            }
            catch (IOException e) {
                Assert.fail((String)("error creating config file: " + e.getMessage()));
            }
            appContext = new MockAppContext(0, 2, 1, confPath);
            this.bind(JAXBContextResolver.class);
            this.bind(AMWebServices.class);
            this.bind(GenericExceptionHandler.class);
            this.bind(AppContext.class).toInstance((Object)appContext);
            this.bind(Configuration.class).toInstance((Object)conf);
            this.serve("/*", new String[0]).with(GuiceContainer.class);
        }
    }});

    @Before
    public void setUp() throws Exception {
        super.setUp();
        testConfDir.mkdir();
    }

    @AfterClass
    public static void stop() {
        FileUtil.fullyDelete((File)testConfDir);
    }

    public TestAMWebServicesJobConf() {
        super((AppDescriptor)new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.mapreduce.v2.app.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build());
    }

    @Test
    public void testJobConf() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("conf").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject info = json.getJSONObject("conf");
            this.verifyAMJobConf(info, (Job)jobsMap.get(id));
        }
    }

    @Test
    public void testJobConfSlash() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("conf/").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject info = json.getJSONObject("conf");
            this.verifyAMJobConf(info, (Job)jobsMap.get(id));
        }
    }

    @Test
    public void testJobConfDefault() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("conf").get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject info = json.getJSONObject("conf");
            this.verifyAMJobConf(info, (Job)jobsMap.get(id));
        }
    }

    @Test
    public void testJobConfXML() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("conf").accept(new String[]{"application/xml"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
            String xml = (String)response.getEntity(String.class);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xml));
            Document dom = db.parse(is);
            NodeList info = dom.getElementsByTagName("conf");
            this.verifyAMJobConfXML(info, (Job)jobsMap.get(id));
        }
    }

    public void verifyAMJobConf(JSONObject info, Job job) throws JSONException {
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)info.length());
        WebServicesTestUtils.checkStringMatch((String)"path", (String)job.getConfFile().toString(), (String)info.getString("path"));
        JSONArray properties = info.getJSONArray("property");
        for (int i = 0; i < properties.length(); ++i) {
            JSONObject prop = properties.getJSONObject(i);
            String name = prop.getString("name");
            String value = prop.getString("value");
            Assert.assertTrue((String)"name not set", (name != null && !name.isEmpty() ? 1 : 0) != 0);
            Assert.assertTrue((String)"value not set", (value != null && !value.isEmpty() ? 1 : 0) != 0);
        }
    }

    public void verifyAMJobConfXML(NodeList nodes, Job job) {
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            WebServicesTestUtils.checkStringMatch((String)"path", (String)job.getConfFile().toString(), (String)WebServicesTestUtils.getXmlString((Element)element, (String)"path"));
            NodeList properties = element.getElementsByTagName("property");
            for (int j = 0; j < properties.getLength(); ++j) {
                Element property = (Element)properties.item(j);
                Assert.assertNotNull((String)"should have counters in the web service info", (Object)property);
                String name = WebServicesTestUtils.getXmlString((Element)property, (String)"name");
                String value = WebServicesTestUtils.getXmlString((Element)property, (String)"value");
                Assert.assertTrue((String)"name not set", (name != null && !name.isEmpty() ? 1 : 0) != 0);
                Assert.assertTrue((String)"name not set", (value != null && !value.isEmpty() ? 1 : 0) != 0);
            }
        }
    }

    static {
        testConfDir = new File("target", TestAMWebServicesJobConf.class.getSimpleName() + "confDir");
    }

    public class GuiceServletConfig
    extends GuiceServletContextListener {
        protected Injector getInjector() {
            return TestAMWebServicesJobConf.this.injector;
        }
    }
}

