/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import java.io.IOException;
import java.util.Iterator;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.webapp.App;
import org.apache.hadoop.mapreduce.v2.app.webapp.AppControllerForTest;
import org.apache.hadoop.mapreduce.v2.app.webapp.AttemptsPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.CountersPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.JobConfPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.JobPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.SingleCounterPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.TaskPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.TasksPage;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.webapp.Controller;
import org.apache.hadoop.yarn.webapp.ResponseInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAppController {
    private AppControllerForTest appController;
    private Controller.RequestContext ctx;
    private Job job;

    @Before
    public void setUp() throws IOException {
        AppContext context = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)context.getApplicationID()).thenReturn((Object)ApplicationId.newInstance((long)0L, (int)0));
        Mockito.when((Object)context.getApplicationName()).thenReturn((Object)"AppName");
        Mockito.when((Object)context.getUser()).thenReturn((Object)"User");
        Mockito.when((Object)context.getStartTime()).thenReturn((Object)System.currentTimeMillis());
        this.job = (Job)Mockito.mock(Job.class);
        Task task = (Task)Mockito.mock(Task.class);
        Mockito.when((Object)this.job.getTask((TaskId)Mockito.any(TaskId.class))).thenReturn((Object)task);
        JobId jobID = MRApps.toJobID((String)"job_01_01");
        Mockito.when((Object)context.getJob(jobID)).thenReturn((Object)this.job);
        Mockito.when((Object)this.job.checkAccess((UserGroupInformation)Mockito.any(UserGroupInformation.class), (JobACL)Mockito.any(JobACL.class))).thenReturn((Object)true);
        App app = new App(context);
        Configuration configuration = new Configuration();
        this.ctx = (Controller.RequestContext)Mockito.mock(Controller.RequestContext.class);
        this.appController = new AppControllerForTest(app, configuration, this.ctx);
        this.appController.getProperty().put("job.id", "job_01_01");
        this.appController.getProperty().put("task.id", "task_01_01_m01_01");
    }

    @Test
    public void testBadRequest() {
        String message = "test string";
        this.appController.badRequest(message);
        this.verifyExpectations(message);
    }

    @Test
    public void testBadRequestWithNullMessage() {
        this.appController.badRequest(null);
        this.verifyExpectations("");
    }

    private void verifyExpectations(String message) {
        ((Controller.RequestContext)Mockito.verify((Object)this.ctx)).setStatus(400);
        Assert.assertEquals((Object)"application_0_0000", (Object)this.appController.getProperty().get("app.id"));
        Assert.assertNotNull((Object)this.appController.getProperty().get("rm.web"));
        Assert.assertEquals((Object)("Bad request: " + message), (Object)this.appController.getProperty().get("title"));
    }

    @Test
    public void testInfo() {
        this.appController.info();
        Iterator iterator = this.appController.getResponseInfo().iterator();
        ResponseInfo.Item item = (ResponseInfo.Item)iterator.next();
        Assert.assertEquals((Object)"Application ID:", (Object)item.key);
        Assert.assertEquals((Object)"application_0_0000", (Object)item.value);
        item = (ResponseInfo.Item)iterator.next();
        Assert.assertEquals((Object)"Application Name:", (Object)item.key);
        Assert.assertEquals((Object)"AppName", (Object)item.value);
        item = (ResponseInfo.Item)iterator.next();
        Assert.assertEquals((Object)"User:", (Object)item.key);
        Assert.assertEquals((Object)"User", (Object)item.value);
        item = (ResponseInfo.Item)iterator.next();
        Assert.assertEquals((Object)"Started on:", (Object)item.key);
        item = (ResponseInfo.Item)iterator.next();
        Assert.assertEquals((Object)"Elasped: ", (Object)item.key);
    }

    @Test
    public void testGetJob() {
        Mockito.when((Object)this.job.checkAccess((UserGroupInformation)Mockito.any(UserGroupInformation.class), (JobACL)Mockito.any(JobACL.class))).thenReturn((Object)false);
        this.appController.job();
        ((HttpServletResponse)Mockito.verify((Object)this.appController.response())).setContentType("text/plain; charset=UTF-8");
        Assert.assertEquals((Object)"Access denied: User user does not have permission to view job job_01_01", (Object)this.appController.getData());
        Mockito.when((Object)this.job.checkAccess((UserGroupInformation)Mockito.any(UserGroupInformation.class), (JobACL)Mockito.any(JobACL.class))).thenReturn((Object)true);
        this.appController.getProperty().remove("job.id");
        this.appController.job();
        Assert.assertEquals((Object)"Access denied: User user does not have permission to view job job_01_01Bad Request: Missing job ID", (Object)this.appController.getData());
        this.appController.getProperty().put("job.id", "job_01_01");
        this.appController.job();
        Assert.assertEquals(JobPage.class, this.appController.getClazz());
    }

    @Test
    public void testGetJobCounters() {
        Mockito.when((Object)this.job.checkAccess((UserGroupInformation)Mockito.any(UserGroupInformation.class), (JobACL)Mockito.any(JobACL.class))).thenReturn((Object)false);
        this.appController.jobCounters();
        ((HttpServletResponse)Mockito.verify((Object)this.appController.response())).setContentType("text/plain; charset=UTF-8");
        Assert.assertEquals((Object)"Access denied: User user does not have permission to view job job_01_01", (Object)this.appController.getData());
        Mockito.when((Object)this.job.checkAccess((UserGroupInformation)Mockito.any(UserGroupInformation.class), (JobACL)Mockito.any(JobACL.class))).thenReturn((Object)true);
        this.appController.getProperty().remove("job.id");
        this.appController.jobCounters();
        Assert.assertEquals((Object)"Access denied: User user does not have permission to view job job_01_01Bad Request: Missing job ID", (Object)this.appController.getData());
        this.appController.getProperty().put("job.id", "job_01_01");
        this.appController.jobCounters();
        Assert.assertEquals(CountersPage.class, this.appController.getClazz());
    }

    @Test
    public void testGetTaskCounters() {
        Mockito.when((Object)this.job.checkAccess((UserGroupInformation)Mockito.any(UserGroupInformation.class), (JobACL)Mockito.any(JobACL.class))).thenReturn((Object)false);
        this.appController.taskCounters();
        ((HttpServletResponse)Mockito.verify((Object)this.appController.response())).setContentType("text/plain; charset=UTF-8");
        Assert.assertEquals((Object)"Access denied: User user does not have permission to view job job_01_01", (Object)this.appController.getData());
        Mockito.when((Object)this.job.checkAccess((UserGroupInformation)Mockito.any(UserGroupInformation.class), (JobACL)Mockito.any(JobACL.class))).thenReturn((Object)true);
        this.appController.getProperty().remove("task.id");
        this.appController.taskCounters();
        Assert.assertEquals((Object)"Access denied: User user does not have permission to view job job_01_01missing task ID", (Object)this.appController.getData());
        this.appController.getProperty().put("task.id", "task_01_01_m01_01");
        this.appController.taskCounters();
        Assert.assertEquals(CountersPage.class, this.appController.getClazz());
    }

    @Test
    public void testGetSingleJobCounter() throws IOException {
        this.appController.singleJobCounter();
        Assert.assertEquals(SingleCounterPage.class, this.appController.getClazz());
    }

    @Test
    public void testGetSingleTaskCounter() throws IOException {
        this.appController.singleTaskCounter();
        Assert.assertEquals(SingleCounterPage.class, this.appController.getClazz());
        Assert.assertNotNull((Object)this.appController.getProperty().get("counter.group"));
        Assert.assertNotNull((Object)this.appController.getProperty().get("counter.name"));
    }

    @Test
    public void testTasks() {
        this.appController.tasks();
        Assert.assertEquals(TasksPage.class, this.appController.getClazz());
    }

    @Test
    public void testTask() {
        this.appController.task();
        Assert.assertEquals((Object)"Attempts for task_01_01_m01_01", (Object)this.appController.getProperty().get("title"));
        Assert.assertEquals(TaskPage.class, this.appController.getClazz());
    }

    @Test
    public void testConfiguration() {
        this.appController.conf();
        Assert.assertEquals(JobConfPage.class, this.appController.getClazz());
    }

    @Test
    public void testAttempts() {
        this.appController.getProperty().remove("task.type");
        Mockito.when((Object)this.job.checkAccess((UserGroupInformation)Mockito.any(UserGroupInformation.class), (JobACL)Mockito.any(JobACL.class))).thenReturn((Object)false);
        this.appController.attempts();
        ((HttpServletResponse)Mockito.verify((Object)this.appController.response())).setContentType("text/plain; charset=UTF-8");
        Assert.assertEquals((Object)"Access denied: User user does not have permission to view job job_01_01", (Object)this.appController.getData());
        Mockito.when((Object)this.job.checkAccess((UserGroupInformation)Mockito.any(UserGroupInformation.class), (JobACL)Mockito.any(JobACL.class))).thenReturn((Object)true);
        this.appController.getProperty().remove("task.id");
        this.appController.attempts();
        Assert.assertEquals((Object)"Access denied: User user does not have permission to view job job_01_01", (Object)this.appController.getData());
        this.appController.getProperty().put("task.id", "task_01_01_m01_01");
        this.appController.attempts();
        Assert.assertEquals((Object)"Bad request: missing task-type.", (Object)this.appController.getProperty().get("title"));
        this.appController.getProperty().put("task.type", "m");
        this.appController.attempts();
        Assert.assertEquals((Object)"Bad request: missing attempt-state.", (Object)this.appController.getProperty().get("title"));
        this.appController.getProperty().put("attempt.state", "State");
        this.appController.attempts();
        Assert.assertEquals(AttemptsPage.class, this.appController.getClazz());
    }
}

