/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.EventReader;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.EventWriter;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JhCounters;
import org.apache.hadoop.mapreduce.jobhistory.JobPriorityChange;
import org.apache.hadoop.mapreduce.jobhistory.JobPriorityChangeEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobQueueChangeEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobStatusChanged;
import org.apache.hadoop.mapreduce.jobhistory.JobUnsuccessfulCompletion;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptFinished;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptStarted;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptUnsuccessfulCompletion;
import org.apache.hadoop.mapreduce.jobhistory.TaskUpdated;
import org.apache.hadoop.mapreduce.jobhistory.TaskUpdatedEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.junit.Assert;
import org.junit.Test;

public class TestEvents {
    private static final String taskId = "task_1_2_r_3";

    @Test(timeout=10000L)
    public void testTaskAttemptFinishedEvent() throws Exception {
        JobID jid = new JobID("001", 1);
        TaskID tid = new TaskID(jid, TaskType.REDUCE, 2);
        TaskAttemptID taskAttemptId = new TaskAttemptID(tid, 3);
        Counters counters = new Counters();
        TaskAttemptFinishedEvent test = new TaskAttemptFinishedEvent(taskAttemptId, TaskType.REDUCE, "TEST", 123L, "RAKNAME", "HOSTNAME", "STATUS", counters, 234L);
        Assert.assertEquals((Object)test.getAttemptId().toString(), (Object)taskAttemptId.toString());
        Assert.assertEquals((Object)test.getCounters(), (Object)counters);
        Assert.assertEquals((long)test.getFinishTime(), (long)123L);
        Assert.assertEquals((Object)test.getHostname(), (Object)"HOSTNAME");
        Assert.assertEquals((Object)test.getRackName(), (Object)"RAKNAME");
        Assert.assertEquals((Object)test.getState(), (Object)"STATUS");
        Assert.assertEquals((Object)test.getTaskId(), (Object)tid);
        Assert.assertEquals((Object)test.getTaskStatus(), (Object)"TEST");
        Assert.assertEquals((Object)test.getTaskType(), (Object)TaskType.REDUCE);
        Assert.assertEquals((long)234L, (long)test.getStartTime());
    }

    @Test(timeout=10000L)
    public void testJobPriorityChange() throws Exception {
        JobID jid = new JobID("001", 1);
        JobPriorityChangeEvent test = new JobPriorityChangeEvent(jid, JobPriority.LOW);
        Assert.assertEquals((Object)test.getJobId().toString(), (Object)jid.toString());
        Assert.assertEquals((Object)test.getPriority(), (Object)JobPriority.LOW);
    }

    @Test(timeout=10000L)
    public void testJobQueueChange() throws Exception {
        JobID jid = new JobID("001", 1);
        JobQueueChangeEvent test = new JobQueueChangeEvent(jid, "newqueue");
        Assert.assertEquals((Object)test.getJobId().toString(), (Object)jid.toString());
        Assert.assertEquals((Object)test.getJobQueueName(), (Object)"newqueue");
    }

    @Test(timeout=10000L)
    public void testTaskUpdated() throws Exception {
        JobID jid = new JobID("001", 1);
        TaskID tid = new TaskID(jid, TaskType.REDUCE, 2);
        TaskUpdatedEvent test = new TaskUpdatedEvent(tid, 1234L);
        Assert.assertEquals((Object)test.getTaskId().toString(), (Object)tid.toString());
        Assert.assertEquals((long)test.getFinishTime(), (long)1234L);
    }

    @Test(timeout=10000L)
    public void testEvents() throws Exception {
        EventReader reader = new EventReader(new DataInputStream(new ByteArrayInputStream(this.getEvents())));
        HistoryEvent e = reader.getNextEvent();
        Assert.assertTrue((boolean)e.getEventType().equals((Object)EventType.JOB_PRIORITY_CHANGED));
        Assert.assertEquals((Object)"ID", (Object)((JobPriorityChange)e.getDatum()).getJobid().toString());
        e = reader.getNextEvent();
        Assert.assertTrue((boolean)e.getEventType().equals((Object)EventType.JOB_STATUS_CHANGED));
        Assert.assertEquals((Object)"ID", (Object)((JobStatusChanged)e.getDatum()).getJobid().toString());
        e = reader.getNextEvent();
        Assert.assertTrue((boolean)e.getEventType().equals((Object)EventType.TASK_UPDATED));
        Assert.assertEquals((Object)"ID", (Object)((TaskUpdated)e.getDatum()).getTaskid().toString());
        e = reader.getNextEvent();
        Assert.assertTrue((boolean)e.getEventType().equals((Object)EventType.REDUCE_ATTEMPT_KILLED));
        Assert.assertEquals((Object)taskId, (Object)((TaskAttemptUnsuccessfulCompletion)e.getDatum()).getTaskid().toString());
        e = reader.getNextEvent();
        Assert.assertTrue((boolean)e.getEventType().equals((Object)EventType.JOB_KILLED));
        Assert.assertEquals((Object)"ID", (Object)((JobUnsuccessfulCompletion)e.getDatum()).getJobid().toString());
        e = reader.getNextEvent();
        Assert.assertTrue((boolean)e.getEventType().equals((Object)EventType.REDUCE_ATTEMPT_STARTED));
        Assert.assertEquals((Object)taskId, (Object)((TaskAttemptStarted)e.getDatum()).getTaskid().toString());
        e = reader.getNextEvent();
        Assert.assertTrue((boolean)e.getEventType().equals((Object)EventType.REDUCE_ATTEMPT_FINISHED));
        Assert.assertEquals((Object)taskId, (Object)((TaskAttemptFinished)e.getDatum()).getTaskid().toString());
        e = reader.getNextEvent();
        Assert.assertTrue((boolean)e.getEventType().equals((Object)EventType.REDUCE_ATTEMPT_KILLED));
        Assert.assertEquals((Object)taskId, (Object)((TaskAttemptUnsuccessfulCompletion)e.getDatum()).getTaskid().toString());
        e = reader.getNextEvent();
        Assert.assertTrue((boolean)e.getEventType().equals((Object)EventType.REDUCE_ATTEMPT_KILLED));
        Assert.assertEquals((Object)taskId, (Object)((TaskAttemptUnsuccessfulCompletion)e.getDatum()).getTaskid().toString());
        e = reader.getNextEvent();
        Assert.assertTrue((boolean)e.getEventType().equals((Object)EventType.REDUCE_ATTEMPT_STARTED));
        Assert.assertEquals((Object)taskId, (Object)((TaskAttemptStarted)e.getDatum()).getTaskid().toString());
        e = reader.getNextEvent();
        Assert.assertTrue((boolean)e.getEventType().equals((Object)EventType.REDUCE_ATTEMPT_FINISHED));
        Assert.assertEquals((Object)taskId, (Object)((TaskAttemptFinished)e.getDatum()).getTaskid().toString());
        e = reader.getNextEvent();
        Assert.assertTrue((boolean)e.getEventType().equals((Object)EventType.REDUCE_ATTEMPT_KILLED));
        Assert.assertEquals((Object)taskId, (Object)((TaskAttemptUnsuccessfulCompletion)e.getDatum()).getTaskid().toString());
        e = reader.getNextEvent();
        Assert.assertTrue((boolean)e.getEventType().equals((Object)EventType.REDUCE_ATTEMPT_KILLED));
        Assert.assertEquals((Object)taskId, (Object)((TaskAttemptUnsuccessfulCompletion)e.getDatum()).getTaskid().toString());
        reader.close();
    }

    private byte[] getEvents() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        FSDataOutputStream fsOutput = new FSDataOutputStream((OutputStream)output, new FileSystem.Statistics("scheme"));
        EventWriter writer = new EventWriter(fsOutput, EventWriter.WriteMode.JSON);
        writer.write((HistoryEvent)this.getJobPriorityChangedEvent());
        writer.write((HistoryEvent)this.getJobStatusChangedEvent());
        writer.write((HistoryEvent)this.getTaskUpdatedEvent());
        writer.write((HistoryEvent)this.getReduceAttemptKilledEvent());
        writer.write((HistoryEvent)this.getJobKilledEvent());
        writer.write((HistoryEvent)this.getSetupAttemptStartedEvent());
        writer.write((HistoryEvent)this.getTaskAttemptFinishedEvent());
        writer.write((HistoryEvent)this.getSetupAttemptFieledEvent());
        writer.write((HistoryEvent)this.getSetupAttemptKilledEvent());
        writer.write((HistoryEvent)this.getCleanupAttemptStartedEvent());
        writer.write((HistoryEvent)this.getCleanupAttemptFinishedEvent());
        writer.write((HistoryEvent)this.getCleanupAttemptFiledEvent());
        writer.write((HistoryEvent)this.getCleanupAttemptKilledEvent());
        writer.flush();
        writer.close();
        return output.toByteArray();
    }

    private FakeEvent getCleanupAttemptKilledEvent() {
        FakeEvent result = new FakeEvent(EventType.CLEANUP_ATTEMPT_KILLED);
        result.setDatum(this.getTaskAttemptUnsuccessfulCompletion());
        return result;
    }

    private FakeEvent getCleanupAttemptFiledEvent() {
        FakeEvent result = new FakeEvent(EventType.CLEANUP_ATTEMPT_FAILED);
        result.setDatum(this.getTaskAttemptUnsuccessfulCompletion());
        return result;
    }

    private TaskAttemptUnsuccessfulCompletion getTaskAttemptUnsuccessfulCompletion() {
        TaskAttemptUnsuccessfulCompletion datum = new TaskAttemptUnsuccessfulCompletion();
        datum.setAttemptId((CharSequence)"attempt_1_2_r3_4_5");
        datum.setClockSplits(Arrays.asList(1, 2, 3));
        datum.setCpuUsages(Arrays.asList(100, 200, 300));
        datum.setError((CharSequence)"Error");
        datum.setFinishTime(Long.valueOf(2L));
        datum.setHostname((CharSequence)"hostname");
        datum.setRackname((CharSequence)"rackname");
        datum.setPhysMemKbytes(Arrays.asList(1000, 2000, 3000));
        datum.setTaskid((CharSequence)taskId);
        datum.setPort(Integer.valueOf(1000));
        datum.setTaskType((CharSequence)"REDUCE");
        datum.setStatus((CharSequence)"STATUS");
        datum.setCounters(this.getCounters());
        datum.setVMemKbytes(Arrays.asList(1000, 2000, 3000));
        return datum;
    }

    private JhCounters getCounters() {
        JhCounters counters = new JhCounters();
        counters.setGroups(new ArrayList(0));
        counters.setName((CharSequence)"name");
        return counters;
    }

    private FakeEvent getCleanupAttemptFinishedEvent() {
        FakeEvent result = new FakeEvent(EventType.CLEANUP_ATTEMPT_FINISHED);
        TaskAttemptFinished datum = new TaskAttemptFinished();
        datum.setAttemptId((CharSequence)"attempt_1_2_r3_4_5");
        datum.setCounters(this.getCounters());
        datum.setFinishTime(Long.valueOf(2L));
        datum.setHostname((CharSequence)"hostname");
        datum.setRackname((CharSequence)"rackName");
        datum.setState((CharSequence)"state");
        datum.setTaskid((CharSequence)taskId);
        datum.setTaskStatus((CharSequence)"taskStatus");
        datum.setTaskType((CharSequence)"REDUCE");
        result.setDatum(datum);
        return result;
    }

    private FakeEvent getCleanupAttemptStartedEvent() {
        FakeEvent result = new FakeEvent(EventType.CLEANUP_ATTEMPT_STARTED);
        TaskAttemptStarted datum = new TaskAttemptStarted();
        datum.setAttemptId((CharSequence)"attempt_1_2_r3_4_5");
        datum.setAvataar((CharSequence)"avatar");
        datum.setContainerId((CharSequence)"containerId");
        datum.setHttpPort(Integer.valueOf(10000));
        datum.setLocality((CharSequence)"locality");
        datum.setShufflePort(Integer.valueOf(10001));
        datum.setStartTime(Long.valueOf(1L));
        datum.setTaskid((CharSequence)taskId);
        datum.setTaskType((CharSequence)"taskType");
        datum.setTrackerName((CharSequence)"trackerName");
        result.setDatum(datum);
        return result;
    }

    private FakeEvent getSetupAttemptKilledEvent() {
        FakeEvent result = new FakeEvent(EventType.SETUP_ATTEMPT_KILLED);
        result.setDatum(this.getTaskAttemptUnsuccessfulCompletion());
        return result;
    }

    private FakeEvent getSetupAttemptFieledEvent() {
        FakeEvent result = new FakeEvent(EventType.SETUP_ATTEMPT_FAILED);
        result.setDatum(this.getTaskAttemptUnsuccessfulCompletion());
        return result;
    }

    private FakeEvent getTaskAttemptFinishedEvent() {
        FakeEvent result = new FakeEvent(EventType.SETUP_ATTEMPT_FINISHED);
        TaskAttemptFinished datum = new TaskAttemptFinished();
        datum.setAttemptId((CharSequence)"attempt_1_2_r3_4_5");
        datum.setCounters(this.getCounters());
        datum.setFinishTime(Long.valueOf(2L));
        datum.setHostname((CharSequence)"hostname");
        datum.setRackname((CharSequence)"rackname");
        datum.setState((CharSequence)"state");
        datum.setTaskid((CharSequence)taskId);
        datum.setTaskStatus((CharSequence)"taskStatus");
        datum.setTaskType((CharSequence)"REDUCE");
        result.setDatum(datum);
        return result;
    }

    private FakeEvent getSetupAttemptStartedEvent() {
        FakeEvent result = new FakeEvent(EventType.SETUP_ATTEMPT_STARTED);
        TaskAttemptStarted datum = new TaskAttemptStarted();
        datum.setAttemptId((CharSequence)"ID");
        datum.setAvataar((CharSequence)"avataar");
        datum.setContainerId((CharSequence)"containerId");
        datum.setHttpPort(Integer.valueOf(10000));
        datum.setLocality((CharSequence)"locality");
        datum.setShufflePort(Integer.valueOf(10001));
        datum.setStartTime(Long.valueOf(1L));
        datum.setTaskid((CharSequence)taskId);
        datum.setTaskType((CharSequence)"taskType");
        datum.setTrackerName((CharSequence)"trackerName");
        result.setDatum(datum);
        return result;
    }

    private FakeEvent getJobKilledEvent() {
        FakeEvent result = new FakeEvent(EventType.JOB_KILLED);
        JobUnsuccessfulCompletion datum = new JobUnsuccessfulCompletion();
        datum.setFinishedMaps(Integer.valueOf(1));
        datum.setFinishedReduces(Integer.valueOf(2));
        datum.setFinishTime(Long.valueOf(3L));
        datum.setJobid((CharSequence)"ID");
        datum.setJobStatus((CharSequence)"STATUS");
        datum.setDiagnostics((CharSequence)"Job received Kill while in RUNNING state.");
        result.setDatum(datum);
        return result;
    }

    private FakeEvent getReduceAttemptKilledEvent() {
        FakeEvent result = new FakeEvent(EventType.REDUCE_ATTEMPT_KILLED);
        result.setDatum(this.getTaskAttemptUnsuccessfulCompletion());
        return result;
    }

    private FakeEvent getJobPriorityChangedEvent() {
        FakeEvent result = new FakeEvent(EventType.JOB_PRIORITY_CHANGED);
        JobPriorityChange datum = new JobPriorityChange();
        datum.setJobid((CharSequence)"ID");
        datum.setPriority((CharSequence)"priority");
        result.setDatum(datum);
        return result;
    }

    private FakeEvent getJobStatusChangedEvent() {
        FakeEvent result = new FakeEvent(EventType.JOB_STATUS_CHANGED);
        JobStatusChanged datum = new JobStatusChanged();
        datum.setJobid((CharSequence)"ID");
        datum.setJobStatus((CharSequence)"newStatus");
        result.setDatum(datum);
        return result;
    }

    private FakeEvent getTaskUpdatedEvent() {
        FakeEvent result = new FakeEvent(EventType.TASK_UPDATED);
        TaskUpdated datum = new TaskUpdated();
        datum.setFinishTime(Long.valueOf(2L));
        datum.setTaskid((CharSequence)"ID");
        result.setDatum(datum);
        return result;
    }

    private class FakeEvent
    implements HistoryEvent {
        private EventType eventType;
        private Object datum;

        public FakeEvent(EventType eventType) {
            this.eventType = eventType;
        }

        public EventType getEventType() {
            return this.eventType;
        }

        public Object getDatum() {
            return this.datum;
        }

        public void setDatum(Object datum) {
            this.datum = datum;
        }

        public TimelineEvent toTimelineEvent() {
            return null;
        }

        public Set<TimelineMetric> getTimelineMetrics() {
            return null;
        }
    }
}

