/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import com.google.inject.Inject;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.ConfEntryInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.ConfInfo;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet2.HamletSpec;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

public class ConfBlock
extends HtmlBlock {
    final AppContext appContext;

    @Inject
    ConfBlock(AppContext appctx) {
        this.appContext = appctx;
    }

    protected void render(HtmlBlock.Block html) {
        String jid = this.$("job.id");
        if (jid.isEmpty()) {
            html.p().__(new Object[]{"Sorry, can't do anything without a JobID."}).__();
            return;
        }
        JobId jobID = MRApps.toJobID((String)jid);
        Job job = this.appContext.getJob(jobID);
        if (job == null) {
            html.p().__(new Object[]{"Sorry, ", jid, " not found."}).__();
            return;
        }
        Path confPath = job.getConfFile();
        try {
            ConfInfo info = new ConfInfo(job);
            html.div().a("/jobhistory/downloadconf/" + jid, confPath.toString()).__();
            Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.table("#conf").thead().tr().th(".ui-state-default", "key").th(".ui-state-default", "value").th(".ui-state-default", "source chain").__()).__()).tbody();
            for (ConfEntryInfo entry : info.getProperties()) {
                StringBuffer buffer = new StringBuffer();
                String[] sources = entry.getSource();
                boolean first = true;
                for (int i = sources.length - 2; i >= 0; --i) {
                    if (!first) {
                        buffer.append(" <- ");
                    }
                    first = false;
                    buffer.append(sources[i]);
                }
                tbody.tr().td(entry.getName()).td(entry.getValue()).td(buffer.toString()).__();
            }
            ((Hamlet.TABLE)((Hamlet.TFOOT)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TABLE)tbody.__()).tfoot().tr().th().input("search_init").$type(HamletSpec.InputType.text).$name("key").$value("key").__()).__()).th().input("search_init").$type(HamletSpec.InputType.text).$name("value").$value("value").__()).__()).th().input("search_init").$type(HamletSpec.InputType.text).$name("source chain").$value("source chain").__()).__()).__()).__()).__();
        }
        catch (IOException e) {
            LOG.error("Error while reading " + confPath, (Throwable)e);
            html.p().__(new Object[]{"Sorry got an error while reading conf file. ", confPath});
        }
    }
}

