/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobInfo;
import org.apache.hadoop.mapred.TIPStatus;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskType;
import org.junit.Assert;
import org.junit.Test;

public class TestJobInfo {
    @Test(timeout=5000L)
    public void testJobInfo() throws IOException {
        JobID jid = new JobID("001", 1);
        Text user = new Text("User");
        Path path = new Path("/tmp/test");
        JobInfo info = new JobInfo(jid, user, path);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        info.write((DataOutput)new DataOutputStream(out));
        JobInfo copyinfo = new JobInfo();
        copyinfo.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(out.toByteArray())));
        Assert.assertEquals((Object)info.getJobID().toString(), (Object)copyinfo.getJobID().toString());
        Assert.assertEquals((Object)info.getJobSubmitDir().getName(), (Object)copyinfo.getJobSubmitDir().getName());
        Assert.assertEquals((Object)info.getUser().toString(), (Object)copyinfo.getUser().toString());
    }

    @Test(timeout=5000L)
    public void testTaskID() throws IOException, InterruptedException {
        JobID jobid = new JobID("1014873536921", 6);
        org.apache.hadoop.mapreduce.TaskID tid = new org.apache.hadoop.mapreduce.TaskID(jobid, TaskType.MAP, 0);
        TaskID tid1 = TaskID.downgrade((org.apache.hadoop.mapreduce.TaskID)tid);
        TaskReport treport = new TaskReport(tid1, 0.0f, JobStatus.State.FAILED.toString(), null, TIPStatus.FAILED, 100L, 100L, new Counters());
        Assert.assertEquals((Object)treport.getTaskId(), (Object)"task_1014873536921_0006_m_000000");
        Assert.assertEquals((Object)treport.getTaskID().toString(), (Object)"task_1014873536921_0006_m_000000");
    }
}

