/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskLog;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestTaskLog {
    private static final String testDirName = TestTaskLog.class.getSimpleName();
    private static final String testDir = System.getProperty("test.build.data", "target" + File.separatorChar + "test-dir") + File.separatorChar + testDirName;

    @AfterClass
    public static void cleanup() {
        FileUtil.fullyDelete((File)new File(testDir));
    }

    @Test(timeout=50000L)
    public void testTaskLog() throws IOException {
        System.setProperty("yarn.app.container.log.dir", "testString");
        Assert.assertEquals((Object)TaskLog.getMRv2LogDir(), (Object)"testString");
        TaskAttemptID taid = (TaskAttemptID)Mockito.mock(TaskAttemptID.class);
        JobID jid = new JobID("job", 1);
        Mockito.when((Object)taid.getJobID()).thenReturn((Object)jid);
        Mockito.when((Object)taid.toString()).thenReturn((Object)"JobId");
        File f = TaskLog.getTaskLogFile((TaskAttemptID)taid, (boolean)true, (TaskLog.LogName)TaskLog.LogName.STDOUT);
        Assert.assertTrue((boolean)f.getAbsolutePath().endsWith("testString" + File.separatorChar + "stdout"));
        File indexFile = TaskLog.getIndexFile((TaskAttemptID)taid, (boolean)true);
        if (!indexFile.getParentFile().exists()) {
            indexFile.getParentFile().mkdirs();
        }
        indexFile.delete();
        indexFile.createNewFile();
        TaskLog.syncLogs((String)testDir, (TaskAttemptID)taid, (boolean)true);
        Assert.assertTrue((boolean)indexFile.getAbsolutePath().endsWith("userlogs" + File.separatorChar + "job_job_0001" + File.separatorChar + "JobId.cleanup" + File.separatorChar + "log.index"));
        f = TaskLog.getRealTaskLogFileLocation((TaskAttemptID)taid, (boolean)true, (TaskLog.LogName)TaskLog.LogName.DEBUGOUT);
        if (f != null) {
            Assert.assertTrue((boolean)f.getAbsolutePath().endsWith(testDirName + File.separatorChar + "debugout"));
            FileUtils.copyFile((File)indexFile, (File)f);
        }
        Assert.assertTrue((TaskLog.obtainLogDirOwner((TaskAttemptID)taid).length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.readTaskLog(TaskLog.LogName.DEBUGOUT, taid, true).length() > 0 ? 1 : 0) != 0);
    }

    private String readTaskLog(TaskLog.LogName filter, TaskAttemptID taskId, boolean isCleanup) throws IOException {
        int res;
        StringBuilder result = new StringBuilder();
        TaskLog.Reader taskLogReader = new TaskLog.Reader(taskId, filter, 0L, -1L, isCleanup);
        byte[] b = new byte[65536];
        while ((res = taskLogReader.read(b)) > 0) {
            result.append(new String(b));
        }
        taskLogReader.close();
        String str = result.toString();
        str = str.trim();
        return str;
    }

    @Test(timeout=50000L)
    public void testTaskLogWithoutTaskLogDir() throws IOException {
        System.clearProperty("yarn.app.container.log.dir");
        Assert.assertEquals((Object)TaskLog.getMRv2LogDir(), null);
        TaskAttemptID taid = (TaskAttemptID)Mockito.mock(TaskAttemptID.class);
        JobID jid = new JobID("job", 1);
        Mockito.when((Object)taid.getJobID()).thenReturn((Object)jid);
        Mockito.when((Object)taid.toString()).thenReturn((Object)"JobId");
        File f = TaskLog.getTaskLogFile((TaskAttemptID)taid, (boolean)true, (TaskLog.LogName)TaskLog.LogName.STDOUT);
        Assert.assertTrue((boolean)f.getAbsolutePath().endsWith("stdout"));
    }
}

