/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.ContextFactory;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.MapContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.map.WrappedMapper;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.task.MapContextImpl;
import org.junit.Before;
import org.junit.Test;

public class TestContextFactory {
    JobID jobId;
    Configuration conf;
    JobContext jobContext;

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.jobId = new JobID("test", 1);
        this.jobContext = new JobContextImpl(this.conf, this.jobId);
    }

    @Test
    public void testCloneContext() throws Exception {
        ContextFactory.cloneContext((JobContext)this.jobContext, (Configuration)this.conf);
    }

    @Test
    public void testCloneMapContext() throws Exception {
        TaskID taskId = new TaskID(this.jobId, TaskType.MAP, 0);
        TaskAttemptID taskAttemptid = new TaskAttemptID(taskId, 0);
        MapContextImpl mapContext = new MapContextImpl(this.conf, taskAttemptid, null, null, null, null, null);
        Mapper.Context mapperContext = new WrappedMapper().getMapContext((MapContext)mapContext);
        ContextFactory.cloneMapContext((MapContext)mapperContext, (Configuration)this.conf, null, null);
    }

    @Before
    public void tearDown() throws Exception {
    }
}

