/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.RawKeyValueIterator;
import org.apache.hadoop.mapred.ReduceTask;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.ShuffleConsumerPlugin;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.reduce.Shuffle;
import org.apache.hadoop.util.Progress;
import org.apache.hadoop.util.ReflectionUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestShufflePlugin<K, V> {
    @Test
    public void testPluginAbility() {
        try {
            JobConf jobConf = new JobConf();
            jobConf.setClass("mapreduce.job.reduce.shuffle.consumer.plugin.class", TestShuffleConsumerPlugin.class, ShuffleConsumerPlugin.class);
            ShuffleConsumerPlugin shuffleConsumerPlugin = null;
            Class clazz = jobConf.getClass("mapreduce.job.reduce.shuffle.consumer.plugin.class", Shuffle.class, ShuffleConsumerPlugin.class);
            Assert.assertNotNull((String)"Unable to get mapreduce.job.reduce.shuffle.consumer.plugin.class", (Object)clazz);
            shuffleConsumerPlugin = (ShuffleConsumerPlugin)ReflectionUtils.newInstance((Class)clazz, (Configuration)jobConf);
            Assert.assertNotNull((String)"Unable to load mapreduce.job.reduce.shuffle.consumer.plugin.class", (Object)shuffleConsumerPlugin);
        }
        catch (Exception e) {
            Assert.assertTrue((String)("Threw exception:" + e), (boolean)false);
        }
    }

    @Test
    public void testConsumerApi() {
        JobConf jobConf = new JobConf();
        TestShuffleConsumerPlugin shuffleConsumerPlugin = new TestShuffleConsumerPlugin();
        ReduceTask mockReduceTask = (ReduceTask)Mockito.mock(ReduceTask.class);
        TaskUmbilicalProtocol mockUmbilical = (TaskUmbilicalProtocol)Mockito.mock(TaskUmbilicalProtocol.class);
        Reporter mockReporter = (Reporter)Mockito.mock(Reporter.class);
        FileSystem mockFileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        Class combinerClass = jobConf.getCombinerClass();
        Task.CombineOutputCollector mockCombineOutputCollector = (Task.CombineOutputCollector)Mockito.mock(Task.CombineOutputCollector.class);
        TaskAttemptID mockTaskAttemptID = (TaskAttemptID)Mockito.mock(TaskAttemptID.class);
        LocalDirAllocator mockLocalDirAllocator = (LocalDirAllocator)Mockito.mock(LocalDirAllocator.class);
        CompressionCodec mockCompressionCodec = (CompressionCodec)Mockito.mock(CompressionCodec.class);
        Counters.Counter mockCounter = (Counters.Counter)Mockito.mock(Counters.Counter.class);
        TaskStatus mockTaskStatus = (TaskStatus)Mockito.mock(TaskStatus.class);
        Progress mockProgress = (Progress)Mockito.mock(Progress.class);
        MapOutputFile mockMapOutputFile = (MapOutputFile)Mockito.mock(MapOutputFile.class);
        Task mockTask = (Task)Mockito.mock(Task.class);
        try {
            String[] dirs = jobConf.getLocalDirs();
            ShuffleConsumerPlugin.Context context = new ShuffleConsumerPlugin.Context(mockTaskAttemptID, jobConf, mockFileSystem, mockUmbilical, mockLocalDirAllocator, mockReporter, mockCompressionCodec, combinerClass, mockCombineOutputCollector, mockCounter, mockCounter, mockCounter, mockCounter, mockCounter, mockCounter, mockTaskStatus, mockProgress, mockProgress, mockTask, mockMapOutputFile, null);
            shuffleConsumerPlugin.init(context);
            shuffleConsumerPlugin.run();
            shuffleConsumerPlugin.close();
        }
        catch (Exception e) {
            Assert.assertTrue((String)("Threw exception:" + e), (boolean)false);
        }
        mockReduceTask.getTaskID();
        mockReduceTask.getJobID();
        mockReduceTask.getNumMaps();
        mockReduceTask.getPartition();
        mockReporter.progress();
    }

    @Test
    public void testProviderApi() {
        LocalDirAllocator mockLocalDirAllocator = (LocalDirAllocator)Mockito.mock(LocalDirAllocator.class);
        JobConf mockJobConf = (JobConf)Mockito.mock(JobConf.class);
        try {
            mockLocalDirAllocator.getLocalPathToRead("", (Configuration)mockJobConf);
        }
        catch (Exception e) {
            Assert.assertTrue((String)("Threw exception:" + e), (boolean)false);
        }
    }

    static class TestShuffleConsumerPlugin<K, V>
    implements ShuffleConsumerPlugin<K, V> {
        TestShuffleConsumerPlugin() {
        }

        public void init(ShuffleConsumerPlugin.Context<K, V> context) {
            context.getReduceId();
            context.getJobConf();
            context.getLocalFS();
            context.getUmbilical();
            context.getLocalDirAllocator();
            context.getReporter();
            context.getCodec();
            context.getCombinerClass();
            context.getCombineCollector();
            context.getSpilledRecordsCounter();
            context.getReduceCombineInputCounter();
            context.getShuffledMapsCounter();
            context.getReduceShuffleBytes();
            context.getFailedShuffleCounter();
            context.getMergedMapOutputsCounter();
            context.getStatus();
            context.getCopyPhase();
            context.getMergePhase();
            context.getReduceTask();
            context.getMapOutputFile();
        }

        public void close() {
        }

        public RawKeyValueIterator run() throws IOException, InterruptedException {
            return null;
        }
    }
}

