/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.filecache;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.filecache.DistributedCache;
import org.junit.Assert;
import org.junit.Test;

public class TestDistributedCache {
    @Test
    public void testAddFileToClassPath() throws Exception {
        Configuration conf = new Configuration(false);
        try {
            DistributedCache.addFileToClassPath(null, (Configuration)conf);
            Assert.fail((String)"Accepted null archives argument");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        DistributedCache.addFileToClassPath((Path)new Path("file:///a"), (Configuration)conf);
        Assert.assertEquals((String)"The mapreduce.job.classpath.files property was not set correctly", (Object)"file:/a", (Object)conf.get("mapreduce.job.classpath.files"));
        Assert.assertEquals((String)"The mapreduce.job.cache.files property was not set correctly", (Object)"file:///a", (Object)conf.get("mapreduce.job.cache.files"));
        DistributedCache.addFileToClassPath((Path)new Path("file:///b"), (Configuration)conf);
        Assert.assertEquals((String)"The mapreduce.job.classpath.files property was not set correctly", (Object)"file:/a,file:/b", (Object)conf.get("mapreduce.job.classpath.files"));
        Assert.assertEquals((String)"The mapreduce.job.cache.files property was not set correctly", (Object)"file:///a,file:///b", (Object)conf.get("mapreduce.job.cache.files"));
        FileSystem fs = FileSystem.newInstance((Configuration)conf);
        conf.clear();
        try {
            DistributedCache.addFileToClassPath(null, (Configuration)conf, (FileSystem)fs);
            Assert.fail((String)"Accepted null archives argument");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        DistributedCache.addFileToClassPath((Path)new Path("file:///a"), (Configuration)conf, (FileSystem)fs);
        Assert.assertEquals((String)"The mapreduce.job.classpath.files property was not set correctly", (Object)"file:/a", (Object)conf.get("mapreduce.job.classpath.files"));
        Assert.assertEquals((String)"The mapreduce.job.cache.files property was not set correctly", (Object)"file:///a", (Object)conf.get("mapreduce.job.cache.files"));
        DistributedCache.addFileToClassPath((Path)new Path("file:///b"), (Configuration)conf, (FileSystem)fs);
        Assert.assertEquals((String)"The mapreduce.job.classpath.files property was not set correctly", (Object)"file:/a,file:/b", (Object)conf.get("mapreduce.job.classpath.files"));
        Assert.assertEquals((String)"The mapreduce.job.cache.files property was not set correctly", (Object)"file:///a,file:///b", (Object)conf.get("mapreduce.job.cache.files"));
        conf.clear();
        try {
            DistributedCache.addFileToClassPath(null, (Configuration)conf, (FileSystem)fs, (boolean)true);
            Assert.fail((String)"Accepted null archives argument");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        DistributedCache.addFileToClassPath((Path)new Path("file:///a"), (Configuration)conf, (FileSystem)fs, (boolean)true);
        Assert.assertEquals((String)"The mapreduce.job.classpath.files property was not set correctly", (Object)"file:/a", (Object)conf.get("mapreduce.job.classpath.files"));
        Assert.assertEquals((String)"The mapreduce.job.cache.files property was not set correctly", (Object)"file:///a", (Object)conf.get("mapreduce.job.cache.files"));
        DistributedCache.addFileToClassPath((Path)new Path("file:///b"), (Configuration)conf, (FileSystem)fs, (boolean)true);
        Assert.assertEquals((String)"The mapreduce.job.classpath.files property was not set correctly", (Object)"file:/a,file:/b", (Object)conf.get("mapreduce.job.classpath.files"));
        Assert.assertEquals((String)"The mapreduce.job.cache.files property was not set correctly", (Object)"file:///a,file:///b", (Object)conf.get("mapreduce.job.cache.files"));
        conf.clear();
        try {
            DistributedCache.addFileToClassPath(null, (Configuration)conf, (FileSystem)fs, (boolean)false);
            Assert.fail((String)"Accepted null archives argument");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        DistributedCache.addFileToClassPath((Path)new Path("file:///a"), (Configuration)conf, (FileSystem)fs, (boolean)false);
        Assert.assertEquals((String)"The mapreduce.job.classpath.files property was not set correctly", (Object)"file:/a", (Object)conf.get("mapreduce.job.classpath.files"));
        Assert.assertEquals((String)"The mapreduce.job.cache.files property was not set correctly", (Object)"", (Object)conf.get("mapreduce.job.cache.files", ""));
        DistributedCache.addFileToClassPath((Path)new Path("file:///b"), (Configuration)conf, (FileSystem)fs, (boolean)false);
        Assert.assertEquals((String)"The mapreduce.job.classpath.files property was not set correctly", (Object)"file:/a,file:/b", (Object)conf.get("mapreduce.job.classpath.files"));
        Assert.assertEquals((String)"The mapreduce.job.cache.files property was not set correctly", (Object)"", (Object)conf.get("mapreduce.job.cache.files", ""));
    }
}

