/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.MapFileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFileOutputCommitter {
    private static final Path outDir = new Path(System.getProperty("test.build.data", System.getProperty("java.io.tmpdir")), TestFileOutputCommitter.class.getName());
    private static final String SUB_DIR = "SUB_DIR";
    private static final Path OUT_SUB_DIR = new Path(outDir, "SUB_DIR");
    private static final Logger LOG = LoggerFactory.getLogger(TestFileOutputCommitter.class);
    private static final String attempt = "attempt_200707121733_0001_m_000000_0";
    private static final String partFile = "part-m-00000";
    private static final TaskAttemptID taskID = TaskAttemptID.forName((String)"attempt_200707121733_0001_m_000000_0");
    private static final String attempt1 = "attempt_200707121733_0001_m_000001_0";
    private static final TaskAttemptID taskID1 = TaskAttemptID.forName((String)"attempt_200707121733_0001_m_000001_0");
    private Text key1 = new Text("key1");
    private Text key2 = new Text("key2");
    private Text val1 = new Text("val1");
    private Text val2 = new Text("val2");

    private static void cleanup() throws IOException {
        Configuration conf = new Configuration();
        FileSystem fs = outDir.getFileSystem(conf);
        fs.delete(outDir, true);
    }

    @Before
    public void setUp() throws IOException {
        TestFileOutputCommitter.cleanup();
    }

    @After
    public void tearDown() throws IOException {
        TestFileOutputCommitter.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOutput(RecordWriter theRecordWriter, TaskAttemptContext context) throws IOException, InterruptedException {
        NullWritable nullWritable = NullWritable.get();
        try {
            theRecordWriter.write((Object)this.key1, (Object)this.val1);
            theRecordWriter.write(null, (Object)nullWritable);
            theRecordWriter.write(null, (Object)this.val1);
            theRecordWriter.write((Object)nullWritable, (Object)this.val2);
            theRecordWriter.write((Object)this.key2, (Object)nullWritable);
            theRecordWriter.write((Object)this.key1, null);
            theRecordWriter.write(null, null);
            theRecordWriter.write((Object)this.key2, (Object)this.val2);
        }
        finally {
            theRecordWriter.close(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMapFileOutput(RecordWriter theRecordWriter, TaskAttemptContext context) throws IOException, InterruptedException {
        try {
            int key = 0;
            for (int i = 0; i < 10; ++i) {
                key = i;
                Text val = i % 2 == 1 ? this.val1 : this.val2;
                theRecordWriter.write((Object)new LongWritable((long)key), (Object)val);
            }
        }
        finally {
            theRecordWriter.close(context);
        }
    }

    private void testRecoveryInternal(int commitVersion, int recoveryVersion) throws Exception {
        Job job = Job.getInstance();
        FileOutputFormat.setOutputPath((Job)job, (Path)outDir);
        Configuration conf = job.getConfiguration();
        conf.set("mapreduce.task.attempt.id", attempt);
        conf.setInt("mapreduce.job.application.attempt.id", 1);
        conf.setInt("mapreduce.fileoutputcommitter.algorithm.version", commitVersion);
        JobContextImpl jContext = new JobContextImpl(conf, taskID.getJobID());
        TaskAttemptContextImpl tContext = new TaskAttemptContextImpl(conf, taskID);
        FileOutputCommitter committer = new FileOutputCommitter(outDir, (TaskAttemptContext)tContext);
        committer.setupJob((JobContext)jContext);
        committer.setupTask((TaskAttemptContext)tContext);
        TextOutputFormat theOutputFormat = new TextOutputFormat();
        RecordWriter theRecordWriter = theOutputFormat.getRecordWriter((TaskAttemptContext)tContext);
        this.writeOutput(theRecordWriter, (TaskAttemptContext)tContext);
        committer.commitTask((TaskAttemptContext)tContext);
        Path jobTempDir1 = committer.getCommittedTaskPath((TaskAttemptContext)tContext);
        File jtd = new File(jobTempDir1.toUri().getPath());
        if (commitVersion == 1) {
            Assert.assertTrue((String)("Version 1 commits to temporary dir " + jtd), (boolean)jtd.exists());
            this.validateContent(jtd);
        } else {
            Assert.assertFalse((String)("Version 2 commits to output dir " + jtd), (boolean)jtd.exists());
        }
        Configuration conf2 = job.getConfiguration();
        conf2.set("mapreduce.task.attempt.id", attempt);
        conf2.setInt("mapreduce.job.application.attempt.id", 2);
        conf2.setInt("mapreduce.fileoutputcommitter.algorithm.version", recoveryVersion);
        JobContextImpl jContext2 = new JobContextImpl(conf2, taskID.getJobID());
        TaskAttemptContextImpl tContext2 = new TaskAttemptContextImpl(conf2, taskID);
        FileOutputCommitter committer2 = new FileOutputCommitter(outDir, (TaskAttemptContext)tContext2);
        committer2.setupJob((JobContext)tContext2);
        Path jobTempDir2 = committer2.getCommittedTaskPath((TaskAttemptContext)tContext2);
        File jtd2 = new File(jobTempDir2.toUri().getPath());
        committer2.recoverTask((TaskAttemptContext)tContext2);
        if (recoveryVersion == 1) {
            Assert.assertTrue((String)("Version 1 recovers to " + jtd2), (boolean)jtd2.exists());
            this.validateContent(jtd2);
        } else {
            Assert.assertFalse((String)("Version 2 commits to output dir " + jtd2), (boolean)jtd2.exists());
            if (commitVersion == 1) {
                Assert.assertTrue((String)("Version 2  recovery moves to output dir from " + jtd), (jtd.list().length == 0 ? 1 : 0) != 0);
            }
        }
        committer2.commitJob((JobContext)jContext2);
        this.validateContent(outDir);
        FileUtil.fullyDelete((File)new File(outDir.toString()));
    }

    @Test
    public void testRecoveryV1() throws Exception {
        this.testRecoveryInternal(1, 1);
    }

    @Test
    public void testRecoveryV2() throws Exception {
        this.testRecoveryInternal(2, 2);
    }

    @Test
    public void testRecoveryUpgradeV1V2() throws Exception {
        this.testRecoveryInternal(1, 2);
    }

    private void validateContent(Path dir) throws IOException {
        this.validateContent(new File(dir.toUri().getPath()));
    }

    private void validateContent(File dir) throws IOException {
        File expectedFile = new File(dir, partFile);
        Assert.assertTrue((String)("Could not find " + expectedFile), (boolean)expectedFile.exists());
        StringBuffer expectedOutput = new StringBuffer();
        expectedOutput.append(this.key1).append('\t').append(this.val1).append("\n");
        expectedOutput.append(this.val1).append("\n");
        expectedOutput.append(this.val2).append("\n");
        expectedOutput.append(this.key2).append("\n");
        expectedOutput.append(this.key1).append("\n");
        expectedOutput.append(this.key2).append('\t').append(this.val2).append("\n");
        String output = TestFileOutputCommitter.slurp(expectedFile);
        Assert.assertEquals((Object)output, (Object)expectedOutput.toString());
    }

    private void validateMapFileOutputContent(FileSystem fs, Path dir) throws IOException {
        Path expectedMapDir = new Path(dir, partFile);
        assert (fs.getFileStatus(expectedMapDir).isDirectory());
        FileStatus[] files = fs.listStatus(expectedMapDir);
        int fileCount = 0;
        boolean dataFileFound = false;
        boolean indexFileFound = false;
        for (FileStatus f : files) {
            if (!f.isFile()) continue;
            ++fileCount;
            if (f.getPath().getName().equals("index")) {
                indexFileFound = true;
                continue;
            }
            if (!f.getPath().getName().equals("data")) continue;
            dataFileFound = true;
        }
        assert (fileCount > 0);
        assert (dataFileFound && indexFileFound);
    }

    private void testCommitterInternal(int version, boolean taskCleanup) throws Exception {
        Job job = Job.getInstance();
        FileOutputFormat.setOutputPath((Job)job, (Path)outDir);
        Configuration conf = job.getConfiguration();
        conf.set("mapreduce.task.attempt.id", attempt);
        conf.setInt("mapreduce.fileoutputcommitter.algorithm.version", version);
        conf.setBoolean("mapreduce.fileoutputcommitter.task.cleanup.enabled", taskCleanup);
        JobContextImpl jContext = new JobContextImpl(conf, taskID.getJobID());
        TaskAttemptContextImpl tContext = new TaskAttemptContextImpl(conf, taskID);
        FileOutputCommitter committer = new FileOutputCommitter(outDir, (TaskAttemptContext)tContext);
        committer.setupJob((JobContext)jContext);
        committer.setupTask((TaskAttemptContext)tContext);
        TextOutputFormat theOutputFormat = new TextOutputFormat();
        RecordWriter theRecordWriter = theOutputFormat.getRecordWriter((TaskAttemptContext)tContext);
        this.writeOutput(theRecordWriter, (TaskAttemptContext)tContext);
        File jobOutputDir = new File(new Path(outDir, "_temporary").toString());
        File taskOutputDir = new File(Path.getPathWithoutSchemeAndAuthority((Path)committer.getWorkPath()).toString());
        Assert.assertTrue((String)"job temp dir does not exist", (boolean)jobOutputDir.exists());
        Assert.assertTrue((String)"task temp dir does not exist", (boolean)taskOutputDir.exists());
        committer.commitTask((TaskAttemptContext)tContext);
        Assert.assertTrue((String)"job temp dir does not exist", (boolean)jobOutputDir.exists());
        if (version == 1 || taskCleanup) {
            Assert.assertFalse((String)"task temp dir still exists", (boolean)taskOutputDir.exists());
        } else {
            Assert.assertTrue((String)"task temp dir does not exist", (boolean)taskOutputDir.exists());
        }
        committer.commitJob((JobContext)jContext);
        Assert.assertFalse((String)"job temp dir still exists", (boolean)jobOutputDir.exists());
        Assert.assertFalse((String)"task temp dir still exists", (boolean)taskOutputDir.exists());
        this.validateContent(outDir);
        FileUtil.fullyDelete((File)new File(outDir.toString()));
    }

    @Test
    public void testCommitterV1() throws Exception {
        this.testCommitterInternal(1, false);
    }

    @Test
    public void testCommitterV2() throws Exception {
        this.testCommitterInternal(2, false);
    }

    @Test
    public void testCommitterV2TaskCleanupEnabled() throws Exception {
        this.testCommitterInternal(2, true);
    }

    @Test
    public void testCommitterWithDuplicatedCommitV1() throws Exception {
        this.testCommitterWithDuplicatedCommitInternal(1);
    }

    @Test
    public void testCommitterWithDuplicatedCommitV2() throws Exception {
        this.testCommitterWithDuplicatedCommitInternal(2);
    }

    private void testCommitterWithDuplicatedCommitInternal(int version) throws Exception {
        block3: {
            Job job = Job.getInstance();
            FileOutputFormat.setOutputPath((Job)job, (Path)outDir);
            Configuration conf = job.getConfiguration();
            conf.set("mapreduce.task.attempt.id", attempt);
            conf.setInt("mapreduce.fileoutputcommitter.algorithm.version", version);
            JobContextImpl jContext = new JobContextImpl(conf, taskID.getJobID());
            TaskAttemptContextImpl tContext = new TaskAttemptContextImpl(conf, taskID);
            FileOutputCommitter committer = new FileOutputCommitter(outDir, (TaskAttemptContext)tContext);
            committer.setupJob((JobContext)jContext);
            committer.setupTask((TaskAttemptContext)tContext);
            TextOutputFormat theOutputFormat = new TextOutputFormat();
            RecordWriter theRecordWriter = theOutputFormat.getRecordWriter((TaskAttemptContext)tContext);
            this.writeOutput(theRecordWriter, (TaskAttemptContext)tContext);
            committer.commitTask((TaskAttemptContext)tContext);
            committer.commitJob((JobContext)jContext);
            this.validateContent(outDir);
            try {
                committer.commitJob((JobContext)jContext);
                if (version == 1) {
                    Assert.fail((String)"Duplicate commit success: wrong behavior for version 1.");
                }
            }
            catch (IOException e) {
                if (version != 2) break block3;
                Assert.fail((String)"Duplicate commit failed: wrong behavior for version 2.");
            }
        }
        FileUtil.fullyDelete((File)new File(outDir.toString()));
    }

    @Test
    public void testCommitterWithFailureV1() throws Exception {
        this.testCommitterWithFailureInternal(1, 1);
        this.testCommitterWithFailureInternal(1, 2);
    }

    @Test
    public void testCommitterWithFailureV2() throws Exception {
        this.testCommitterWithFailureInternal(2, 1);
        this.testCommitterWithFailureInternal(2, 2);
    }

    private void testCommitterWithFailureInternal(int version, int maxAttempts) throws Exception {
        block3: {
            Job job = Job.getInstance();
            FileOutputFormat.setOutputPath((Job)job, (Path)outDir);
            Configuration conf = job.getConfiguration();
            conf.set("mapreduce.task.attempt.id", attempt);
            conf.setInt("mapreduce.fileoutputcommitter.algorithm.version", version);
            conf.setInt("mapreduce.fileoutputcommitter.failures.attempts", maxAttempts);
            JobContextImpl jContext = new JobContextImpl(conf, taskID.getJobID());
            TaskAttemptContextImpl tContext = new TaskAttemptContextImpl(conf, taskID);
            CommitterWithFailedThenSucceed committer = new CommitterWithFailedThenSucceed(outDir, (JobContext)tContext);
            committer.setupJob((JobContext)jContext);
            committer.setupTask((TaskAttemptContext)tContext);
            TextOutputFormat theOutputFormat = new TextOutputFormat();
            RecordWriter theRecordWriter = theOutputFormat.getRecordWriter((TaskAttemptContext)tContext);
            this.writeOutput(theRecordWriter, (TaskAttemptContext)tContext);
            committer.commitTask((TaskAttemptContext)tContext);
            try {
                committer.commitJob((JobContext)jContext);
                if (version == 1 || maxAttempts <= 1) {
                    Assert.fail((String)"Commit successful: wrong behavior for version 1.");
                }
            }
            catch (IOException e) {
                if (version != 2 || maxAttempts <= 2) break block3;
                Assert.fail((String)"Commit failed: wrong behavior for version 2.");
            }
        }
        FileUtil.fullyDelete((File)new File(outDir.toString()));
    }

    @Test
    public void testProgressDuringMerge() throws Exception {
        Job job = Job.getInstance();
        FileOutputFormat.setOutputPath((Job)job, (Path)outDir);
        Configuration conf = job.getConfiguration();
        conf.set("mapreduce.task.attempt.id", attempt);
        conf.setInt("mapreduce.fileoutputcommitter.algorithm.version", 2);
        JobContextImpl jContext = new JobContextImpl(conf, taskID.getJobID());
        TaskAttemptContext tContext = (TaskAttemptContext)Mockito.spy((Object)new TaskAttemptContextImpl(conf, taskID));
        FileOutputCommitter committer = new FileOutputCommitter(outDir, tContext);
        committer.setupJob((JobContext)jContext);
        committer.setupTask(tContext);
        MapFileOutputFormat theOutputFormat = new MapFileOutputFormat();
        RecordWriter theRecordWriter = theOutputFormat.getRecordWriter(tContext);
        this.writeMapFileOutput(theRecordWriter, tContext);
        committer.commitTask(tContext);
        ((TaskAttemptContext)Mockito.verify((Object)tContext, (VerificationMode)Mockito.atLeast((int)2))).progress();
    }

    @Test
    public void testCommitterRepeatableV1() throws Exception {
        this.testCommitterRetryInternal(1);
    }

    @Test
    public void testCommitterRepeatableV2() throws Exception {
        this.testCommitterRetryInternal(2);
    }

    private void testCommitterRetryInternal(int version) throws Exception {
        Job job = Job.getInstance();
        FileOutputFormat.setOutputPath((Job)job, (Path)outDir);
        Configuration conf = job.getConfiguration();
        conf.set("mapreduce.task.attempt.id", attempt);
        conf.setInt("mapreduce.fileoutputcommitter.algorithm.version", version);
        conf.setInt("mapreduce.fileoutputcommitter.failures.attempts", 1);
        JobContextImpl jContext = new JobContextImpl(conf, taskID.getJobID());
        TaskAttemptContextImpl tContext = new TaskAttemptContextImpl(conf, taskID);
        CommitterWithFailedThenSucceed committer = new CommitterWithFailedThenSucceed(outDir, (JobContext)tContext);
        committer.setupJob((JobContext)jContext);
        committer.setupTask((TaskAttemptContext)tContext);
        TextOutputFormat theOutputFormat = new TextOutputFormat();
        RecordWriter theRecordWriter = theOutputFormat.getRecordWriter((TaskAttemptContext)tContext);
        this.writeOutput(theRecordWriter, (TaskAttemptContext)tContext);
        committer.commitTask((TaskAttemptContext)tContext);
        try {
            committer.commitJob((JobContext)jContext);
            Assert.fail((String)"Commit successful: wrong behavior for the first time commit.");
        }
        catch (IOException e) {
            try {
                committer.commitJob((JobContext)jContext);
                if (version == 1) {
                    Assert.fail((String)"Commit successful after retry: wrong behavior for version 1.");
                }
            }
            catch (FileNotFoundException ex) {
                if (version == 2) {
                    Assert.fail((String)"Commit failed after retry: wrong behavior for version 2.");
                }
                Assert.assertTrue((boolean)ex.getMessage().contains(committer.getJobAttemptPath((JobContext)jContext).toString() + " does not exist"));
            }
        }
        FileUtil.fullyDelete((File)new File(outDir.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMapFileOutputCommitterInternal(int version) throws Exception {
        Job job = Job.getInstance();
        FileOutputFormat.setOutputPath((Job)job, (Path)outDir);
        Configuration conf = job.getConfiguration();
        conf.set("mapreduce.task.attempt.id", attempt);
        conf.setInt("mapreduce.fileoutputcommitter.algorithm.version", version);
        JobContextImpl jContext = new JobContextImpl(conf, taskID.getJobID());
        TaskAttemptContextImpl tContext = new TaskAttemptContextImpl(conf, taskID);
        FileOutputCommitter committer = new FileOutputCommitter(outDir, (TaskAttemptContext)tContext);
        committer.setupJob((JobContext)jContext);
        committer.setupTask((TaskAttemptContext)tContext);
        MapFileOutputFormat theOutputFormat = new MapFileOutputFormat();
        RecordWriter theRecordWriter = theOutputFormat.getRecordWriter((TaskAttemptContext)tContext);
        this.writeMapFileOutput(theRecordWriter, (TaskAttemptContext)tContext);
        committer.commitTask((TaskAttemptContext)tContext);
        committer.commitJob((JobContext)jContext);
        MapFile.Reader[] readers = new MapFile.Reader[]{};
        try {
            readers = MapFileOutputFormat.getReaders((Path)outDir, (Configuration)conf);
            this.validateMapFileOutputContent(FileSystem.get((Configuration)job.getConfiguration()), outDir);
        }
        finally {
            IOUtils.cleanupWithLogger(null, (Closeable[])readers);
            FileUtil.fullyDelete((File)new File(outDir.toString()));
        }
    }

    @Test
    public void testMapFileOutputCommitterV1() throws Exception {
        this.testMapFileOutputCommitterInternal(1);
    }

    @Test
    public void testMapFileOutputCommitterV2() throws Exception {
        this.testMapFileOutputCommitterInternal(2);
    }

    @Test
    public void testInvalidVersionNumber() throws IOException {
        Job job = Job.getInstance();
        FileOutputFormat.setOutputPath((Job)job, (Path)outDir);
        Configuration conf = job.getConfiguration();
        conf.set("mapreduce.task.attempt.id", attempt);
        conf.setInt("mapreduce.fileoutputcommitter.algorithm.version", 3);
        TaskAttemptContextImpl tContext = new TaskAttemptContextImpl(conf, taskID);
        try {
            new FileOutputCommitter(outDir, (TaskAttemptContext)tContext);
            Assert.fail((String)"should've thrown an exception!");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void testAbortInternal(int version) throws IOException, InterruptedException {
        Job job = Job.getInstance();
        FileOutputFormat.setOutputPath((Job)job, (Path)outDir);
        Configuration conf = job.getConfiguration();
        conf.set("mapreduce.task.attempt.id", attempt);
        conf.setInt("mapreduce.fileoutputcommitter.algorithm.version", version);
        JobContextImpl jContext = new JobContextImpl(conf, taskID.getJobID());
        TaskAttemptContextImpl tContext = new TaskAttemptContextImpl(conf, taskID);
        FileOutputCommitter committer = new FileOutputCommitter(outDir, (TaskAttemptContext)tContext);
        committer.setupJob((JobContext)jContext);
        committer.setupTask((TaskAttemptContext)tContext);
        TextOutputFormat theOutputFormat = new TextOutputFormat();
        RecordWriter theRecordWriter = theOutputFormat.getRecordWriter((TaskAttemptContext)tContext);
        this.writeOutput(theRecordWriter, (TaskAttemptContext)tContext);
        committer.abortTask((TaskAttemptContext)tContext);
        File expectedFile = new File(new Path(committer.getWorkPath(), partFile).toString());
        Assert.assertFalse((String)"task temp dir still exists", (boolean)expectedFile.exists());
        committer.abortJob((JobContext)jContext, JobStatus.State.FAILED);
        expectedFile = new File(new Path(outDir, "_temporary").toString());
        Assert.assertFalse((String)"job temp dir still exists", (boolean)expectedFile.exists());
        Assert.assertEquals((String)"Output directory not empty", (long)0L, (long)new File(outDir.toString()).listFiles().length);
        FileUtil.fullyDelete((File)new File(outDir.toString()));
    }

    @Test
    public void testAbortV1() throws IOException, InterruptedException {
        this.testAbortInternal(1);
    }

    @Test
    public void testAbortV2() throws IOException, InterruptedException {
        this.testAbortInternal(2);
    }

    private void testFailAbortInternal(int version) throws IOException, InterruptedException {
        Job job = Job.getInstance();
        Configuration conf = job.getConfiguration();
        conf.set("fs.defaultFS", "faildel:///");
        conf.setClass("fs.faildel.impl", FakeFileSystem.class, FileSystem.class);
        conf.set("mapreduce.task.attempt.id", attempt);
        conf.setInt("mapreduce.job.application.attempt.id", 1);
        conf.setInt("mapreduce.fileoutputcommitter.algorithm.version", version);
        FileOutputFormat.setOutputPath((Job)job, (Path)outDir);
        JobContextImpl jContext = new JobContextImpl(conf, taskID.getJobID());
        TaskAttemptContextImpl tContext = new TaskAttemptContextImpl(conf, taskID);
        FileOutputCommitter committer = new FileOutputCommitter(outDir, (TaskAttemptContext)tContext);
        committer.setupJob((JobContext)jContext);
        committer.setupTask((TaskAttemptContext)tContext);
        TextOutputFormat theOutputFormat = new TextOutputFormat();
        RecordWriter theRecordWriter = theOutputFormat.getRecordWriter((TaskAttemptContext)tContext);
        this.writeOutput(theRecordWriter, (TaskAttemptContext)tContext);
        IOException th = null;
        try {
            committer.abortTask((TaskAttemptContext)tContext);
        }
        catch (IOException ie) {
            th = ie;
        }
        Assert.assertNotNull((Object)th);
        Assert.assertTrue((boolean)(th instanceof IOException));
        Assert.assertTrue((boolean)th.getMessage().contains("fake delete failed"));
        Path jtd = committer.getJobAttemptPath((JobContext)jContext);
        File jobTmpDir = new File(jtd.toUri().getPath());
        Path ttd = committer.getTaskAttemptPath((TaskAttemptContext)tContext);
        File taskTmpDir = new File(ttd.toUri().getPath());
        File expectedFile = new File(taskTmpDir, partFile);
        Assert.assertTrue((String)(expectedFile + " does not exists"), (boolean)expectedFile.exists());
        th = null;
        try {
            committer.abortJob((JobContext)jContext, JobStatus.State.FAILED);
        }
        catch (IOException ie) {
            th = ie;
        }
        Assert.assertNotNull((Object)th);
        Assert.assertTrue((boolean)(th instanceof IOException));
        Assert.assertTrue((boolean)th.getMessage().contains("fake delete failed"));
        Assert.assertTrue((String)"job temp dir does not exists", (boolean)jobTmpDir.exists());
        FileUtil.fullyDelete((File)new File(outDir.toString()));
    }

    @Test
    public void testFailAbortV1() throws Exception {
        this.testFailAbortInternal(1);
    }

    @Test
    public void testFailAbortV2() throws Exception {
        this.testFailAbortInternal(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConcurrentCommitTaskWithSubDir(int version) throws Exception {
        Job job = Job.getInstance();
        FileOutputFormat.setOutputPath((Job)job, (Path)outDir);
        Configuration conf = job.getConfiguration();
        conf.set("mapreduce.task.attempt.id", attempt);
        conf.setInt("mapreduce.fileoutputcommitter.algorithm.version", version);
        conf.setClass("fs.file.impl", RLFS.class, FileSystem.class);
        FileSystem.closeAll();
        JobContextImpl jContext = new JobContextImpl(conf, taskID.getJobID());
        FileOutputCommitter amCommitter = new FileOutputCommitter(outDir, (JobContext)jContext);
        amCommitter.setupJob((JobContext)jContext);
        TaskAttemptContextImpl[] taCtx = new TaskAttemptContextImpl[]{new TaskAttemptContextImpl(conf, taskID), new TaskAttemptContextImpl(conf, taskID1)};
        final TextOutputFormat[] tof = new TextOutputFormat[2];
        for (int i = 0; i < tof.length; ++i) {
            tof[i] = new TextOutputFormat(){

                public Path getDefaultWorkFile(TaskAttemptContext context, String extension) throws IOException {
                    FileOutputCommitter foc = (FileOutputCommitter)this.getOutputCommitter(context);
                    return new Path(new Path(foc.getWorkPath(), TestFileOutputCommitter.SUB_DIR), 1.getUniqueFile((TaskAttemptContext)context, (String)1.getOutputName((JobContext)context), (String)extension));
                }
            };
        }
        ExecutorService executor = HadoopExecutors.newFixedThreadPool((int)2);
        try {
            int i = 0;
            while (i < taCtx.length) {
                final int taskIdx = i++;
                executor.submit(new Callable<Void>((TaskAttemptContext[])taCtx){
                    final /* synthetic */ TaskAttemptContext[] val$taCtx;
                    {
                        this.val$taCtx = taskAttemptContextArray;
                    }

                    @Override
                    public Void call() throws IOException, InterruptedException {
                        OutputCommitter outputCommitter = tof[taskIdx].getOutputCommitter(this.val$taCtx[taskIdx]);
                        outputCommitter.setupTask(this.val$taCtx[taskIdx]);
                        RecordWriter rw = tof[taskIdx].getRecordWriter(this.val$taCtx[taskIdx]);
                        TestFileOutputCommitter.this.writeOutput(rw, this.val$taCtx[taskIdx]);
                        outputCommitter.commitTask(this.val$taCtx[taskIdx]);
                        return null;
                    }
                });
            }
        }
        finally {
            executor.shutdown();
            while (!executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                LOG.info("Awaiting thread termination!");
            }
        }
        amCommitter.commitJob((JobContext)jContext);
        RawLocalFileSystem lfs = new RawLocalFileSystem();
        lfs.setConf(conf);
        Assert.assertFalse((String)"Must not end up with sub_dir/sub_dir", (boolean)lfs.exists(new Path(OUT_SUB_DIR, SUB_DIR)));
        this.validateContent(OUT_SUB_DIR);
        FileUtil.fullyDelete((File)new File(outDir.toString()));
    }

    @Test
    public void testConcurrentCommitTaskWithSubDirV1() throws Exception {
        this.testConcurrentCommitTaskWithSubDir(1);
    }

    @Test
    public void testConcurrentCommitTaskWithSubDirV2() throws Exception {
        this.testConcurrentCommitTaskWithSubDir(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String slurp(File f) throws IOException {
        int len = (int)f.length();
        byte[] buf = new byte[len];
        String contents = null;
        try (FileInputStream in = new FileInputStream(f);){
            in.read(buf, 0, len);
            contents = new String(buf, "UTF-8");
        }
        return contents;
    }

    public static class CommitterWithFailedThenSucceed
    extends FileOutputCommitter {
        boolean firstTimeFail = true;

        public CommitterWithFailedThenSucceed(Path outputPath, JobContext context) throws IOException {
            super(outputPath, context);
        }

        protected void commitJobInternal(JobContext context) throws IOException {
            super.commitJobInternal(context);
            if (this.firstTimeFail) {
                this.firstTimeFail = false;
                throw new IOException();
            }
        }
    }

    static class RLFS
    extends RawLocalFileSystem {
        private final ThreadLocal<Boolean> needNull = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return true;
            }
        };

        public FileStatus getFileStatus(Path f) throws IOException {
            if (this.needNull.get().booleanValue() && OUT_SUB_DIR.toUri().getPath().equals(f.toUri().getPath())) {
                this.needNull.set(false);
                return null;
            }
            return super.getFileStatus(f);
        }
    }

    public static class FakeFileSystem
    extends RawLocalFileSystem {
        public URI getUri() {
            return URI.create("faildel:///");
        }

        public boolean delete(Path p, boolean recursive) throws IOException {
            throw new IOException("fake delete failed");
        }
    }
}

