/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileAlreadyExistsException;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.junit.Assert;
import org.junit.Test;

public class TestFileOutputFormat {
    @Test
    public void testSetOutputPathException() throws Exception {
        Job job = Job.getInstance();
        try {
            FileOutputFormat.setOutputPath((Job)job, (Path)new Path("foo:///bar"));
            Assert.fail((String)"Should have thrown a RuntimeException with an IOException inside");
        }
        catch (RuntimeException re) {
            Assert.assertTrue((boolean)(re.getCause() instanceof IOException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckOutputSpecsException() throws Exception {
        Job job = Job.getInstance();
        Path outDir = new Path(System.getProperty("test.build.data", "/tmp"), "output");
        FileSystem fs = outDir.getFileSystem(new Configuration());
        fs.mkdirs(outDir);
        FileOutputFormat.setOutputPath((Job)job, (Path)outDir);
        FileOutputFormat fof = new FileOutputFormat(){

            public RecordWriter getRecordWriter(TaskAttemptContext job) throws IOException, InterruptedException {
                return null;
            }
        };
        try {
            try {
                fof.checkOutputSpecs((JobContext)job);
                Assert.fail((String)"Should have thrown a FileAlreadyExistsException");
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
        }
        finally {
            if (fs.exists(outDir)) {
                fs.delete(outDir, true);
            }
        }
    }
}

