/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.Master;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestTokenCache {
    private static Configuration conf;
    private static String renewer;

    @BeforeClass
    public static void setup() throws Exception {
        conf = new Configuration();
        conf.set("yarn.resourcemanager.principal", "mapred/host@REALM");
        renewer = Master.getMasterPrincipal((Configuration)conf);
    }

    @Test
    public void testObtainTokens() throws Exception {
        Credentials credentials = new Credentials();
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        TokenCache.obtainTokensForNamenodesInternal((FileSystem)fs, (Credentials)credentials, (Configuration)conf, (String)renewer);
        ((FileSystem)Mockito.verify((Object)fs)).addDelegationTokens((String)Matchers.eq((Object)renewer), (Credentials)Matchers.eq((Object)credentials));
    }

    @Test
    public void testBinaryCredentialsWithoutScheme() throws Exception {
        this.testBinaryCredentials(false);
    }

    @Test
    public void testBinaryCredentialsWithScheme() throws Exception {
        this.testBinaryCredentials(true);
    }

    private void testBinaryCredentials(boolean hasScheme) throws Exception {
        Path TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "test/build/data"));
        String binaryTokenFile = hasScheme ? FileSystem.getLocal((Configuration)conf).makeQualified(new Path(TEST_ROOT_DIR, "tokenFile")).toString() : FileSystem.getLocal((Configuration)conf).makeQualified(new Path(TEST_ROOT_DIR, "tokenFile")).toUri().getPath();
        FileSystemTestHelper.MockFileSystem fs1 = this.createFileSystemForServiceName("service1");
        FileSystemTestHelper.MockFileSystem fs2 = this.createFileSystemForServiceName("service2");
        FileSystemTestHelper.MockFileSystem fs3 = this.createFileSystemForServiceName("service3");
        Credentials creds = new Credentials();
        Token token1 = fs1.getDelegationToken(renewer);
        Token token2 = fs2.getDelegationToken(renewer);
        creds.addToken(token1.getService(), token1);
        creds.addToken(token2.getService(), token2);
        conf.set("mapreduce.job.credentials.binary", binaryTokenFile);
        creds.writeTokenStorageFile(new Path(binaryTokenFile), conf);
        creds = new Credentials();
        Token newerToken1 = fs1.getDelegationToken(renewer);
        Assert.assertNotSame((Object)newerToken1, (Object)token1);
        creds.addToken(newerToken1.getService(), newerToken1);
        this.checkToken(creds, newerToken1);
        TokenCache.obtainTokensForNamenodesInternal((FileSystem)fs1, (Credentials)creds, (Configuration)conf, (String)renewer);
        this.checkToken(creds, newerToken1, token2);
        TokenCache.obtainTokensForNamenodesInternal((FileSystem)fs2, (Credentials)creds, (Configuration)conf, (String)renewer);
        this.checkToken(creds, newerToken1, token2);
        TokenCache.obtainTokensForNamenodesInternal((FileSystem)fs3, (Credentials)creds, (Configuration)conf, (String)renewer);
        Token token3 = creds.getToken(new Text(fs3.getCanonicalServiceName()));
        Assert.assertTrue((token3 != null ? 1 : 0) != 0);
        this.checkToken(creds, newerToken1, token2, token3);
        TokenCache.obtainTokensForNamenodesInternal((FileSystem)fs1, (Credentials)creds, (Configuration)conf, (String)renewer);
        TokenCache.obtainTokensForNamenodesInternal((FileSystem)fs2, (Credentials)creds, (Configuration)conf, (String)renewer);
        TokenCache.obtainTokensForNamenodesInternal((FileSystem)fs3, (Credentials)creds, (Configuration)conf, (String)renewer);
        this.checkToken(creds, newerToken1, token2, token3);
    }

    private void checkToken(Credentials creds, Token<?> ... tokens) {
        Assert.assertEquals((long)tokens.length, (long)creds.getAllTokens().size());
        for (Token<?> token : tokens) {
            Token credsToken = creds.getToken(token.getService());
            Assert.assertTrue((credsToken != null ? 1 : 0) != 0);
            Assert.assertEquals(token, (Object)credsToken);
        }
    }

    private FileSystemTestHelper.MockFileSystem createFileSystemForServiceName(final String service) throws IOException {
        FileSystemTestHelper.MockFileSystem mockFs = new FileSystemTestHelper.MockFileSystem();
        Mockito.when((Object)mockFs.getCanonicalServiceName()).thenReturn((Object)service);
        Mockito.when((Object)mockFs.getDelegationToken((String)Mockito.any(String.class))).thenAnswer(new Answer<Token<?>>(){
            int unique = 0;

            public Token<?> answer(InvocationOnMock invocation) throws Throwable {
                Token token = new Token();
                token.setService(new Text(service));
                token.setKind(new Text("token" + this.unique++));
                return token;
            }
        });
        return mockFs;
    }

    @Test
    public void testSingleTokenFetch() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.principal", "mapred/host@REALM");
        String renewer = Master.getMasterPrincipal((Configuration)conf);
        Credentials credentials = new Credentials();
        FileSystemTestHelper.MockFileSystem fs = new FileSystemTestHelper.MockFileSystem();
        FileSystemTestHelper.MockFileSystem mockFs = fs.getRawFileSystem();
        Mockito.when((Object)mockFs.getCanonicalServiceName()).thenReturn((Object)"host:0");
        Mockito.when((Object)mockFs.getUri()).thenReturn((Object)new URI("mockfs://host:0"));
        Path mockPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)mockPath.getFileSystem(conf)).thenReturn((Object)mockFs);
        Path[] paths = new Path[]{mockPath, mockPath};
        Mockito.when((Object)mockFs.addDelegationTokens("me", credentials)).thenReturn(null);
        TokenCache.obtainTokensForNamenodesInternal((Credentials)credentials, (Path[])paths, (Configuration)conf);
        ((FileSystemTestHelper.MockFileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.times((int)1))).addDelegationTokens(renewer, credentials);
    }

    @Test
    public void testCleanUpTokenReferral() throws Exception {
        Configuration conf = new Configuration();
        conf.set("mapreduce.job.credentials.binary", "foo");
        TokenCache.cleanUpTokenReferral((Configuration)conf);
        Assert.assertNull((Object)conf.get("mapreduce.job.credentials.binary"));
    }

    @Test
    public void testGetTokensForNamenodes() throws IOException, URISyntaxException {
        Path TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "test/build/data"));
        String binaryTokenFile = FileSystem.getLocal((Configuration)conf).makeQualified(new Path(TEST_ROOT_DIR, "tokenFile")).toUri().getPath();
        FileSystemTestHelper.MockFileSystem fs1 = this.createFileSystemForServiceName("service1");
        Credentials creds = new Credentials();
        Token token1 = fs1.getDelegationToken(renewer);
        creds.addToken(token1.getService(), token1);
        conf.set("mapreduce.job.credentials.binary", binaryTokenFile);
        creds.writeTokenStorageFile(new Path(binaryTokenFile), conf);
        TokenCache.obtainTokensForNamenodesInternal((FileSystem)fs1, (Credentials)creds, (Configuration)conf, (String)renewer);
        String fs_addr = fs1.getCanonicalServiceName();
        Token nnt = TokenCache.getDelegationToken((Credentials)creds, (String)fs_addr);
        Assert.assertNotNull((String)"Token for nn is null", (Object)nnt);
    }
}

