/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.nativetask.buffer;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.mapred.nativetask.NativeDataTarget;
import org.apache.hadoop.mapred.nativetask.buffer.DataOutputStream;

@InterfaceAudience.Private
public class ByteBufferDataWriter
extends DataOutputStream {
    private final ByteBuffer buffer;
    private final NativeDataTarget target;
    private static final byte TRUE = 1;
    private static final byte FALSE = 0;
    private final java.io.DataOutputStream javaWriter;

    private void checkSizeAndFlushIfNecessary(int length) throws IOException {
        if (this.buffer.position() > 0 && this.buffer.remaining() < length) {
            this.flush();
        }
    }

    public ByteBufferDataWriter(NativeDataTarget handler) {
        Preconditions.checkNotNull((Object)handler);
        this.buffer = handler.getOutputBuffer().getByteBuffer();
        this.target = handler;
        this.javaWriter = new java.io.DataOutputStream(this);
    }

    @Override
    public synchronized void write(int v) throws IOException {
        this.checkSizeAndFlushIfNecessary(1);
        this.buffer.put((byte)v);
    }

    @Override
    public boolean shortOfSpace(int dataLength) throws IOException {
        return this.buffer.remaining() < dataLength;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        int remain = len;
        int offset = off;
        while (remain > 0) {
            int currentFlush = 0;
            if (this.buffer.remaining() > 0) {
                currentFlush = Math.min(this.buffer.remaining(), remain);
                this.buffer.put(b, offset, currentFlush);
                remain -= currentFlush;
                offset += currentFlush;
                continue;
            }
            this.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        this.target.sendData();
        this.buffer.position(0);
    }

    @Override
    public void close() throws IOException {
        if (this.hasUnFlushedData()) {
            this.flush();
        }
        this.target.finishSendData();
    }

    @Override
    public final void writeBoolean(boolean v) throws IOException {
        this.checkSizeAndFlushIfNecessary(1);
        this.buffer.put(v ? (byte)1 : 0);
    }

    @Override
    public final void writeByte(int v) throws IOException {
        this.checkSizeAndFlushIfNecessary(1);
        this.buffer.put((byte)v);
    }

    @Override
    public final void writeShort(int v) throws IOException {
        this.checkSizeAndFlushIfNecessary(2);
        this.buffer.putShort((short)v);
    }

    @Override
    public final void writeChar(int v) throws IOException {
        this.checkSizeAndFlushIfNecessary(2);
        this.buffer.put((byte)(v >>> 8 & 0xFF));
        this.buffer.put((byte)(v >>> 0 & 0xFF));
    }

    @Override
    public final void writeInt(int v) throws IOException {
        this.checkSizeAndFlushIfNecessary(4);
        this.buffer.putInt(v);
    }

    @Override
    public final void writeLong(long v) throws IOException {
        this.checkSizeAndFlushIfNecessary(8);
        this.buffer.putLong(v);
    }

    @Override
    public final void writeFloat(float v) throws IOException {
        this.checkSizeAndFlushIfNecessary(4);
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public final void writeDouble(double v) throws IOException {
        this.checkSizeAndFlushIfNecessary(8);
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public final void writeBytes(String s) throws IOException {
        this.javaWriter.writeBytes(s);
    }

    @Override
    public final void writeChars(String s) throws IOException {
        this.javaWriter.writeChars(s);
    }

    @Override
    public final void writeUTF(String str) throws IOException {
        this.javaWriter.writeUTF(str);
    }

    @Override
    public boolean hasUnFlushedData() {
        return this.buffer.position() > 0;
    }
}

