/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples;

import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.filecache.DistributedCache;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.mapreduce.lib.partition.InputSampler;
import org.apache.hadoop.mapreduce.lib.partition.TotalOrderPartitioner;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

/*
 * Exception performing whole class analysis ignored.
 */
public class Sort<K, V>
extends Configured
implements Tool {
    public static final String REDUCES_PER_HOST = "mapreduce.sort.reducesperhost";
    private Job job = null;

    static int printUsage() {
        System.out.println("sort [-r <reduces>] [-inFormat <input format class>] [-outFormat <output format class>] [-outKey <output key class>] [-outValue <output value class>] [-totalOrder <pcnt> <num samples> <max splits>] <input> <output>");
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
        return 2;
    }

    public int run(String[] args) throws Exception {
        Configuration conf = this.getConf();
        JobClient client = new JobClient(conf);
        ClusterStatus cluster = client.getClusterStatus();
        int num_reduces = (int)((double)cluster.getMaxReduceTasks() * 0.9);
        String sort_reduces = conf.get("mapreduce.sort.reducesperhost");
        if (sort_reduces != null) {
            num_reduces = cluster.getTaskTrackers() * Integer.parseInt(sort_reduces);
        }
        Class<SequenceFileInputFormat> inputFormatClass = SequenceFileInputFormat.class;
        Class<SequenceFileOutputFormat> outputFormatClass = SequenceFileOutputFormat.class;
        Class<BytesWritable> outputKeyClass = BytesWritable.class;
        Class<BytesWritable> outputValueClass = BytesWritable.class;
        ArrayList<String> otherArgs = new ArrayList<String>();
        InputSampler.RandomSampler sampler = null;
        for (int i = 0; i < args.length; ++i) {
            try {
                if ("-r".equals(args[i])) {
                    num_reduces = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-inFormat".equals(args[i])) {
                    inputFormatClass = Class.forName(args[++i]).asSubclass(InputFormat.class);
                    continue;
                }
                if ("-outFormat".equals(args[i])) {
                    outputFormatClass = Class.forName(args[++i]).asSubclass(OutputFormat.class);
                    continue;
                }
                if ("-outKey".equals(args[i])) {
                    outputKeyClass = Class.forName(args[++i]).asSubclass(WritableComparable.class);
                    continue;
                }
                if ("-outValue".equals(args[i])) {
                    outputValueClass = Class.forName(args[++i]).asSubclass(Writable.class);
                    continue;
                }
                if ("-totalOrder".equals(args[i])) {
                    int maxSplits;
                    double pcnt = Double.parseDouble(args[++i]);
                    int numSamples = Integer.parseInt(args[++i]);
                    if (0 >= (maxSplits = Integer.parseInt(args[++i]))) {
                        maxSplits = Integer.MAX_VALUE;
                    }
                    sampler = new InputSampler.RandomSampler(pcnt, numSamples, maxSplits);
                    continue;
                }
                otherArgs.add(args[i]);
                continue;
            }
            catch (NumberFormatException except) {
                System.out.println("ERROR: Integer expected instead of " + args[i]);
                return Sort.printUsage();
            }
            catch (ArrayIndexOutOfBoundsException except) {
                System.out.println("ERROR: Required parameter missing from " + args[i - 1]);
                return Sort.printUsage();
            }
        }
        this.job = Job.getInstance((Configuration)conf);
        this.job.setJobName("sorter");
        this.job.setJarByClass(Sort.class);
        this.job.setMapperClass(Mapper.class);
        this.job.setReducerClass(Reducer.class);
        this.job.setNumReduceTasks(num_reduces);
        this.job.setInputFormatClass(inputFormatClass);
        this.job.setOutputFormatClass(outputFormatClass);
        this.job.setOutputKeyClass(outputKeyClass);
        this.job.setOutputValueClass(outputValueClass);
        if (otherArgs.size() != 2) {
            System.out.println("ERROR: Wrong number of parameters: " + otherArgs.size() + " instead of 2.");
            return Sort.printUsage();
        }
        FileInputFormat.setInputPaths((Job)this.job, (String)((String)otherArgs.get(0)));
        FileOutputFormat.setOutputPath((Job)this.job, (Path)new Path((String)otherArgs.get(1)));
        if (sampler != null) {
            System.out.println("Sampling input to effect total-order sort...");
            this.job.setPartitionerClass(TotalOrderPartitioner.class);
            Path inputDir = FileInputFormat.getInputPaths((JobContext)this.job)[0];
            inputDir = inputDir.makeQualified(inputDir.getFileSystem(conf));
            Path partitionFile = new Path(inputDir, "_sortPartitioning");
            TotalOrderPartitioner.setPartitionFile((Configuration)conf, (Path)partitionFile);
            InputSampler.writePartitionFile((Job)this.job, (InputSampler.Sampler)sampler);
            URI partitionUri = new URI(partitionFile.toString() + "#_sortPartitioning");
            DistributedCache.addCacheFile((URI)partitionUri, (Configuration)conf);
        }
        System.out.println("Running on " + cluster.getTaskTrackers() + " nodes to sort from " + FileInputFormat.getInputPaths((JobContext)this.job)[0] + " into " + FileOutputFormat.getOutputPath((JobContext)this.job) + " with " + num_reduces + " reduces.");
        Date startTime = new Date();
        System.out.println("Job started: " + startTime);
        int ret = this.job.waitForCompletion(true) ? 0 : 1;
        Date end_time = new Date();
        System.out.println("Job ended: " + end_time);
        System.out.println("The job took " + (end_time.getTime() - startTime.getTime()) / 1000L + " seconds.");
        return ret;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new Sort(), (String[])args);
        System.exit(res);
    }

    public Job getResult() {
        return this.job;
    }
}

