/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.examples.TestWordStats;
import org.apache.hadoop.examples.WordMean;
import org.apache.hadoop.examples.WordMedian;
import org.apache.hadoop.examples.WordStandardDeviation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestWordStats {
    private static final String INPUT = "src/test/java/org/apache/hadoop/examples/pi/math";
    private static final String BASEDIR = System.getProperty("test.build.data", "target/test-dir");
    private static final String MEAN_OUTPUT = BASEDIR + "/mean_output";
    private static final String MEDIAN_OUTPUT = BASEDIR + "/median_output";
    private static final String STDDEV_OUTPUT = BASEDIR + "/stddev_output";

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = TestWordStats.deleteDir((File)new File(dir, children[i]));
                if (success) continue;
                System.out.println("Could not delete directory after test!");
                return false;
            }
        }
        return dir.delete();
    }

    @Before
    public void setup() throws Exception {
        TestWordStats.deleteDir((File)new File(MEAN_OUTPUT));
        TestWordStats.deleteDir((File)new File(MEDIAN_OUTPUT));
        TestWordStats.deleteDir((File)new File(STDDEV_OUTPUT));
    }

    @Test
    public void testGetTheMean() throws Exception {
        String[] args = new String[]{"src/test/java/org/apache/hadoop/examples/pi/math", MEAN_OUTPUT};
        WordMean wm = new WordMean();
        ToolRunner.run((Configuration)new Configuration(), (Tool)wm, (String[])args);
        double mean = wm.getMean();
        WordMeanReader wr = new WordMeanReader();
        Assert.assertEquals((double)mean, (double)wr.read("src/test/java/org/apache/hadoop/examples/pi/math"), (double)0.0);
    }

    @Test
    public void testGetTheMedian() throws Exception {
        String[] args = new String[]{"src/test/java/org/apache/hadoop/examples/pi/math", MEDIAN_OUTPUT};
        WordMedian wm = new WordMedian();
        ToolRunner.run((Configuration)new Configuration(), (Tool)wm, (String[])args);
        double median = wm.getMedian();
        WordMedianReader wr = new WordMedianReader();
        Assert.assertEquals((double)median, (double)wr.read("src/test/java/org/apache/hadoop/examples/pi/math"), (double)0.0);
    }

    @Test
    public void testGetTheStandardDeviation() throws Exception {
        String[] args = new String[]{"src/test/java/org/apache/hadoop/examples/pi/math", STDDEV_OUTPUT};
        WordStandardDeviation wsd = new WordStandardDeviation();
        ToolRunner.run((Configuration)new Configuration(), (Tool)wsd, (String[])args);
        double stddev = wsd.getStandardDeviation();
        WordStdDevReader wr = new WordStdDevReader();
        Assert.assertEquals((double)stddev, (double)wr.read("src/test/java/org/apache/hadoop/examples/pi/math"), (double)0.0);
    }

    @AfterClass
    public static void cleanup() throws Exception {
        TestWordStats.deleteDir((File)new File(MEAN_OUTPUT));
        TestWordStats.deleteDir((File)new File(MEDIAN_OUTPUT));
        TestWordStats.deleteDir((File)new File(STDDEV_OUTPUT));
    }
}

