/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.terasort;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.examples.terasort.TeraGen;
import org.apache.hadoop.examples.terasort.TeraSort;
import org.apache.hadoop.examples.terasort.TeraValidate;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileAlreadyExistsException;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestTeraSort
extends HadoopTestCase {
    private static Log LOG = LogFactory.getLog(TestTeraSort.class);
    private static final String TEST_DIR = new File(System.getProperty("test.build.data", "/tmp"), "terasort").getAbsolutePath();
    private static final Path SORT_INPUT_PATH = new Path(TEST_DIR, "sortin");
    private static final Path SORT_OUTPUT_PATH = new Path(TEST_DIR, "sortout");
    private static final Path TERA_OUTPUT_PATH = new Path(TEST_DIR, "validate");
    private static final String NUM_ROWS = "100";

    public TestTeraSort() throws IOException {
        super(1, 4, 1, 1);
    }

    protected void tearDown() throws Exception {
        this.getFileSystem().delete(new Path(TEST_DIR), true);
        super.tearDown();
    }

    private void runTeraGen(Configuration conf, Path sortInput) throws Exception {
        String[] genArgs = new String[]{"100", sortInput.toString()};
        TestTeraSort.assertEquals((int)ToolRunner.run((Configuration)conf, (Tool)new TeraGen(), (String[])genArgs), (int)0);
    }

    private void runTeraSort(Configuration conf, Path sortInput, Path sortOutput) throws Exception {
        String[] sortArgs = new String[]{sortInput.toString(), sortOutput.toString()};
        TestTeraSort.assertEquals((int)ToolRunner.run((Configuration)conf, (Tool)new TeraSort(), (String[])sortArgs), (int)0);
    }

    private void runTeraValidator(Configuration job, Path sortOutput, Path valOutput) throws Exception {
        String[] svArgs = new String[]{sortOutput.toString(), valOutput.toString()};
        TestTeraSort.assertEquals((int)ToolRunner.run((Configuration)job, (Tool)new TeraValidate(), (String[])svArgs), (int)0);
    }

    public void testTeraSort() throws Exception {
        this.runTeraGen((Configuration)this.createJobConf(), SORT_INPUT_PATH);
        try {
            this.runTeraGen((Configuration)this.createJobConf(), SORT_INPUT_PATH);
            TestTeraSort.fail((String)"Teragen output overwritten!");
        }
        catch (FileAlreadyExistsException fae) {
            LOG.info((Object)"Expected exception: ", (Throwable)fae);
        }
        this.runTeraSort((Configuration)this.createJobConf(), SORT_INPUT_PATH, SORT_OUTPUT_PATH);
        try {
            this.runTeraSort((Configuration)this.createJobConf(), SORT_INPUT_PATH, SORT_OUTPUT_PATH);
            TestTeraSort.fail((String)"Terasort output overwritten!");
        }
        catch (FileAlreadyExistsException fae) {
            LOG.info((Object)"Expected exception: ", (Throwable)fae);
        }
        this.runTeraValidator((Configuration)this.createJobConf(), SORT_OUTPUT_PATH, TERA_OUTPUT_PATH);
    }
}

