/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.terasort;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import org.apache.hadoop.examples.terasort.Random16;
import org.apache.hadoop.examples.terasort.Unsigned16;
import org.apache.hadoop.util.PureJavaCrc32;

/*
 * Exception performing whole class analysis ignored.
 */
public class GenSort {
    private static final BigInteger NINETY_FIVE = new BigInteger("95");

    static void generateRecord(byte[] recBuf, Unsigned16 rand, Unsigned16 recordNumber) {
        int i;
        for (i = 0; i < 10; ++i) {
            recBuf[i] = rand.getByte(i);
        }
        recBuf[10] = 0;
        recBuf[11] = 17;
        for (i = 0; i < 32; ++i) {
            recBuf[12 + i] = (byte)recordNumber.getHexDigit(i);
        }
        recBuf[44] = -120;
        recBuf[45] = -103;
        recBuf[46] = -86;
        recBuf[47] = -69;
        for (i = 0; i < 12; ++i) {
            byte by = (byte)rand.getHexDigit(20 + i);
            recBuf[51 + i * 4] = by;
            recBuf[50 + i * 4] = by;
            recBuf[49 + i * 4] = by;
            recBuf[48 + i * 4] = by;
        }
        recBuf[96] = -52;
        recBuf[97] = -35;
        recBuf[98] = -18;
        recBuf[99] = -1;
    }

    private static BigInteger makeBigInteger(long x) {
        byte[] data = new byte[8];
        for (int i = 0; i < 8; ++i) {
            data[i] = (byte)(x >>> 56 - 8 * i);
        }
        return new BigInteger(1, data);
    }

    static void generateAsciiRecord(byte[] recBuf, Unsigned16 rand, Unsigned16 recordNumber) {
        int i;
        long temp = rand.getHigh8();
        if (temp < 0L) {
            BigInteger bigTemp = GenSort.makeBigInteger((long)temp);
            recBuf[0] = (byte)(32L + bigTemp.mod(NINETY_FIVE).longValue());
            temp = bigTemp.divide(NINETY_FIVE).longValue();
        } else {
            recBuf[0] = (byte)(32L + temp % 95L);
            temp /= 95L;
        }
        for (int i2 = 1; i2 < 8; ++i2) {
            recBuf[i2] = (byte)(32L + temp % 95L);
            temp /= 95L;
        }
        temp = rand.getLow8();
        if (temp < 0L) {
            BigInteger bigTemp = GenSort.makeBigInteger((long)temp);
            recBuf[8] = (byte)(32L + bigTemp.mod(NINETY_FIVE).longValue());
            temp = bigTemp.divide(NINETY_FIVE).longValue();
        } else {
            recBuf[8] = (byte)(32L + temp % 95L);
            temp /= 95L;
        }
        recBuf[9] = (byte)(32L + temp % 95L);
        recBuf[10] = 32;
        recBuf[11] = 32;
        for (i = 0; i < 32; ++i) {
            recBuf[12 + i] = (byte)recordNumber.getHexDigit(i);
        }
        recBuf[44] = 32;
        recBuf[45] = 32;
        for (i = 0; i < 13; ++i) {
            byte by = (byte)rand.getHexDigit(19 + i);
            recBuf[49 + i * 4] = by;
            recBuf[48 + i * 4] = by;
            recBuf[47 + i * 4] = by;
            recBuf[46 + i * 4] = by;
        }
        recBuf[98] = 13;
        recBuf[99] = 10;
    }

    private static void usage() {
        PrintStream out = System.out;
        out.println("usage: gensort [-a] [-c] [-bSTARTING_REC_NUM] NUM_RECS FILE_NAME");
        out.println("-a        Generate ascii records required for PennySort or JouleSort.");
        out.println("          These records are also an alternative input for the other");
        out.println("          sort benchmarks.  Without this flag, binary records will be");
        out.println("          generated that contain the highest density of randomness in");
        out.println("          the 10-byte key.");
        out.println("-c        Calculate the sum of the crc32 checksums of each of the");
        out.println("          generated records and send it to standard error.");
        out.println("-bN       Set the beginning record generated to N. By default the");
        out.println("          first record generated is record 0.");
        out.println("NUM_RECS  The number of sequential records to generate.");
        out.println("FILE_NAME The name of the file to write the records to.\n");
        out.println("Example 1 - to generate 1000000 ascii records starting at record 0 to");
        out.println("the file named \"pennyinput\":");
        out.println("    gensort -a 1000000 pennyinput\n");
        out.println("Example 2 - to generate 1000 binary records beginning with record 2000");
        out.println("to the file named \"partition2\":");
        out.println("    gensort -b2000 1000 partition2");
        System.exit(1);
    }

    public static void outputRecords(OutputStream out, boolean useAscii, Unsigned16 firstRecordNumber, Unsigned16 recordsToGenerate, Unsigned16 checksum) throws IOException {
        byte[] row = new byte[100];
        Unsigned16 recordNumber = new Unsigned16(firstRecordNumber);
        Unsigned16 lastRecordNumber = new Unsigned16(firstRecordNumber);
        PureJavaCrc32 crc = new PureJavaCrc32();
        Unsigned16 tmp = new Unsigned16();
        lastRecordNumber.add(recordsToGenerate);
        Unsigned16 ONE = new Unsigned16(1L);
        Unsigned16 rand = Random16.skipAhead((Unsigned16)firstRecordNumber);
        while (!recordNumber.equals((Object)lastRecordNumber)) {
            Random16.nextRand((Unsigned16)rand);
            if (useAscii) {
                GenSort.generateAsciiRecord((byte[])row, (Unsigned16)rand, (Unsigned16)recordNumber);
            } else {
                GenSort.generateRecord((byte[])row, (Unsigned16)rand, (Unsigned16)recordNumber);
            }
            if (checksum != null) {
                crc.reset();
                crc.update(row, 0, row.length);
                tmp.set(crc.getValue());
                checksum.add(tmp);
            }
            recordNumber.add(ONE);
            out.write(row);
        }
    }

    public static void main(String[] args) throws Exception {
        String arg;
        int argLength;
        int i;
        Unsigned16 startingRecord = new Unsigned16();
        boolean useAscii = false;
        Unsigned16 checksum = null;
        block5: for (i = 0; i < args.length && (argLength = (arg = args[i]).length()) >= 1 && arg.charAt(0) == '-'; ++i) {
            if (argLength < 2) {
                GenSort.usage();
            }
            switch (arg.charAt(1)) {
                case 'a': {
                    useAscii = true;
                    continue block5;
                }
                case 'b': {
                    startingRecord = Unsigned16.fromDecimal((String)arg.substring(2));
                    continue block5;
                }
                case 'c': {
                    checksum = new Unsigned16();
                    continue block5;
                }
                default: {
                    GenSort.usage();
                }
            }
        }
        if (args.length - i != 2) {
            GenSort.usage();
        }
        Unsigned16 numberOfRecords = Unsigned16.fromDecimal((String)args[i]);
        FileOutputStream out = new FileOutputStream(args[i + 1]);
        GenSort.outputRecords((OutputStream)out, (boolean)useAscii, (Unsigned16)startingRecord, (Unsigned16)numberOfRecords, (Unsigned16)checksum);
        ((OutputStream)out).close();
        if (checksum != null) {
            System.out.println(checksum);
        }
    }
}

