/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.terasort;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.examples.terasort.TeraGen;
import org.apache.hadoop.examples.terasort.TeraOutputFormat;
import org.apache.hadoop.examples.terasort.TeraSort;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

/*
 * Exception performing whole class analysis ignored.
 */
public class TeraGen
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(TeraSort.class);
    public static final String NUM_ROWS = "mapreduce.terasort.num-rows";

    static long getNumberOfRows(JobContext job) {
        return job.getConfiguration().getLong("mapreduce.terasort.num-rows", 0L);
    }

    static void setNumberOfRows(Job job, long numRows) {
        job.getConfiguration().setLong("mapreduce.terasort.num-rows", numRows);
    }

    private static void usage() throws IOException {
        System.err.println("teragen <num rows> <output dir>");
    }

    private static long parseHumanLong(String str) {
        char tail = str.charAt(str.length() - 1);
        long base = 1L;
        switch (tail) {
            case 't': {
                base *= -727379968L;
                break;
            }
            case 'b': {
                base *= 1000000000L;
                break;
            }
            case 'm': {
                base *= 1000000L;
                break;
            }
            case 'k': {
                base *= 1000L;
                break;
            }
        }
        if (base != 1L) {
            str = str.substring(0, str.length() - 1);
        }
        return Long.parseLong(str) * base;
    }

    public int run(String[] args) throws IOException, InterruptedException, ClassNotFoundException {
        Job job = Job.getInstance((Configuration)this.getConf());
        if (args.length != 2) {
            TeraGen.usage();
            return 2;
        }
        TeraGen.setNumberOfRows((Job)job, (long)TeraGen.parseHumanLong((String)args[0]));
        Path outputDir = new Path(args[1]);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputDir);
        job.setJobName("TeraGen");
        job.setJarByClass(TeraGen.class);
        job.setMapperClass(SortGenMapper.class);
        job.setNumReduceTasks(0);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setInputFormatClass(RangeInputFormat.class);
        job.setOutputFormatClass(TeraOutputFormat.class);
        return job.waitForCompletion(true) ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new TeraGen(), (String[])args);
        System.exit(res);
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }
}

