/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.maven.plugin.cmakebuilder;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.maven.plugin.util.Exec;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="cmake-compile", defaultPhase=LifecyclePhase.COMPILE)
public class CompileMojo
extends AbstractMojo {
    private static int availableProcessors = Runtime.getRuntime().availableProcessors();
    @Parameter(defaultValue="${project.build.directory}/native")
    private File output;
    @Parameter(defaultValue="${basedir}/src/main/native", required=true)
    private File source;
    @Parameter
    private String target;
    @Parameter
    private Map<String, String> env;
    @Parameter
    private Map<String, String> vars;

    private static void validatePlatform() throws MojoExecutionException {
        if (System.getProperty("os.name").toLowerCase(Locale.ENGLISH).startsWith("windows")) {
            throw new MojoExecutionException("CMakeBuilder does not yet support the Windows platform.");
        }
    }

    public void execute() throws MojoExecutionException {
        long start = System.nanoTime();
        CompileMojo.validatePlatform();
        this.runCMake();
        this.runMake();
        long end = System.nanoTime();
        this.getLog().info((CharSequence)("cmake compilation finished successfully in " + TimeUnit.MILLISECONDS.convert(end - start, TimeUnit.NANOSECONDS) + " millisecond(s)."));
    }

    static void validateSourceParams(File source, File output) throws MojoExecutionException {
        String cOutput = null;
        String cSource = null;
        try {
            cOutput = output.getCanonicalPath();
        }
        catch (IOException e) {
            throw new MojoExecutionException("error getting canonical path for output", (Exception)e);
        }
        try {
            cSource = source.getCanonicalPath();
        }
        catch (IOException e) {
            throw new MojoExecutionException("error getting canonical path for source", (Exception)e);
        }
        if (cSource.startsWith(cOutput)) {
            throw new MojoExecutionException("The source directory must not be inside the output directory (it would be destroyed by 'mvn clean')");
        }
    }

    public void runCMake() throws MojoExecutionException {
        CompileMojo.validatePlatform();
        CompileMojo.validateSourceParams(this.source, this.output);
        if (this.output.mkdirs()) {
            this.getLog().info((CharSequence)("mkdirs '" + this.output + "'"));
        }
        LinkedList<String> cmd = new LinkedList<String>();
        cmd.add("cmake");
        cmd.add(this.source.getAbsolutePath());
        for (Map.Entry<String, String> entry : this.vars.entrySet()) {
            if (entry.getValue() == null || entry.getValue().equals("")) continue;
            cmd.add("-D" + entry.getKey() + "=" + entry.getValue());
        }
        cmd.add("-G");
        cmd.add("Unix Makefiles");
        String prefix = "";
        StringBuilder bld = new StringBuilder();
        for (String c : cmd) {
            bld.append(prefix).append(c);
            prefix = " ";
        }
        this.getLog().info((CharSequence)("Running " + bld.toString()));
        this.getLog().info((CharSequence)("with extra environment variables " + Exec.envToString(this.env)));
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.directory(this.output);
        pb.redirectErrorStream(true);
        Exec.addEnvironment(pb, this.env);
        Process proc = null;
        Exec.OutputBufferThread outThread = null;
        int retCode = -1;
        try {
            proc = pb.start();
            outThread = new Exec.OutputBufferThread(proc.getInputStream());
            outThread.start();
            retCode = proc.waitFor();
            if (retCode != 0) {
                throw new MojoExecutionException("CMake failed with error code " + retCode);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error executing CMake", (Exception)e);
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("Interrupted while waiting for CMake process", (Exception)e);
        }
        finally {
            if (proc != null) {
                proc.destroy();
            }
            if (outThread != null) {
                try {
                    outThread.interrupt();
                    outThread.join();
                }
                catch (InterruptedException e) {
                    this.getLog().error((CharSequence)"Interrupted while joining output thread", (Throwable)e);
                }
                if (retCode != 0) {
                    for (String line : outThread.getOutput()) {
                        this.getLog().warn((CharSequence)line);
                    }
                }
            }
        }
    }

    public void runMake() throws MojoExecutionException {
        LinkedList<String> cmd = new LinkedList<String>();
        cmd.add("make");
        cmd.add("-j");
        cmd.add(String.valueOf(availableProcessors));
        cmd.add("VERBOSE=1");
        if (this.target != null) {
            cmd.add(this.target);
        }
        StringBuilder bld = new StringBuilder();
        String prefix = "";
        for (String c : cmd) {
            bld.append(prefix).append(c);
            prefix = " ";
        }
        this.getLog().info((CharSequence)("Running " + bld.toString()));
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.directory(this.output);
        Process proc = null;
        int retCode = -1;
        Thread stdoutThread = null;
        Thread stderrThread = null;
        try {
            proc = pb.start();
            stdoutThread = new Exec.OutputBufferThread(proc.getInputStream());
            stderrThread = new Exec.OutputBufferThread(proc.getErrorStream());
            stdoutThread.start();
            stderrThread.start();
            retCode = proc.waitFor();
            if (retCode != 0) {
                throw new MojoExecutionException("make failed with error code " + retCode);
            }
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("Interrupted during Process#waitFor", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error executing make", (Exception)e);
        }
        finally {
            if (stdoutThread != null) {
                try {
                    stdoutThread.join();
                }
                catch (InterruptedException e) {
                    this.getLog().error((CharSequence)"Interrupted while joining stdoutThread", (Throwable)e);
                }
                if (retCode != 0) {
                    for (String line : ((Exec.OutputBufferThread)stdoutThread).getOutput()) {
                        this.getLog().warn((CharSequence)line);
                    }
                }
            }
            if (stderrThread != null) {
                try {
                    stderrThread.join();
                }
                catch (InterruptedException e) {
                    this.getLog().error((CharSequence)"Interrupted while joining stderrThread", (Throwable)e);
                }
                for (String line : ((Exec.OutputBufferThread)stderrThread).getOutput()) {
                    this.getLog().warn((CharSequence)line);
                }
            }
            if (proc != null) {
                proc.destroy();
            }
        }
    }
}

