/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3.request;

import java.io.IOException;
import org.apache.commons.io.Charsets;
import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.nfs.nfs3.request.RequestWithHandle;
import org.apache.hadoop.nfs.nfs3.request.SetAttr3;
import org.apache.hadoop.oncrpc.XDR;

public class CREATE3Request
extends RequestWithHandle {
    private final String name;
    private final int mode;
    private final SetAttr3 objAttr;
    private long verf = 0L;

    public CREATE3Request(FileHandle handle, String name, int mode, SetAttr3 objAttr, long verf) {
        super(handle);
        this.name = name;
        this.mode = mode;
        this.objAttr = objAttr;
        this.verf = verf;
    }

    public static CREATE3Request deserialize(XDR xdr) throws IOException {
        FileHandle handle = CREATE3Request.readHandle(xdr);
        String name = xdr.readString();
        int mode = xdr.readInt();
        SetAttr3 objAttr = new SetAttr3();
        long verf = 0L;
        if (mode == 0 || mode == 1) {
            objAttr.deserialize(xdr);
        } else if (mode == 2) {
            verf = xdr.readHyper();
        } else {
            throw new IOException("Wrong create mode:" + mode);
        }
        return new CREATE3Request(handle, name, mode, objAttr, verf);
    }

    public String getName() {
        return this.name;
    }

    public int getMode() {
        return this.mode;
    }

    public SetAttr3 getObjAttr() {
        return this.objAttr;
    }

    public long getVerf() {
        return this.verf;
    }

    @Override
    public void serialize(XDR xdr) {
        this.handle.serialize(xdr);
        xdr.writeInt(this.name.length());
        xdr.writeFixedOpaque(this.name.getBytes(Charsets.UTF_8), this.name.length());
        xdr.writeInt(this.mode);
        this.objAttr.serialize(xdr);
    }
}

