/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs;

import org.apache.hadoop.nfs.AccessPrivilege;
import org.apache.hadoop.nfs.NfsExports;
import org.junit.Assert;
import org.junit.Test;

public class TestNfsExports {
    private final String address1 = "192.168.0.12";
    private final String address2 = "10.0.0.12";
    private final String hostname1 = "a.b.com";
    private final String hostname2 = "a.b.org";
    private static final long ExpirationPeriod = 900000000000L;
    private static final int CacheSize = 512;
    private static final long NanosPerMillis = 1000000L;

    @Test
    public void testWildcardRW() {
        NfsExports matcher = new NfsExports(512, 900000000000L, "* rw");
        Assert.assertEquals((Object)AccessPrivilege.READ_WRITE, (Object)matcher.getAccessPrivilege("192.168.0.12", "a.b.com"));
    }

    @Test
    public void testWildcardRO() {
        NfsExports matcher = new NfsExports(512, 900000000000L, "* ro");
        Assert.assertEquals((Object)AccessPrivilege.READ_ONLY, (Object)matcher.getAccessPrivilege("192.168.0.12", "a.b.com"));
    }

    @Test
    public void testExactAddressRW() {
        NfsExports matcher = new NfsExports(512, 900000000000L, "192.168.0.12 rw");
        Assert.assertEquals((Object)AccessPrivilege.READ_WRITE, (Object)matcher.getAccessPrivilege("192.168.0.12", "a.b.com"));
        Assert.assertFalse((AccessPrivilege.READ_WRITE == matcher.getAccessPrivilege("10.0.0.12", "a.b.com") ? 1 : 0) != 0);
    }

    @Test
    public void testExactAddressRO() {
        NfsExports matcher = new NfsExports(512, 900000000000L, "192.168.0.12");
        Assert.assertEquals((Object)AccessPrivilege.READ_ONLY, (Object)matcher.getAccessPrivilege("192.168.0.12", "a.b.com"));
        Assert.assertEquals((Object)AccessPrivilege.NONE, (Object)matcher.getAccessPrivilege("10.0.0.12", "a.b.com"));
    }

    @Test
    public void testExactHostRW() {
        NfsExports matcher = new NfsExports(512, 900000000000L, "a.b.com rw");
        Assert.assertEquals((Object)AccessPrivilege.READ_WRITE, (Object)matcher.getAccessPrivilege("192.168.0.12", "a.b.com"));
    }

    @Test
    public void testExactHostRO() {
        NfsExports matcher = new NfsExports(512, 900000000000L, "a.b.com");
        Assert.assertEquals((Object)AccessPrivilege.READ_ONLY, (Object)matcher.getAccessPrivilege("192.168.0.12", "a.b.com"));
    }

    @Test
    public void testCidrShortRW() {
        NfsExports matcher = new NfsExports(512, 900000000000L, "192.168.0.0/22 rw");
        Assert.assertEquals((Object)AccessPrivilege.READ_WRITE, (Object)matcher.getAccessPrivilege("192.168.0.12", "a.b.com"));
        Assert.assertEquals((Object)AccessPrivilege.NONE, (Object)matcher.getAccessPrivilege("10.0.0.12", "a.b.com"));
    }

    @Test
    public void testCidrShortRO() {
        NfsExports matcher = new NfsExports(512, 900000000000L, "192.168.0.0/22");
        Assert.assertEquals((Object)AccessPrivilege.READ_ONLY, (Object)matcher.getAccessPrivilege("192.168.0.12", "a.b.com"));
        Assert.assertEquals((Object)AccessPrivilege.NONE, (Object)matcher.getAccessPrivilege("10.0.0.12", "a.b.com"));
    }

    @Test
    public void testCidrLongRW() {
        NfsExports matcher = new NfsExports(512, 900000000000L, "192.168.0.0/255.255.252.0 rw");
        Assert.assertEquals((Object)AccessPrivilege.READ_WRITE, (Object)matcher.getAccessPrivilege("192.168.0.12", "a.b.com"));
        Assert.assertEquals((Object)AccessPrivilege.NONE, (Object)matcher.getAccessPrivilege("10.0.0.12", "a.b.com"));
    }

    @Test
    public void testCidrLongRO() {
        NfsExports matcher = new NfsExports(512, 900000000000L, "192.168.0.0/255.255.252.0");
        Assert.assertEquals((Object)AccessPrivilege.READ_ONLY, (Object)matcher.getAccessPrivilege("192.168.0.12", "a.b.com"));
        Assert.assertEquals((Object)AccessPrivilege.NONE, (Object)matcher.getAccessPrivilege("10.0.0.12", "a.b.com"));
    }

    @Test
    public void testRegexIPRW() {
        NfsExports matcher = new NfsExports(512, 900000000000L, "192.168.0.[0-9]+ rw");
        Assert.assertEquals((Object)AccessPrivilege.READ_WRITE, (Object)matcher.getAccessPrivilege("192.168.0.12", "a.b.com"));
        Assert.assertEquals((Object)AccessPrivilege.NONE, (Object)matcher.getAccessPrivilege("10.0.0.12", "a.b.com"));
    }

    @Test
    public void testRegexIPRO() {
        NfsExports matcher = new NfsExports(512, 900000000000L, "192.168.0.[0-9]+");
        Assert.assertEquals((Object)AccessPrivilege.READ_ONLY, (Object)matcher.getAccessPrivilege("192.168.0.12", "a.b.com"));
        Assert.assertEquals((Object)AccessPrivilege.NONE, (Object)matcher.getAccessPrivilege("10.0.0.12", "a.b.com"));
    }

    @Test
    public void testRegexHostRW() {
        NfsExports matcher = new NfsExports(512, 900000000000L, "[a-z]+.b.com rw");
        Assert.assertEquals((Object)AccessPrivilege.READ_WRITE, (Object)matcher.getAccessPrivilege("192.168.0.12", "a.b.com"));
        Assert.assertEquals((Object)AccessPrivilege.READ_WRITE, (Object)matcher.getAccessPrivilege("192.168.0.12", "a.b.org"));
    }

    @Test
    public void testRegexHostRO() {
        NfsExports matcher = new NfsExports(512, 900000000000L, "[a-z]+.b.com");
        Assert.assertEquals((Object)AccessPrivilege.READ_ONLY, (Object)matcher.getAccessPrivilege("192.168.0.12", "a.b.com"));
        Assert.assertEquals((Object)AccessPrivilege.READ_ONLY, (Object)matcher.getAccessPrivilege("192.168.0.12", "a.b.org"));
    }

    @Test
    public void testRegexGrouping() {
        NfsExports matcher = new NfsExports(512, 900000000000L, "192.168.0.(12|34)");
        Assert.assertEquals((Object)AccessPrivilege.READ_ONLY, (Object)matcher.getAccessPrivilege("192.168.0.12", "a.b.com"));
        Assert.assertEquals((Object)AccessPrivilege.READ_ONLY, (Object)matcher.getAccessPrivilege("192.168.0.12", "a.b.org"));
        matcher = new NfsExports(512, 900000000000L, "\\w*.a.b.com");
        Assert.assertEquals((Object)AccessPrivilege.READ_ONLY, (Object)matcher.getAccessPrivilege("1.2.3.4", "web.a.b.com"));
        Assert.assertEquals((Object)AccessPrivilege.READ_ONLY, (Object)matcher.getAccessPrivilege("1.2.3.4", "email.a.b.org"));
    }

    @Test
    public void testMultiMatchers() throws Exception {
        AccessPrivilege ap;
        long shortExpirationPeriod = 1000000000L;
        NfsExports matcher = new NfsExports(512, shortExpirationPeriod, "192.168.0.[0-9]+;[a-z]+.b.com rw");
        Assert.assertEquals((Object)AccessPrivilege.READ_ONLY, (Object)matcher.getAccessPrivilege("192.168.0.12", "a.b.org"));
        Assert.assertEquals((Object)AccessPrivilege.READ_ONLY, (Object)matcher.getAccessPrivilege("192.168.0.12", "192.168.0.12"));
        Assert.assertEquals((Object)AccessPrivilege.READ_ONLY, (Object)matcher.getAccessPrivilege("192.168.0.12", "a.b.com"));
        Assert.assertEquals((Object)AccessPrivilege.READ_WRITE, (Object)matcher.getAccessPrivilege("10.0.0.12", "a.b.com"));
        Assert.assertEquals((Object)AccessPrivilege.READ_WRITE, (Object)matcher.getAccessPrivilege("10.0.0.12", "a.b.org"));
        Thread.sleep(1000L);
        long startNanos = System.nanoTime();
        while ((ap = matcher.getAccessPrivilege("10.0.0.12", "10.0.0.12")) != AccessPrivilege.NONE) {
            Thread.sleep(500L);
            if ((System.nanoTime() - startNanos) / 1000000L < 5000L) continue;
        }
        Assert.assertEquals((Object)AccessPrivilege.NONE, (Object)ap);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidHost() {
        NfsExports matcher = new NfsExports(512, 900000000000L, "foo#bar");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidSeparator() {
        NfsExports matcher = new NfsExports(512, 900000000000L, "foo ro : bar rw");
    }
}

