/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.portmap;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Map;
import org.apache.hadoop.oncrpc.RpcCall;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.Credentials;
import org.apache.hadoop.oncrpc.security.CredentialsNone;
import org.apache.hadoop.oncrpc.security.Verifier;
import org.apache.hadoop.oncrpc.security.VerifierNone;
import org.apache.hadoop.portmap.Portmap;
import org.apache.hadoop.portmap.PortmapMapping;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.internal.util.reflection.Whitebox;

public class TestPortmap {
    private static Portmap pm = new Portmap();
    private static final int SHORT_TIMEOUT_MILLISECONDS = 10;
    private static final int RETRY_TIMES = 5;
    private int xid;

    @BeforeClass
    public static void setup() {
        pm.start(10, (SocketAddress)new InetSocketAddress("localhost", 0), (SocketAddress)new InetSocketAddress("localhost", 0));
    }

    @AfterClass
    public static void tearDown() {
        pm.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=1000L)
    public void testIdle() throws InterruptedException, IOException {
        try (Socket s = new Socket();){
            int i;
            s.connect(pm.getTcpServerLocalAddress());
            for (i = 0; !s.isConnected() && i < 5; ++i) {
                Thread.sleep(10L);
            }
            Assert.assertTrue((String)"Failed to connect to the server", (s.isConnected() && i < 5 ? 1 : 0) != 0);
            int b = s.getInputStream().read();
            Assert.assertTrue((String)"The server failed to disconnect", (b == -1 ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=1000L)
    public void testRegistration() throws IOException, InterruptedException {
        XDR req = new XDR();
        RpcCall.getInstance((int)(++this.xid), (int)100000, (int)2, (int)1, (Credentials)new CredentialsNone(), (Verifier)new VerifierNone()).write(req);
        PortmapMapping sent = new PortmapMapping(90000, 1, 6, 1234);
        sent.serialize(req);
        byte[] reqBuf = req.getBytes();
        DatagramPacket p = new DatagramPacket(reqBuf, reqBuf.length, pm.getUdpServerLoAddress());
        try (DatagramSocket s = new DatagramSocket();){
            s.send(p);
        }
        Thread.sleep(100L);
        boolean found = false;
        Map map = (Map)Whitebox.getInternalState((Object)pm.getHandler(), (String)"map");
        for (PortmapMapping m : map.values()) {
            if (m.getPort() != sent.getPort() || !PortmapMapping.key((PortmapMapping)m).equals(PortmapMapping.key((PortmapMapping)sent))) continue;
            found = true;
            break;
        }
        Assert.assertTrue((String)"Registration failed", (boolean)found);
    }
}

