/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3.request;

import java.io.IOException;
import org.apache.commons.io.Charsets;
import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.nfs.nfs3.request.RequestWithHandle;
import org.apache.hadoop.nfs.nfs3.request.SetAttr3;
import org.apache.hadoop.oncrpc.XDR;

public class MKDIR3Request
extends RequestWithHandle {
    private final String name;
    private final SetAttr3 objAttr;

    public static MKDIR3Request deserialize(XDR xdr) throws IOException {
        FileHandle handle = MKDIR3Request.readHandle(xdr);
        String name = xdr.readString();
        SetAttr3 objAttr = new SetAttr3();
        objAttr.deserialize(xdr);
        return new MKDIR3Request(handle, name, objAttr);
    }

    public MKDIR3Request(FileHandle handle, String name, SetAttr3 objAttr) {
        super(handle);
        this.name = name;
        this.objAttr = objAttr;
    }

    public String getName() {
        return this.name;
    }

    public SetAttr3 getObjAttr() {
        return this.objAttr;
    }

    @Override
    public void serialize(XDR xdr) {
        this.handle.serialize(xdr);
        xdr.writeInt(this.name.getBytes(Charsets.UTF_8).length);
        xdr.writeFixedOpaque(this.name.getBytes(Charsets.UTF_8));
        this.objAttr.serialize(xdr);
    }
}

