/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3.response;

import java.util.ArrayList;
import org.apache.hadoop.nfs.nfs3.Nfs3FileAttributes;
import org.apache.hadoop.nfs.nfs3.response.NFS3Response;
import org.apache.hadoop.nfs.nfs3.response.READDIR3Response;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.Verifier;

/*
 * Exception performing whole class analysis ignored.
 */
public class READDIR3Response
extends NFS3Response {
    private final Nfs3FileAttributes postOpDirAttr;
    private final long cookieVerf;
    private final DirList3 dirList;

    public READDIR3Response(int status) {
        this(status, new Nfs3FileAttributes());
    }

    public READDIR3Response(int status, Nfs3FileAttributes postOpAttr) {
        this(status, postOpAttr, 0L, null);
    }

    public READDIR3Response(int status, Nfs3FileAttributes postOpAttr, long cookieVerf, DirList3 dirList) {
        super(status);
        this.postOpDirAttr = postOpAttr;
        this.cookieVerf = cookieVerf;
        this.dirList = dirList;
    }

    public Nfs3FileAttributes getPostOpAttr() {
        return this.postOpDirAttr;
    }

    public long getCookieVerf() {
        return this.cookieVerf;
    }

    public DirList3 getDirList() {
        return this.dirList;
    }

    public static READDIR3Response deserialize(XDR xdr) {
        int status = xdr.readInt();
        xdr.readBoolean();
        Nfs3FileAttributes postOpDirAttr = Nfs3FileAttributes.deserialize((XDR)xdr);
        long cookieVerf = 0L;
        ArrayList<Entry3> entries = new ArrayList<Entry3>();
        DirList3 dirList = null;
        if (status == 0) {
            cookieVerf = xdr.readHyper();
            while (xdr.readBoolean()) {
                Entry3 e = Entry3.deserialzie((XDR)xdr);
                entries.add(e);
            }
            boolean eof = xdr.readBoolean();
            Entry3[] allEntries = new Entry3[entries.size()];
            entries.toArray(allEntries);
            dirList = new DirList3(allEntries, eof);
        }
        return new READDIR3Response(status, postOpDirAttr, cookieVerf, dirList);
    }

    public XDR serialize(XDR xdr, int xid, Verifier verifier) {
        super.serialize(xdr, xid, verifier);
        xdr.writeBoolean(true);
        this.postOpDirAttr.serialize(xdr);
        if (this.getStatus() == 0) {
            xdr.writeLongAsHyper(this.cookieVerf);
            for (Entry3 e : this.dirList.entries) {
                xdr.writeBoolean(true);
                e.seralize(xdr);
            }
            xdr.writeBoolean(false);
            xdr.writeBoolean(this.dirList.eof);
        }
        return xdr;
    }
}

