/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.hadoop.oncrpc.XDR;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;

public class SimpleTcpClient {
    protected final String host;
    protected final int port;
    protected final XDR request;
    protected ChannelPipelineFactory pipelineFactory;
    protected final boolean oneShot;

    public SimpleTcpClient(String host, int port, XDR request) {
        this(host, port, request, Boolean.valueOf(true));
    }

    public SimpleTcpClient(String host, int port, XDR request, Boolean oneShot) {
        this.host = host;
        this.port = port;
        this.request = request;
        this.oneShot = oneShot;
    }

    protected ChannelPipelineFactory setPipelineFactory() {
        this.pipelineFactory = new /* Unavailable Anonymous Inner Class!! */;
        return this.pipelineFactory;
    }

    public void run() {
        NioClientSocketChannelFactory factory = new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool(), 1, 1);
        ClientBootstrap bootstrap = new ClientBootstrap((ChannelFactory)factory);
        bootstrap.setPipelineFactory(this.setPipelineFactory());
        bootstrap.setOption("tcpNoDelay", (Object)true);
        bootstrap.setOption("keepAlive", (Object)true);
        ChannelFuture future = bootstrap.connect((SocketAddress)new InetSocketAddress(this.host, this.port));
        if (this.oneShot) {
            future.getChannel().getCloseFuture().awaitUninterruptibly();
            bootstrap.releaseExternalResources();
        }
    }
}

