/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3.response;

import org.apache.hadoop.nfs.nfs3.Nfs3FileAttributes;
import org.apache.hadoop.nfs.nfs3.response.NFS3Response;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.Verifier;

public class READLINK3Response
extends NFS3Response {
    private final Nfs3FileAttributes postOpSymlinkAttr;
    private final byte[] path;

    public READLINK3Response(int status) {
        this(status, new Nfs3FileAttributes(), new byte[0]);
    }

    public READLINK3Response(int status, Nfs3FileAttributes postOpAttr, byte[] path) {
        super(status);
        this.postOpSymlinkAttr = postOpAttr;
        this.path = new byte[path.length];
        System.arraycopy(path, 0, this.path, 0, path.length);
    }

    public static READLINK3Response deserialize(XDR xdr) {
        int status = xdr.readInt();
        xdr.readBoolean();
        Nfs3FileAttributes postOpSymlinkAttr = Nfs3FileAttributes.deserialize(xdr);
        byte[] path = new byte[]{};
        if (status == 0) {
            path = xdr.readVariableOpaque();
        }
        return new READLINK3Response(status, postOpSymlinkAttr, path);
    }

    @Override
    public XDR serialize(XDR out, int xid, Verifier verifier) {
        super.serialize(out, xid, verifier);
        out.writeBoolean(true);
        this.postOpSymlinkAttr.serialize(out);
        if (this.getStatus() == 0) {
            out.writeVariableOpaque(this.path);
        }
        return out;
    }
}

