/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.swift.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.swift.util.Duration;
import org.apache.hadoop.fs.swift.util.DurationStats;

public class DurationStatsTable {
    private Map<String, DurationStats> statsTable = new HashMap(6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String operation, Duration duration, boolean success) {
        DurationStats durationStats;
        String key = operation;
        if (!success) {
            key = key + "-FAIL";
        }
        DurationStatsTable durationStatsTable = this;
        synchronized (durationStatsTable) {
            durationStats = (DurationStats)this.statsTable.get(key);
            if (durationStats == null) {
                durationStats = new DurationStats(key);
                this.statsTable.put(key, durationStats);
            }
        }
        durationStatsTable = durationStats;
        synchronized (durationStatsTable) {
            durationStats.add(duration);
        }
    }

    public synchronized List<DurationStats> getDurationStatistics() {
        ArrayList<DurationStats> results = new ArrayList<DurationStats>(this.statsTable.size());
        for (DurationStats stat : this.statsTable.values()) {
            results.add(new DurationStats(stat));
        }
        return results;
    }

    public synchronized void reset() {
        for (DurationStats stat : this.statsTable.values()) {
            stat.reset();
        }
    }
}

