/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.swift.http;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Properties;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpHost;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.swift.auth.ApiKeyAuthenticationRequest;
import org.apache.hadoop.fs.swift.auth.ApiKeyCredentials;
import org.apache.hadoop.fs.swift.auth.AuthenticationRequest;
import org.apache.hadoop.fs.swift.auth.AuthenticationRequestWrapper;
import org.apache.hadoop.fs.swift.auth.KeyStoneAuthRequest;
import org.apache.hadoop.fs.swift.auth.KeystoneApiKeyCredentials;
import org.apache.hadoop.fs.swift.auth.PasswordAuthenticationRequest;
import org.apache.hadoop.fs.swift.auth.PasswordCredentials;
import org.apache.hadoop.fs.swift.auth.entities.AccessToken;
import org.apache.hadoop.fs.swift.exceptions.SwiftAuthenticationFailedException;
import org.apache.hadoop.fs.swift.exceptions.SwiftBadRequestException;
import org.apache.hadoop.fs.swift.exceptions.SwiftConfigurationException;
import org.apache.hadoop.fs.swift.exceptions.SwiftException;
import org.apache.hadoop.fs.swift.exceptions.SwiftInternalStateException;
import org.apache.hadoop.fs.swift.exceptions.SwiftInvalidResponseException;
import org.apache.hadoop.fs.swift.exceptions.SwiftThrottledRequestException;
import org.apache.hadoop.fs.swift.http.ExceptionDiags;
import org.apache.hadoop.fs.swift.http.HttpBodyContent;
import org.apache.hadoop.fs.swift.http.RestClientBindings;
import org.apache.hadoop.fs.swift.http.SwiftProtocolConstants;
import org.apache.hadoop.fs.swift.http.SwiftRestClient;
import org.apache.hadoop.fs.swift.util.Duration;
import org.apache.hadoop.fs.swift.util.DurationStats;
import org.apache.hadoop.fs.swift.util.DurationStatsTable;
import org.apache.hadoop.fs.swift.util.JSONUtil;
import org.apache.hadoop.fs.swift.util.SwiftObjectPath;
import org.apache.hadoop.fs.swift.util.SwiftUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SwiftRestClient {
    private static final Log LOG = LogFactory.getLog(SwiftRestClient.class);
    public static final Header NEWEST = new Header("X-Newest", "true");
    private final URI authUri;
    private final String region;
    private final String tenant;
    private final String username;
    private final String password;
    private final String apiKey;
    private final AuthenticationRequest authRequest;
    private AuthenticationRequest keystoneAuthRequest;
    private boolean useKeystoneAuthentication = false;
    private final String container;
    private final String serviceDescription;
    private AccessToken token;
    private URI endpointURI;
    private URI objectLocationURI;
    private final URI filesystemURI;
    private final String serviceProvider;
    private final boolean usePublicURL;
    private final int retryCount;
    private final int connectTimeout;
    private final int socketTimeout;
    private final int throttleDelay;
    private String proxyHost;
    private int proxyPort;
    private final boolean locationAware;
    private final int partSizeKB;
    private final int blocksizeKB;
    private final int bufferSizeKB;
    private final DurationStatsTable durationStats = new DurationStatsTable();

    private synchronized URI getEndpointURI() {
        return this.endpointURI;
    }

    private synchronized URI getObjectLocationURI() {
        return this.objectLocationURI;
    }

    private synchronized AccessToken getToken() {
        return this.token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAuthDetails(URI endpoint, URI objectLocation, AccessToken authToken) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("setAuth: endpoint=%s; objectURI=%s; token=%s", endpoint, objectLocation, authToken));
        }
        SwiftRestClient swiftRestClient = this;
        synchronized (swiftRestClient) {
            this.endpointURI = endpoint;
            this.objectLocationURI = objectLocation;
            this.token = authToken;
        }
    }

    private SwiftRestClient(URI filesystemURI, Configuration conf) throws SwiftConfigurationException {
        this.filesystemURI = filesystemURI;
        Properties props = RestClientBindings.bind((URI)filesystemURI, (Configuration)conf);
        String stringAuthUri = SwiftRestClient.getOption((Properties)props, (String)"fs.swift.auth.url");
        this.username = SwiftRestClient.getOption((Properties)props, (String)"fs.swift.username");
        this.password = props.getProperty("fs.swift.password");
        this.apiKey = props.getProperty("fs.swift.apikey");
        this.region = props.getProperty("fs.swift.region");
        this.tenant = props.getProperty("fs.swift.tenant");
        this.serviceProvider = props.getProperty("fs.swift.SERVICE-NAME");
        this.container = props.getProperty("fs.swift.CONTAINER-NAME");
        String isPubProp = props.getProperty("fs.swift.public", "false");
        this.usePublicURL = "true".equals(isPubProp);
        if (this.apiKey == null && this.password == null) {
            throw new SwiftConfigurationException("Configuration for " + filesystemURI + " must contain either " + "fs.swift.password" + " or " + "fs.swift.apikey");
        }
        if (this.password != null) {
            this.authRequest = new PasswordAuthenticationRequest(this.tenant, new PasswordCredentials(this.username, this.password));
        } else {
            this.authRequest = new ApiKeyAuthenticationRequest(this.tenant, new ApiKeyCredentials(this.username, this.apiKey));
            this.keystoneAuthRequest = new KeyStoneAuthRequest(this.tenant, new KeystoneApiKeyCredentials(this.username, this.apiKey));
        }
        this.locationAware = "true".equals(props.getProperty("fs.swift.location-aware", "false"));
        try {
            this.retryCount = conf.getInt("fs.swift.connect.retry.count", 3);
            this.connectTimeout = conf.getInt("fs.swift.connect.timeout", 15000);
            this.socketTimeout = conf.getInt("fs.swift.socket.timeout", 60000);
            this.throttleDelay = conf.getInt("fs.swift.connect.throttle.delay", 0);
            this.proxyHost = conf.get("fs.swift.proxy.host");
            this.proxyPort = conf.getInt("fs.swift.proxy.port", 8080);
            this.blocksizeKB = conf.getInt("fs.swift.blocksize", 32768);
            if (this.blocksizeKB <= 0) {
                throw new SwiftConfigurationException("Invalid blocksize set in fs.swift.blocksize: " + this.blocksizeKB);
            }
            this.partSizeKB = conf.getInt("fs.swift.partsize", 0x480000);
            if (this.partSizeKB <= 0) {
                throw new SwiftConfigurationException("Invalid partition size set in fs.swift.partsize: " + this.partSizeKB);
            }
            this.bufferSizeKB = conf.getInt("fs.swift.requestsize", 64);
            if (this.bufferSizeKB <= 0) {
                throw new SwiftConfigurationException("Invalid buffer size set in fs.swift.requestsize: " + this.bufferSizeKB);
            }
        }
        catch (NumberFormatException e) {
            throw new SwiftConfigurationException(e.toString(), (Throwable)e);
        }
        this.serviceDescription = String.format("Service={%s} container={%s} uri={%s} tenant={%s} user={%s} region={%s} publicURL={%b} location aware={%b} partition size={%d KB}, buffer size={%d KB} block size={%d KB} connect timeout={%d}, retry count={%d} socket timeout={%d} throttle delay={%d}", this.serviceProvider, this.container, stringAuthUri, this.tenant, this.username, this.region != null ? this.region : "(none)", this.usePublicURL, this.locationAware, this.partSizeKB, this.bufferSizeKB, this.blocksizeKB, this.connectTimeout, this.retryCount, this.socketTimeout, this.throttleDelay);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)this.serviceDescription);
        }
        try {
            this.authUri = new URI(stringAuthUri);
        }
        catch (URISyntaxException e) {
            throw new SwiftConfigurationException("The fs.swift.auth.url property was incorrect: " + stringAuthUri, (Throwable)e);
        }
    }

    private static String getOption(Properties props, String key) throws SwiftConfigurationException {
        String val = props.getProperty(key);
        if (val == null) {
            throw new SwiftConfigurationException("Undefined property: " + key);
        }
        return val;
    }

    public HttpBodyContent getData(SwiftObjectPath path, long offset, long length) throws IOException {
        if (offset < 0L) {
            throw new SwiftException("Invalid offset: " + offset + " in getDataAsInputStream( path=" + path + ", offset=" + offset + ", length =" + length + ")");
        }
        if (length <= 0L) {
            throw new SwiftException("Invalid length: " + length + " in getDataAsInputStream( path=" + path + ", offset=" + offset + ", length =" + length + ")");
        }
        String range = String.format("bytes=%d-%d", offset, offset + length - 1L);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getData:" + range));
        }
        return this.getData(path, new Header[]{new Header("Range", range), NEWEST});
    }

    public long getContentLength(URI uri) throws IOException {
        this.preRemoteCommand("getContentLength");
        return (Long)this.perform("getContentLength", uri, (HttpMethodProcessor)new /* Unavailable Anonymous Inner Class!! */);
    }

    public long getContentLength(SwiftObjectPath path) throws IOException {
        return this.getContentLength(this.pathToURI(path));
    }

    public HttpBodyContent getData(SwiftObjectPath path, Header ... requestHeaders) throws IOException {
        this.preRemoteCommand("getData");
        return this.doGet(this.pathToURI(path), requestHeaders);
    }

    public byte[] getObjectLocation(SwiftObjectPath path, Header ... requestHeaders) throws IOException {
        if (!this.isLocationAware()) {
            return null;
        }
        this.preRemoteCommand("getObjectLocation");
        try {
            return (byte[])this.perform("getObjectLocation", this.pathToObjectLocation(path), (HttpMethodProcessor)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed to get the location of " + path + ": " + e), (Throwable)e);
            return null;
        }
    }

    private URI pathToObjectLocation(SwiftObjectPath path) throws SwiftException {
        URI uri;
        String dataLocationURI = this.objectLocationURI.toString();
        try {
            dataLocationURI = path.toString().startsWith("/") ? dataLocationURI.concat(path.toUriPath()) : dataLocationURI.concat("/").concat(path.toUriPath());
            uri = new URI(dataLocationURI);
        }
        catch (URISyntaxException e) {
            throw new SwiftException((Throwable)e);
        }
        return uri;
    }

    public byte[] findObjectsByPrefix(SwiftObjectPath path, Header ... requestHeaders) throws IOException {
        URI uri;
        this.preRemoteCommand("findObjectsByPrefix");
        String dataLocationURI = this.getEndpointURI().toString();
        try {
            String object = path.getObject();
            if (object.startsWith("/")) {
                object = object.substring(1);
            }
            object = SwiftRestClient.encodeUrl((String)object);
            dataLocationURI = dataLocationURI.concat("/").concat(path.getContainer()).concat("/?prefix=").concat(object);
            uri = new URI(dataLocationURI);
        }
        catch (URISyntaxException e) {
            throw new SwiftException("Bad URI: " + dataLocationURI, (Throwable)e);
        }
        return (byte[])this.perform("findObjectsByPrefix", uri, (HttpMethodProcessor)new /* Unavailable Anonymous Inner Class!! */);
    }

    public byte[] listDeepObjectsInDirectory(SwiftObjectPath path, boolean listDeep, Header ... requestHeaders) throws IOException {
        this.preRemoteCommand("listDeepObjectsInDirectory");
        String endpoint = this.getEndpointURI().toString();
        StringBuilder dataLocationURI = new StringBuilder();
        dataLocationURI.append(endpoint);
        String object = path.getObject();
        if (object.startsWith("/")) {
            object = object.substring(1);
        }
        if (!object.endsWith("/")) {
            object = object.concat("/");
        }
        if (object.equals("/")) {
            object = "";
        }
        dataLocationURI = dataLocationURI.append("/").append(path.getContainer()).append("/?prefix=").append(object).append("&format=json");
        if (!listDeep) {
            dataLocationURI.append("&delimiter=/");
        }
        return this.findObjects(dataLocationURI.toString(), requestHeaders);
    }

    private byte[] findObjects(String location, Header[] requestHeaders) throws IOException {
        URI uri;
        this.preRemoteCommand("findObjects");
        try {
            uri = new URI(location);
        }
        catch (URISyntaxException e) {
            throw new SwiftException("Bad URI: " + location, (Throwable)e);
        }
        return (byte[])this.perform("findObjects", uri, (HttpMethodProcessor)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean copyObject(SwiftObjectPath src, SwiftObjectPath dst, Header ... headers) throws IOException {
        this.preRemoteCommand("copyObject");
        return (Boolean)this.perform("copy", this.pathToURI(src), (HttpMethodProcessor)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(SwiftObjectPath path, InputStream data, long length, Header ... requestHeaders) throws IOException {
        this.preRemoteCommand("upload");
        try {
            this.perform("upload", this.pathToURI(path), (HttpMethodProcessor)new /* Unavailable Anonymous Inner Class!! */);
        }
        finally {
            data.close();
        }
    }

    public boolean delete(SwiftObjectPath path, Header ... requestHeaders) throws IOException {
        this.preRemoteCommand("delete");
        return (Boolean)this.perform("", this.pathToURI(path), (HttpMethodProcessor)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Header[] headRequest(String reason, SwiftObjectPath path, Header ... requestHeaders) throws IOException {
        this.preRemoteCommand("headRequest: " + reason);
        return (Header[])this.perform(reason, this.pathToURI(path), (HttpMethodProcessor)new /* Unavailable Anonymous Inner Class!! */);
    }

    public int putRequest(SwiftObjectPath path, Header ... requestHeaders) throws IOException {
        this.preRemoteCommand("putRequest");
        return (Integer)this.perform(this.pathToURI(path), (HttpMethodProcessor)new /* Unavailable Anonymous Inner Class!! */);
    }

    public AccessToken authenticate() throws IOException {
        AuthenticationRequest authenticationRequest = this.useKeystoneAuthentication ? this.keystoneAuthRequest : this.authRequest;
        LOG.debug((Object)"started authentication");
        return (AccessToken)this.perform("authentication", this.authUri, (HttpMethodProcessor)new AuthenticationPost(this, authenticationRequest, null));
    }

    private StringRequestEntity getAuthenticationRequst(AuthenticationRequest authenticationRequest) throws IOException {
        String data = JSONUtil.toJSON((Object)new AuthenticationRequestWrapper(authenticationRequest));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Authenticating with " + authenticationRequest));
        }
        return SwiftRestClient.toJsonEntity((String)data);
    }

    private synchronized void createDefaultContainer() throws IOException {
        this.createContainer(this.container);
    }

    public void createContainer(String containerName) throws IOException {
        SwiftObjectPath objectPath = new SwiftObjectPath(containerName, "");
        try {
            this.headRequest("createContainer", objectPath, new Header[]{NEWEST});
        }
        catch (FileNotFoundException ex) {
            int status = 0;
            try {
                status = this.putRequest(objectPath, new Header[0]);
            }
            catch (FileNotFoundException e) {
                status = 404;
            }
            if (status == 400) {
                throw new SwiftBadRequestException("Bad request -authentication failure or bad container name?", status, "PUT", null);
            }
            if (!this.isStatusCodeExpected(status, new int[]{200, 201, 202, 204})) {
                throw new SwiftInvalidResponseException("Couldn't create container " + containerName + " for storing data in Swift. Try to create container " + containerName + " manually ", status, "PUT", null);
            }
            throw ex;
        }
    }

    private void authIfNeeded() throws IOException {
        if (this.getEndpointURI() == null) {
            this.authenticate();
        }
    }

    private void preRemoteCommand(String operation) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Executing " + operation));
        }
        this.authIfNeeded();
    }

    private <M extends HttpMethod, R> R perform(URI uri, HttpMethodProcessor<M, R> processor) throws IOException, SwiftBadRequestException, SwiftInternalStateException, SwiftInvalidResponseException, FileNotFoundException {
        return (R)this.perform("", uri, processor);
    }

    private <M extends HttpMethod, R> R perform(String reason, URI uri, HttpMethodProcessor<M, R> processor) throws IOException, SwiftBadRequestException, SwiftInternalStateException, SwiftInvalidResponseException, FileNotFoundException {
        SwiftRestClient.checkNotNull((Object)uri);
        SwiftRestClient.checkNotNull(processor);
        HttpMethod method = processor.createMethod(uri.toString());
        HttpMethodParams methodParams = method.getParams();
        methodParams.setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(this.retryCount, false));
        methodParams.setIntParameter("http.connection.timeout", this.connectTimeout);
        methodParams.setSoTimeout(this.socketTimeout);
        method.addRequestHeader("User-Agent", SwiftProtocolConstants.SWIFT_USER_AGENT);
        Duration duration = new Duration();
        boolean success = false;
        try {
            int statusCode = 0;
            try {
                statusCode = this.exec(method);
            }
            catch (IOException e) {
                throw ExceptionDiags.wrapException((String)uri.toString(), (String)method.getName(), (IOException)e);
            }
            int[] allowedStatusCodes = processor.getAllowedStatusCodes();
            boolean validResponse = this.isStatusCodeExpected(statusCode, allowedStatusCodes);
            if (!validResponse) {
                IOException ioe = this.buildException(uri, method, statusCode);
                throw ioe;
            }
            Object r = processor.extractResult(method);
            success = true;
            Object object = r;
            return (R)object;
        }
        catch (IOException e) {
            method.releaseConnection();
            throw e;
        }
        finally {
            duration.finished();
            this.durationStats.add(method.getName() + " " + reason, duration, success);
        }
    }

    private <M extends HttpMethod> IOException buildException(URI uri, M method, int statusCode) {
        Object fault;
        String errorMessage = String.format("Method %s on %s failed, status code: %d, status line: %s", method.getName(), uri, statusCode, method.getStatusLine());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)errorMessage);
        }
        switch (statusCode) {
            case 404: {
                fault = new FileNotFoundException("Operation " + method.getName() + " on " + uri);
                break;
            }
            case 400: {
                fault = new SwiftBadRequestException("Bad request against " + uri, method.getName(), uri, method);
                break;
            }
            case 416: {
                StringBuilder errorText = new StringBuilder(method.getStatusText());
                Header requestContentLen = method.getRequestHeader("Content-Length");
                if (requestContentLen != null) {
                    errorText.append(" requested ").append(requestContentLen.getValue());
                }
                Header availableContentRange = method.getResponseHeader("Content-Range");
                if (requestContentLen != null) {
                    errorText.append(" available ").append(availableContentRange.getValue());
                }
                fault = new EOFException(errorText.toString());
                break;
            }
            case 401: {
                fault = new SwiftAuthenticationFailedException("Operation not authorized- current access token =" + this.getToken(), method.getName(), uri, method);
                break;
            }
            case 429: 
            case 498: {
                fault = new SwiftThrottledRequestException("Client is being throttled: too many requests", method.getName(), uri, method);
                break;
            }
            default: {
                fault = new SwiftInvalidResponseException(errorMessage, method.getName(), uri, method);
            }
        }
        return fault;
    }

    private HttpBodyContent doGet(URI uri, Header ... requestHeaders) throws IOException {
        return (HttpBodyContent)this.perform("", uri, (HttpMethodProcessor)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static SwiftRestClient getInstance(URI filesystemURI, Configuration config) throws IOException {
        return new SwiftRestClient(filesystemURI, config);
    }

    private static StringRequestEntity toJsonEntity(String data) throws SwiftException {
        StringRequestEntity entity;
        try {
            entity = new StringRequestEntity(data, "application/json", "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SwiftException("Could not encode data as UTF-8", (Throwable)e);
        }
        return entity;
    }

    public static URI pathToURI(SwiftObjectPath path, URI endpointURI) throws SwiftException {
        SwiftRestClient.checkNotNull((Object)endpointURI, (String)"Null Endpoint -client is not authenticated");
        String dataLocationURI = endpointURI.toString();
        try {
            dataLocationURI = SwiftUtils.joinPaths((String)dataLocationURI, (String)SwiftRestClient.encodeUrl((String)path.toUriPath()));
            return new URI(dataLocationURI);
        }
        catch (URISyntaxException e) {
            throw new SwiftException("Failed to create URI from " + dataLocationURI, (Throwable)e);
        }
    }

    private static String encodeUrl(String url) throws SwiftException {
        if (url.matches(".*\\s+.*")) {
            try {
                url = URLEncoder.encode(url, "UTF-8");
                url = url.replace("+", "%20");
            }
            catch (UnsupportedEncodingException e) {
                throw new SwiftException("failed to encode URI", (Throwable)e);
            }
        }
        return url;
    }

    private URI pathToURI(SwiftObjectPath path) throws SwiftException {
        return SwiftRestClient.pathToURI((SwiftObjectPath)path, (URI)this.getEndpointURI());
    }

    private void setHeaders(HttpMethodBase method, Header[] requestHeaders) throws SwiftInternalStateException {
        for (Header header : requestHeaders) {
            method.addRequestHeader(header);
        }
        this.setAuthToken(method, this.getToken());
    }

    private void setAuthToken(HttpMethodBase method, AccessToken accessToken) throws SwiftInternalStateException {
        SwiftRestClient.checkNotNull((Object)accessToken, (String)"Not authenticated");
        method.addRequestHeader("X-Auth-Token", accessToken.getId());
    }

    private <M extends HttpMethod> int exec(M method) throws IOException {
        int statusCode;
        HttpClient client = new HttpClient();
        if (this.proxyHost != null) {
            client.getParams().setParameter("http.route.default-proxy", (Object)new HttpHost(this.proxyHost, this.proxyPort));
        }
        if (((statusCode = this.execWithDebugOutput(method, client)) == 401 || statusCode == 400) && method instanceof AuthPostMethod && !this.useKeystoneAuthentication) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Operation failed with status " + method.getStatusCode() + " attempting keystone auth"));
            }
            this.useKeystoneAuthentication = true;
            AuthPostMethod authentication = (AuthPostMethod)method;
            authentication.setRequestEntity((RequestEntity)this.getAuthenticationRequst(this.keystoneAuthRequest));
            statusCode = this.execWithDebugOutput(method, client);
        }
        if (statusCode == 401) {
            if (method instanceof AuthPostMethod) {
                throw new SwiftAuthenticationFailedException(this.authRequest.toString(), "auth", this.authUri, method);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Reauthenticating");
            }
            this.authenticate();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Retrying original request");
            }
            statusCode = this.execWithDebugOutput(method, client);
        }
        return statusCode;
    }

    private <M extends HttpMethod> int execWithDebugOutput(M method, HttpClient client) throws IOException {
        if (LOG.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder(method.getName() + " " + method.getURI() + "\n");
            for (Header header : method.getRequestHeaders()) {
                builder.append(header.toString());
            }
            LOG.debug((Object)builder);
        }
        int statusCode = client.executeMethod(method);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Status code = " + statusCode));
        }
        return statusCode;
    }

    private static <T> T checkNotNull(T reference) throws SwiftInternalStateException {
        return (T)SwiftRestClient.checkNotNull(reference, (String)"Null Reference");
    }

    private static <T> T checkNotNull(T reference, String message) throws SwiftInternalStateException {
        if (reference == null) {
            throw new SwiftInternalStateException(message);
        }
        return reference;
    }

    private boolean isStatusCodeExpected(int status, int ... expected) {
        for (int code : expected) {
            if (status != code) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "Swift client: " + this.serviceDescription;
    }

    public String getRegion() {
        return this.region;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getUsername() {
        return this.username;
    }

    public String getContainer() {
        return this.container;
    }

    public boolean isLocationAware() {
        return this.locationAware;
    }

    public long getBlocksizeKB() {
        return this.blocksizeKB;
    }

    public int getPartSizeKB() {
        return this.partSizeKB;
    }

    public int getBufferSizeKB() {
        return this.bufferSizeKB;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public boolean isUsePublicURL() {
        return this.usePublicURL;
    }

    public int getThrottleDelay() {
        return this.throttleDelay;
    }

    public List<DurationStats> getOperationStatistics() {
        return this.durationStats.getDurationStatistics();
    }

    static /* synthetic */ void access$400(SwiftRestClient x0, HttpMethodBase x1, Header[] x2) throws SwiftInternalStateException {
        x0.setHeaders(x1, x2);
    }

    static /* synthetic */ StringRequestEntity access$1000(SwiftRestClient x0, AuthenticationRequest x1) throws IOException {
        return x0.getAuthenticationRequst(x1);
    }

    static /* synthetic */ URI access$1100(SwiftRestClient x0) {
        return x0.authUri;
    }

    static /* synthetic */ Log access$1200() {
        return LOG;
    }

    static /* synthetic */ String access$1300(SwiftRestClient x0) {
        return x0.region;
    }

    static /* synthetic */ boolean access$1400(SwiftRestClient x0) {
        return x0.usePublicURL;
    }

    static /* synthetic */ void access$1500(SwiftRestClient x0, URI x1, URI x2, AccessToken x3) {
        x0.setAuthDetails(x1, x2, x3);
    }

    static /* synthetic */ void access$1600(SwiftRestClient x0) throws IOException {
        x0.createDefaultContainer();
    }
}

