/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.swift.http;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.swift.auth.ApiKeyAuthenticationRequest;
import org.apache.hadoop.fs.swift.auth.ApiKeyCredentials;
import org.apache.hadoop.fs.swift.auth.AuthenticationRequest;
import org.apache.hadoop.fs.swift.auth.AuthenticationRequestWrapper;
import org.apache.hadoop.fs.swift.auth.AuthenticationResponse;
import org.apache.hadoop.fs.swift.auth.AuthenticationWrapper;
import org.apache.hadoop.fs.swift.auth.KeyStoneAuthRequest;
import org.apache.hadoop.fs.swift.auth.KeystoneApiKeyCredentials;
import org.apache.hadoop.fs.swift.auth.PasswordAuthenticationRequest;
import org.apache.hadoop.fs.swift.auth.PasswordCredentials;
import org.apache.hadoop.fs.swift.auth.entities.AccessToken;
import org.apache.hadoop.fs.swift.auth.entities.Catalog;
import org.apache.hadoop.fs.swift.auth.entities.Endpoint;
import org.apache.hadoop.fs.swift.exceptions.SwiftAuthenticationFailedException;
import org.apache.hadoop.fs.swift.exceptions.SwiftBadRequestException;
import org.apache.hadoop.fs.swift.exceptions.SwiftConfigurationException;
import org.apache.hadoop.fs.swift.exceptions.SwiftException;
import org.apache.hadoop.fs.swift.exceptions.SwiftInternalStateException;
import org.apache.hadoop.fs.swift.exceptions.SwiftInvalidResponseException;
import org.apache.hadoop.fs.swift.exceptions.SwiftThrottledRequestException;
import org.apache.hadoop.fs.swift.http.CopyRequest;
import org.apache.hadoop.fs.swift.http.ExceptionDiags;
import org.apache.hadoop.fs.swift.http.HttpBodyContent;
import org.apache.hadoop.fs.swift.http.HttpInputStreamWithRelease;
import org.apache.hadoop.fs.swift.http.RestClientBindings;
import org.apache.hadoop.fs.swift.http.SwiftProtocolConstants;
import org.apache.hadoop.fs.swift.util.Duration;
import org.apache.hadoop.fs.swift.util.DurationStats;
import org.apache.hadoop.fs.swift.util.DurationStatsTable;
import org.apache.hadoop.fs.swift.util.HttpResponseUtils;
import org.apache.hadoop.fs.swift.util.JSONUtil;
import org.apache.hadoop.fs.swift.util.SwiftObjectPath;
import org.apache.hadoop.fs.swift.util.SwiftUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SwiftRestClient {
    private static final Logger LOG = LoggerFactory.getLogger(SwiftRestClient.class);
    public static final Header NEWEST = new BasicHeader("X-Newest", "true");
    private final URI authUri;
    private final String region;
    private final String tenant;
    private final String username;
    private final String password;
    private final String apiKey;
    private final AuthenticationRequest authRequest;
    private AuthenticationRequest keystoneAuthRequest;
    private boolean useKeystoneAuthentication = false;
    private final String container;
    private final String serviceDescription;
    private AccessToken token;
    private URI endpointURI;
    private URI objectLocationURI;
    private final String serviceProvider;
    private final boolean usePublicURL;
    private final int retryCount;
    private final int connectTimeout;
    private final int socketTimeout;
    private final int throttleDelay;
    private String proxyHost;
    private int proxyPort;
    private final boolean locationAware;
    private final int partSizeKB;
    private final int blocksizeKB;
    private final int bufferSizeKB;
    private final DurationStatsTable durationStats = new DurationStatsTable();

    private synchronized URI getEndpointURI() {
        return this.endpointURI;
    }

    private synchronized AccessToken getToken() {
        return this.token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAuthDetails(URI endpoint, URI objectLocation, AccessToken authToken) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("setAuth: endpoint=%s; objectURI=%s; token=%s", endpoint, objectLocation, authToken));
        }
        SwiftRestClient swiftRestClient = this;
        synchronized (swiftRestClient) {
            this.endpointURI = endpoint;
            this.objectLocationURI = objectLocation;
            this.token = authToken;
        }
    }

    private SwiftRestClient(URI filesystemURI, Configuration conf) throws SwiftConfigurationException {
        Properties props = RestClientBindings.bind(filesystemURI, conf);
        String stringAuthUri = SwiftRestClient.getOption(props, "fs.swift.auth.url");
        this.username = SwiftRestClient.getOption(props, "fs.swift.username");
        this.password = props.getProperty("fs.swift.password");
        this.apiKey = props.getProperty("fs.swift.apikey");
        this.region = props.getProperty("fs.swift.region");
        this.tenant = props.getProperty("fs.swift.tenant");
        this.serviceProvider = props.getProperty("fs.swift.SERVICE-NAME");
        this.container = props.getProperty("fs.swift.CONTAINER-NAME");
        String isPubProp = props.getProperty("fs.swift.public", "false");
        this.usePublicURL = "true".equals(isPubProp);
        if (this.apiKey == null && this.password == null) {
            throw new SwiftConfigurationException("Configuration for " + filesystemURI + " must contain either " + "fs.swift.password" + " or " + "fs.swift.apikey");
        }
        if (this.password != null) {
            this.authRequest = new PasswordAuthenticationRequest(this.tenant, new PasswordCredentials(this.username, this.password));
        } else {
            this.authRequest = new ApiKeyAuthenticationRequest(this.tenant, new ApiKeyCredentials(this.username, this.apiKey));
            this.keystoneAuthRequest = new KeyStoneAuthRequest(this.tenant, new KeystoneApiKeyCredentials(this.username, this.apiKey));
        }
        this.locationAware = "true".equals(props.getProperty("fs.swift.location-aware", "false"));
        try {
            this.retryCount = conf.getInt("fs.swift.connect.retry.count", 3);
            this.connectTimeout = conf.getInt("fs.swift.connect.timeout", 15000);
            this.socketTimeout = conf.getInt("fs.swift.socket.timeout", 60000);
            this.throttleDelay = conf.getInt("fs.swift.connect.throttle.delay", 0);
            this.proxyHost = conf.get("fs.swift.proxy.host");
            this.proxyPort = conf.getInt("fs.swift.proxy.port", 8080);
            this.blocksizeKB = conf.getInt("fs.swift.blocksize", 32768);
            if (this.blocksizeKB <= 0) {
                throw new SwiftConfigurationException("Invalid blocksize set in fs.swift.blocksize: " + this.blocksizeKB);
            }
            this.partSizeKB = conf.getInt("fs.swift.partsize", 0x480000);
            if (this.partSizeKB <= 0) {
                throw new SwiftConfigurationException("Invalid partition size set in fs.swift.partsize: " + this.partSizeKB);
            }
            this.bufferSizeKB = conf.getInt("fs.swift.requestsize", 64);
            if (this.bufferSizeKB <= 0) {
                throw new SwiftConfigurationException("Invalid buffer size set in fs.swift.requestsize: " + this.bufferSizeKB);
            }
        }
        catch (NumberFormatException e) {
            throw new SwiftConfigurationException(e.toString(), e);
        }
        this.serviceDescription = String.format("Service={%s} container={%s} uri={%s} tenant={%s} user={%s} region={%s} publicURL={%b} location aware={%b} partition size={%d KB}, buffer size={%d KB} block size={%d KB} connect timeout={%d}, retry count={%d} socket timeout={%d} throttle delay={%d}", this.serviceProvider, this.container, stringAuthUri, this.tenant, this.username, this.region != null ? this.region : "(none)", this.usePublicURL, this.locationAware, this.partSizeKB, this.bufferSizeKB, this.blocksizeKB, this.connectTimeout, this.retryCount, this.socketTimeout, this.throttleDelay);
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.serviceDescription);
        }
        try {
            this.authUri = new URI(stringAuthUri);
        }
        catch (URISyntaxException e) {
            throw new SwiftConfigurationException("The fs.swift.auth.url property was incorrect: " + stringAuthUri, e);
        }
    }

    private static String getOption(Properties props, String key) throws SwiftConfigurationException {
        String val = props.getProperty(key);
        if (val == null) {
            throw new SwiftConfigurationException("Undefined property: " + key);
        }
        return val;
    }

    public HttpBodyContent getData(SwiftObjectPath path, long offset, long length) throws IOException {
        if (offset < 0L) {
            throw new SwiftException("Invalid offset: " + offset + " in getDataAsInputStream( path=" + path + ", offset=" + offset + ", length =" + length + ")");
        }
        if (length <= 0L) {
            throw new SwiftException("Invalid length: " + length + " in getDataAsInputStream( path=" + path + ", offset=" + offset + ", length =" + length + ")");
        }
        String range = String.format("bytes=%d-%d", offset, offset + length - 1L);
        if (LOG.isDebugEnabled()) {
            LOG.debug("getData:" + range);
        }
        return this.getData(path, new Header[]{new BasicHeader("Range", range), NEWEST});
    }

    public long getContentLength(URI uri) throws IOException {
        this.preRemoteCommand("getContentLength");
        return this.perform("getContentLength", uri, new HeadRequestProcessor<Long>(){

            @Override
            public Long extractResult(HttpHead req, HttpResponse resp) throws IOException {
                return HttpResponseUtils.getContentLength(resp);
            }

            @Override
            protected void setup(HttpHead req) throws IOException {
                super.setup(req);
                req.addHeader(NEWEST);
            }
        });
    }

    public long getContentLength(SwiftObjectPath path) throws IOException {
        return this.getContentLength(this.pathToURI(path));
    }

    public HttpBodyContent getData(SwiftObjectPath path, Header ... requestHeaders) throws IOException {
        this.preRemoteCommand("getData");
        return this.doGet(this.pathToURI(path), requestHeaders);
    }

    public byte[] getObjectLocation(SwiftObjectPath path, final Header ... requestHeaders) throws IOException {
        if (!this.isLocationAware()) {
            return null;
        }
        this.preRemoteCommand("getObjectLocation");
        try {
            return this.perform("getObjectLocation", this.pathToObjectLocation(path), new GetRequestProcessor<byte[]>(){

                @Override
                protected int[] getAllowedStatusCodes() {
                    return new int[]{200, 403, 204};
                }

                @Override
                public byte[] extractResult(HttpGet req, HttpResponse resp) throws IOException {
                    byte[] locationData;
                    int statusCode = resp.getStatusLine().getStatusCode();
                    if (statusCode == 404 || statusCode == 403 || statusCode == 204 || resp.getEntity().getContent() == null) {
                        return null;
                    }
                    InputStream responseBodyAsStream = resp.getEntity().getContent();
                    return (byte[])(responseBodyAsStream.read(locationData = new byte[1024]) > 0 ? locationData : null);
                }

                @Override
                protected void setup(HttpGet req) throws SwiftInternalStateException {
                    SwiftRestClient.this.setHeaders((HttpUriRequest)req, requestHeaders);
                }
            });
        }
        catch (IOException e) {
            LOG.warn("Failed to get the location of " + path + ": " + e, (Throwable)e);
            return null;
        }
    }

    private URI pathToObjectLocation(SwiftObjectPath path) throws SwiftException {
        URI uri;
        String dataLocationURI = this.objectLocationURI.toString();
        try {
            dataLocationURI = path.toString().startsWith("/") ? dataLocationURI.concat(path.toUriPath()) : dataLocationURI.concat("/").concat(path.toUriPath());
            uri = new URI(dataLocationURI);
        }
        catch (URISyntaxException e) {
            throw new SwiftException(e);
        }
        return uri;
    }

    public byte[] findObjectsByPrefix(SwiftObjectPath path, final Header ... requestHeaders) throws IOException {
        URI uri;
        this.preRemoteCommand("findObjectsByPrefix");
        String dataLocationURI = this.getEndpointURI().toString();
        try {
            String object = path.getObject();
            if (object.startsWith("/")) {
                object = object.substring(1);
            }
            object = SwiftRestClient.encodeUrl(object);
            dataLocationURI = dataLocationURI.concat("/").concat(path.getContainer()).concat("/?prefix=").concat(object);
            uri = new URI(dataLocationURI);
        }
        catch (URISyntaxException e) {
            throw new SwiftException("Bad URI: " + dataLocationURI, e);
        }
        return this.perform("findObjectsByPrefix", uri, new GetRequestProcessor<byte[]>(){

            @Override
            public byte[] extractResult(HttpGet req, HttpResponse resp) throws IOException {
                if (resp.getStatusLine().getStatusCode() == 404) {
                    throw new FileNotFoundException("Not found " + req.getURI());
                }
                return HttpResponseUtils.getResponseBody(resp);
            }

            @Override
            protected int[] getAllowedStatusCodes() {
                return new int[]{200, 404};
            }

            @Override
            protected void setup(HttpGet req) throws SwiftInternalStateException {
                SwiftRestClient.this.setHeaders((HttpUriRequest)req, requestHeaders);
            }
        });
    }

    public byte[] listDeepObjectsInDirectory(SwiftObjectPath path, boolean listDeep, Header ... requestHeaders) throws IOException {
        this.preRemoteCommand("listDeepObjectsInDirectory");
        String endpoint = this.getEndpointURI().toString();
        StringBuilder dataLocationURI = new StringBuilder();
        dataLocationURI.append(endpoint);
        String object = path.getObject();
        if (object.startsWith("/")) {
            object = object.substring(1);
        }
        if (!object.endsWith("/")) {
            object = object.concat("/");
        }
        if (object.equals("/")) {
            object = "";
        }
        dataLocationURI = dataLocationURI.append("/").append(path.getContainer()).append("/?prefix=").append(object).append("&format=json");
        if (!listDeep) {
            dataLocationURI.append("&delimiter=/");
        }
        return this.findObjects(dataLocationURI.toString(), requestHeaders);
    }

    private byte[] findObjects(String location, final Header[] requestHeaders) throws IOException {
        URI uri;
        this.preRemoteCommand("findObjects");
        try {
            uri = new URI(location);
        }
        catch (URISyntaxException e) {
            throw new SwiftException("Bad URI: " + location, e);
        }
        return this.perform("findObjects", uri, new GetRequestProcessor<byte[]>(){

            @Override
            public byte[] extractResult(HttpGet req, HttpResponse resp) throws IOException {
                if (resp.getStatusLine().getStatusCode() == 404) {
                    throw new FileNotFoundException("Not found " + req.getURI());
                }
                return HttpResponseUtils.getResponseBody(resp);
            }

            @Override
            protected int[] getAllowedStatusCodes() {
                return new int[]{200, 404};
            }

            @Override
            protected void setup(HttpGet req) throws SwiftInternalStateException {
                SwiftRestClient.this.setHeaders((HttpUriRequest)req, requestHeaders);
            }
        });
    }

    public boolean copyObject(SwiftObjectPath src, final SwiftObjectPath dst, final Header ... headers) throws IOException {
        this.preRemoteCommand("copyObject");
        return this.perform("copy", this.pathToURI(src), new CopyRequestProcessor<Boolean>(){

            @Override
            public Boolean extractResult(CopyRequest req, HttpResponse resp) throws IOException {
                return resp.getStatusLine().getStatusCode() != 404;
            }

            @Override
            protected void setup(CopyRequest req) throws SwiftInternalStateException {
                SwiftRestClient.this.setHeaders((HttpUriRequest)req, headers);
                req.addHeader("Destination", dst.toUriPath());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(SwiftObjectPath path, final InputStream data, final long length, final Header ... requestHeaders) throws IOException {
        this.preRemoteCommand("upload");
        try {
            this.perform("upload", this.pathToURI(path), new PutRequestProcessor<byte[]>(){

                @Override
                public byte[] extractResult(HttpPut req, HttpResponse resp) throws IOException {
                    return HttpResponseUtils.getResponseBody(resp);
                }

                @Override
                protected void setup(HttpPut req) throws SwiftInternalStateException {
                    req.setEntity((HttpEntity)new InputStreamEntity(data, length));
                    SwiftRestClient.this.setHeaders((HttpUriRequest)req, requestHeaders);
                }
            });
        }
        finally {
            data.close();
        }
    }

    public boolean delete(SwiftObjectPath path, final Header ... requestHeaders) throws IOException {
        this.preRemoteCommand("delete");
        return this.perform("", this.pathToURI(path), new DeleteRequestProcessor<Boolean>(){

            @Override
            public Boolean extractResult(HttpDelete req, HttpResponse resp) throws IOException {
                return resp.getStatusLine().getStatusCode() == 204;
            }

            @Override
            protected void setup(HttpDelete req) throws SwiftInternalStateException {
                SwiftRestClient.this.setHeaders((HttpUriRequest)req, requestHeaders);
            }
        });
    }

    public Header[] headRequest(String reason, SwiftObjectPath path, final Header ... requestHeaders) throws IOException {
        this.preRemoteCommand("headRequest: " + reason);
        return this.perform(reason, this.pathToURI(path), new HeadRequestProcessor<Header[]>(){

            @Override
            public Header[] extractResult(HttpHead req, HttpResponse resp) throws IOException {
                if (resp.getStatusLine().getStatusCode() == 404) {
                    throw new FileNotFoundException("Not Found " + req.getURI());
                }
                return resp.getAllHeaders();
            }

            @Override
            protected void setup(HttpHead req) throws SwiftInternalStateException {
                SwiftRestClient.this.setHeaders((HttpUriRequest)req, requestHeaders);
            }
        });
    }

    public int putRequest(SwiftObjectPath path, final Header ... requestHeaders) throws IOException {
        this.preRemoteCommand("putRequest");
        return this.perform(this.pathToURI(path), new PutRequestProcessor<Integer>(){

            @Override
            public Integer extractResult(HttpPut req, HttpResponse resp) throws IOException {
                return resp.getStatusLine().getStatusCode();
            }

            @Override
            protected void setup(HttpPut req) throws SwiftInternalStateException {
                SwiftRestClient.this.setHeaders((HttpUriRequest)req, requestHeaders);
            }
        });
    }

    public AccessToken authenticate() throws IOException {
        AuthenticationRequest authenticationRequest = this.useKeystoneAuthentication ? this.keystoneAuthRequest : this.authRequest;
        LOG.debug("started authentication");
        return this.perform("authentication", this.authUri, new AuthenticationPost(authenticationRequest));
    }

    private StringEntity getAuthenticationRequst(AuthenticationRequest authenticationRequest) throws IOException {
        String data = JSONUtil.toJSON(new AuthenticationRequestWrapper(authenticationRequest));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Authenticating with " + authenticationRequest);
        }
        return new StringEntity(data, ContentType.create((String)"application/json", (String)"UTF-8"));
    }

    private synchronized void createDefaultContainer() throws IOException {
        this.createContainer(this.container);
    }

    public void createContainer(String containerName) throws IOException {
        SwiftObjectPath objectPath = new SwiftObjectPath(containerName, "");
        try {
            this.headRequest("createContainer", objectPath, NEWEST);
        }
        catch (FileNotFoundException ex) {
            int status = 0;
            try {
                status = this.putRequest(objectPath, new Header[0]);
            }
            catch (FileNotFoundException e) {
                status = 404;
            }
            if (status == 400) {
                throw new SwiftBadRequestException("Bad request -authentication failure or bad container name?", status, "PUT", null);
            }
            if (!this.isStatusCodeExpected(status, 200, 201, 202, 204)) {
                throw new SwiftInvalidResponseException("Couldn't create container " + containerName + " for storing data in Swift. Try to create container " + containerName + " manually ", status, "PUT", null);
            }
            throw ex;
        }
    }

    private void authIfNeeded() throws IOException {
        if (this.getEndpointURI() == null) {
            this.authenticate();
        }
    }

    private void preRemoteCommand(String operation) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Executing " + operation);
        }
        this.authIfNeeded();
    }

    private <M extends HttpRequestBase, R> R perform(URI uri, HttpRequestProcessor<M, R> processor) throws IOException, SwiftBadRequestException, SwiftInternalStateException, SwiftInvalidResponseException, FileNotFoundException {
        return this.perform("", uri, processor);
    }

    private <M extends HttpRequestBase, R> R perform(String reason, URI uri, HttpRequestProcessor<M, R> processor) throws IOException, SwiftBadRequestException, SwiftInternalStateException, SwiftInvalidResponseException, FileNotFoundException {
        SwiftRestClient.checkNotNull(uri);
        SwiftRestClient.checkNotNull(processor);
        HttpRequestBase req = (HttpRequestBase)processor.createRequest(uri.toString());
        req.addHeader("User-Agent", SwiftProtocolConstants.SWIFT_USER_AGENT);
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        clientBuilder.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(this.retryCount, false));
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectTimeout(this.connectTimeout);
        if (this.proxyHost != null) {
            requestConfigBuilder.setProxy(new HttpHost(this.proxyHost, this.proxyPort));
        }
        clientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
        clientBuilder.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(this.socketTimeout).build());
        Duration duration = new Duration();
        boolean success = false;
        try {
            HttpResponse resp;
            CloseableHttpClient client = clientBuilder.build();
            int statusCode = 0;
            try {
                resp = this.exec((HttpClient)client, req);
                statusCode = SwiftRestClient.checkNotNull(resp.getStatusLine().getStatusCode());
            }
            catch (IOException e) {
                throw ExceptionDiags.wrapException(uri.toString(), req.getMethod(), e);
            }
            int[] allowedStatusCodes = processor.getAllowedStatusCodes();
            boolean validResponse = this.isStatusCodeExpected(statusCode, allowedStatusCodes);
            if (!validResponse) {
                IOException ioe = this.buildException(uri, req, resp, statusCode);
                throw ioe;
            }
            R r = processor.extractResult(req, resp);
            success = true;
            R r2 = r;
            return r2;
        }
        catch (IOException e) {
            req.releaseConnection();
            throw e;
        }
        finally {
            duration.finished();
            this.durationStats.add(req.getMethod() + " " + reason, duration, success);
        }
    }

    private <M extends HttpUriRequest> IOException buildException(URI uri, M req, HttpResponse resp, int statusCode) {
        IOException fault;
        String errorMessage = String.format("Method %s on %s failed, status code: %d, status line: %s", req.getMethod(), uri, statusCode, resp.getStatusLine());
        if (LOG.isDebugEnabled()) {
            LOG.debug(errorMessage);
        }
        switch (statusCode) {
            case 404: {
                fault = new FileNotFoundException("Operation " + req.getMethod() + " on " + uri);
                break;
            }
            case 400: {
                fault = new SwiftBadRequestException("Bad request against " + uri, req.getMethod(), uri, resp);
                break;
            }
            case 416: {
                Header availableContentRange;
                StringBuilder errorText = new StringBuilder(resp.getStatusLine().getReasonPhrase());
                Header requestContentLen = req.getFirstHeader("Content-Length");
                if (requestContentLen != null) {
                    errorText.append(" requested ").append(requestContentLen.getValue());
                }
                if ((availableContentRange = resp.getFirstHeader("Content-Range")) != null) {
                    errorText.append(" available ").append(availableContentRange.getValue());
                }
                fault = new EOFException(errorText.toString());
                break;
            }
            case 401: {
                fault = new SwiftAuthenticationFailedException("Operation not authorized- current access token =" + this.getToken(), req.getMethod(), uri, resp);
                break;
            }
            case 429: 
            case 498: {
                fault = new SwiftThrottledRequestException("Client is being throttled: too many requests", req.getMethod(), uri, resp);
                break;
            }
            default: {
                fault = new SwiftInvalidResponseException(errorMessage, req.getMethod(), uri, resp);
            }
        }
        return fault;
    }

    private HttpBodyContent doGet(final URI uri, final Header ... requestHeaders) throws IOException {
        return this.perform("", uri, new GetRequestProcessor<HttpBodyContent>(){

            @Override
            public HttpBodyContent extractResult(HttpGet req, HttpResponse resp) throws IOException {
                return new HttpBodyContent(new HttpInputStreamWithRelease(uri, (HttpRequestBase)req, resp), HttpResponseUtils.getContentLength(resp));
            }

            @Override
            protected void setup(HttpGet req) throws SwiftInternalStateException {
                SwiftRestClient.this.setHeaders((HttpUriRequest)req, requestHeaders);
            }
        });
    }

    public static SwiftRestClient getInstance(URI filesystemURI, Configuration config) throws IOException {
        return new SwiftRestClient(filesystemURI, config);
    }

    public static URI pathToURI(SwiftObjectPath path, URI endpointURI) throws SwiftException {
        SwiftRestClient.checkNotNull(endpointURI, "Null Endpoint -client is not authenticated");
        String dataLocationURI = endpointURI.toString();
        try {
            dataLocationURI = SwiftUtils.joinPaths(dataLocationURI, SwiftRestClient.encodeUrl(path.toUriPath()));
            return new URI(dataLocationURI);
        }
        catch (URISyntaxException e) {
            throw new SwiftException("Failed to create URI from " + dataLocationURI, e);
        }
    }

    private static String encodeUrl(String url) throws SwiftException {
        if (url.matches(".*\\s+.*")) {
            try {
                url = URLEncoder.encode(url, "UTF-8");
                url = url.replace("+", "%20");
            }
            catch (UnsupportedEncodingException e) {
                throw new SwiftException("failed to encode URI", e);
            }
        }
        return url;
    }

    private URI pathToURI(SwiftObjectPath path) throws SwiftException {
        return SwiftRestClient.pathToURI(path, this.getEndpointURI());
    }

    private void setHeaders(HttpUriRequest method, Header[] requestHeaders) throws SwiftInternalStateException {
        for (Header header : requestHeaders) {
            method.addHeader(header);
        }
        this.setAuthToken(method, this.getToken());
    }

    private void setAuthToken(HttpUriRequest method, AccessToken accessToken) throws SwiftInternalStateException {
        SwiftRestClient.checkNotNull(accessToken, "Not authenticated");
        method.addHeader("X-Auth-Token", accessToken.getId());
    }

    private <M extends HttpUriRequest> HttpResponse exec(HttpClient client, M req) throws IOException {
        HttpResponse resp = this.execWithDebugOutput(req, client);
        int statusCode = resp.getStatusLine().getStatusCode();
        if ((statusCode == 401 || statusCode == 400) && req instanceof AuthPostRequest && !this.useKeystoneAuthentication) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Operation failed with status " + statusCode + " attempting keystone auth");
            }
            this.useKeystoneAuthentication = true;
            AuthPostRequest authentication = (AuthPostRequest)req;
            authentication.setEntity((HttpEntity)this.getAuthenticationRequst(this.keystoneAuthRequest));
            resp = this.execWithDebugOutput(req, client);
        }
        if (statusCode == 401) {
            if (req instanceof AuthPostRequest) {
                throw new SwiftAuthenticationFailedException(this.authRequest.toString(), "auth", this.authUri, resp);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reauthenticating");
            }
            this.authenticate();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Retrying original request");
            }
            resp = this.execWithDebugOutput(req, client);
        }
        return resp;
    }

    private <M extends HttpUriRequest> HttpResponse execWithDebugOutput(M req, HttpClient client) throws IOException {
        if (LOG.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder(req.getMethod() + " " + req.getURI() + "\n");
            for (Header header : req.getAllHeaders()) {
                builder.append(header.toString());
            }
            LOG.debug(builder.toString());
        }
        HttpResponse resp = client.execute(req);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Status code = " + resp.getStatusLine().getStatusCode());
        }
        return resp;
    }

    private static <T> T checkNotNull(T reference) throws SwiftInternalStateException {
        return SwiftRestClient.checkNotNull(reference, "Null Reference");
    }

    private static <T> T checkNotNull(T reference, String message) throws SwiftInternalStateException {
        if (reference == null) {
            throw new SwiftInternalStateException(message);
        }
        return reference;
    }

    private boolean isStatusCodeExpected(int status, int ... expected) {
        for (int code : expected) {
            if (status != code) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "Swift client: " + this.serviceDescription;
    }

    public String getRegion() {
        return this.region;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getUsername() {
        return this.username;
    }

    public String getContainer() {
        return this.container;
    }

    public boolean isLocationAware() {
        return this.locationAware;
    }

    public long getBlocksizeKB() {
        return this.blocksizeKB;
    }

    public int getPartSizeKB() {
        return this.partSizeKB;
    }

    public int getBufferSizeKB() {
        return this.bufferSizeKB;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public boolean isUsePublicURL() {
        return this.usePublicURL;
    }

    public int getThrottleDelay() {
        return this.throttleDelay;
    }

    public List<DurationStats> getOperationStatistics() {
        return this.durationStats.getDurationStatistics();
    }

    private final class AuthenticationPost
    extends AuthRequestProcessor<AccessToken> {
        final AuthenticationRequest authenticationRequest;

        private AuthenticationPost(AuthenticationRequest authenticationRequest) {
            this.authenticationRequest = authenticationRequest;
        }

        @Override
        protected void setup(AuthPostRequest req) throws IOException {
            req.setEntity((HttpEntity)SwiftRestClient.this.getAuthenticationRequst(this.authenticationRequest));
        }

        @Override
        protected int[] getAllowedStatusCodes() {
            return new int[]{200, 400, 201, 202, 203, 204, 205, 206, 207, 401};
        }

        @Override
        public AccessToken extractResult(AuthPostRequest req, HttpResponse resp) throws IOException {
            URI objectLocation;
            if (resp.getStatusLine().getStatusCode() == 400) {
                throw new SwiftAuthenticationFailedException(this.authenticationRequest.toString(), "POST", SwiftRestClient.this.authUri, resp);
            }
            AuthenticationResponse access = JSONUtil.toObject(HttpResponseUtils.getResponseBodyAsString(resp), AuthenticationWrapper.class).getAccess();
            List<Catalog> serviceCatalog = access.getServiceCatalog();
            StringBuilder catList = new StringBuilder();
            StringBuilder regionList = new StringBuilder();
            URI endpointURI = null;
            Endpoint swiftEndpoint = null;
            block2: for (Catalog catalog : serviceCatalog) {
                String name = catalog.getName();
                String type = catalog.getType();
                String descr = String.format("[%s: %s]; ", name, type);
                catList.append(descr);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Catalog entry " + descr);
                }
                if (!name.equals("swift") && !name.equals("cloudFiles") && !type.equals("object-store")) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found swift catalog as " + name + " => " + type);
                }
                for (Endpoint endpoint : catalog.getEndpoints()) {
                    String endpointRegion = endpoint.getRegion();
                    URI publicURL = endpoint.getPublicURL();
                    URI internalURL = endpoint.getInternalURL();
                    descr = String.format("[%s => %s / %s]; ", endpointRegion, publicURL, internalURL);
                    regionList.append(descr);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Endpoint " + descr);
                    }
                    if (SwiftRestClient.this.region != null && !endpointRegion.equals(SwiftRestClient.this.region)) continue;
                    endpointURI = SwiftRestClient.this.usePublicURL ? publicURL : internalURL;
                    swiftEndpoint = endpoint;
                    continue block2;
                }
            }
            if (endpointURI == null) {
                String message = "Could not find swift service from auth URL " + SwiftRestClient.this.authUri + " and region '" + SwiftRestClient.this.region + "'. Categories: " + catList + (regionList.length() > 0 ? "regions: " + regionList : "No regions");
                throw new SwiftInvalidResponseException(message, 200, "authenticating", SwiftRestClient.this.authUri);
            }
            AccessToken accessToken = access.getToken();
            String path = "/object_endpoint/" + swiftEndpoint.getTenantId();
            String host = endpointURI.getHost();
            try {
                objectLocation = new URI(endpointURI.getScheme(), null, host, endpointURI.getPort(), path, null, null);
            }
            catch (URISyntaxException e) {
                throw new SwiftException("object endpoint URI is incorrect: " + endpointURI + " + " + path, e);
            }
            SwiftRestClient.this.setAuthDetails(endpointURI, objectLocation, accessToken);
            if (LOG.isDebugEnabled()) {
                LOG.debug("authenticated against " + endpointURI);
            }
            SwiftRestClient.this.createDefaultContainer();
            return accessToken;
        }
    }

    private static abstract class HeadRequestProcessor<R>
    extends HttpRequestProcessor<HttpHead, R> {
        private HeadRequestProcessor() {
        }

        @Override
        protected final HttpHead doCreateRequest(String uri) {
            return new HttpHead(uri);
        }
    }

    private static abstract class DeleteRequestProcessor<R>
    extends HttpRequestProcessor<HttpDelete, R> {
        private DeleteRequestProcessor() {
        }

        @Override
        protected final HttpDelete doCreateRequest(String uri) {
            return new HttpDelete(uri);
        }

        @Override
        protected int[] getAllowedStatusCodes() {
            return new int[]{200, 202, 204, 404};
        }
    }

    private static abstract class CopyRequestProcessor<R>
    extends HttpRequestProcessor<CopyRequest, R> {
        private CopyRequestProcessor() {
        }

        @Override
        protected final CopyRequest doCreateRequest(String uri) throws SwiftException {
            CopyRequest copy = new CopyRequest();
            try {
                copy.setURI(new URI(uri));
            }
            catch (URISyntaxException e) {
                throw new SwiftException("Failed to create URI from: " + uri);
            }
            return copy;
        }

        @Override
        protected int[] getAllowedStatusCodes() {
            return new int[]{201};
        }
    }

    private static abstract class PutRequestProcessor<R>
    extends HttpRequestProcessor<HttpPut, R> {
        private PutRequestProcessor() {
        }

        @Override
        protected final HttpPut doCreateRequest(String uri) {
            return new HttpPut(uri);
        }

        @Override
        protected int[] getAllowedStatusCodes() {
            return new int[]{200, 201, 204, 202};
        }
    }

    private static abstract class AuthRequestProcessor<R>
    extends HttpRequestProcessor<AuthPostRequest, R> {
        private AuthRequestProcessor() {
        }

        @Override
        protected final AuthPostRequest doCreateRequest(String uri) {
            return new AuthPostRequest(uri);
        }
    }

    private static final class AuthPostRequest
    extends HttpPost {
        private AuthPostRequest(String uri) {
            super(uri);
        }
    }

    private static abstract class PostRequestProcessor<R>
    extends HttpRequestProcessor<HttpPost, R> {
        private PostRequestProcessor() {
        }

        @Override
        protected final HttpPost doCreateRequest(String uri) {
            return new HttpPost(uri);
        }
    }

    private static abstract class GetRequestProcessor<R>
    extends HttpRequestProcessor<HttpGet, R> {
        private GetRequestProcessor() {
        }

        @Override
        protected final HttpGet doCreateRequest(String uri) {
            return new HttpGet(uri);
        }
    }

    private static abstract class HttpRequestProcessor<M extends HttpUriRequest, R> {
        private HttpRequestProcessor() {
        }

        public final M createRequest(String uri) throws IOException {
            M req = this.doCreateRequest(uri);
            this.setup(req);
            return req;
        }

        public abstract R extractResult(M var1, HttpResponse var2) throws IOException;

        protected abstract M doCreateRequest(String var1) throws IOException;

        protected void setup(M req) throws IOException {
        }

        protected int[] getAllowedStatusCodes() {
            return new int[]{200, 201, 202, 204, 206};
        }
    }
}

