/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.rumen.PossiblyDecompressedInputStream;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;

class JsonObjectMapperParser<T>
implements Closeable {
    private final ObjectMapper mapper = new ObjectMapper();
    private final Class<? extends T> clazz;
    private final JsonParser jsonParser;

    public JsonObjectMapperParser(Path path, Class<? extends T> clazz, Configuration conf) throws IOException {
        this.mapper.configure(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS, true);
        this.clazz = clazz;
        PossiblyDecompressedInputStream input = new PossiblyDecompressedInputStream(path, conf);
        this.jsonParser = this.mapper.getJsonFactory().createJsonParser((InputStream)input);
    }

    public JsonObjectMapperParser(InputStream input, Class<? extends T> clazz) throws IOException {
        this.mapper.configure(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS, true);
        this.clazz = clazz;
        this.jsonParser = this.mapper.getJsonFactory().createJsonParser(input);
    }

    public T getNext() throws IOException {
        try {
            return (T)this.mapper.readValue(this.jsonParser, this.clazz);
        }
        catch (EOFException e) {
            return null;
        }
    }

    @Override
    public void close() throws IOException {
        this.jsonParser.close();
    }
}

