/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen.anonymization;

import org.apache.commons.lang.StringUtils;

public class WordListAnonymizerUtility {
    static final String[] KNOWN_WORDS = new String[]{"job", "tmp", "temp", "home", "homes", "usr", "user", "test"};

    public static boolean needsAnonymization(String data) {
        return !StringUtils.isNumeric((String)data);
    }

    public static boolean hasSuffix(String data, String[] suffixes) {
        for (String ks : suffixes) {
            if (!data.endsWith(ks)) continue;
            return true;
        }
        return false;
    }

    public static String[] extractSuffix(String data, String[] suffixes) {
        String suffix = "";
        for (String ks : suffixes) {
            if (!data.endsWith(ks)) continue;
            suffix = ks;
            data = data.substring(0, data.length() - suffix.length());
            return new String[]{data, suffix};
        }
        throw new RuntimeException("Data [" + data + "] doesn't have a suffix from known suffixes [" + StringUtils.join((Object[])suffixes, (char)',') + "]");
    }

    public static boolean isKnownData(String data) {
        return WordListAnonymizerUtility.isKnownData(data, KNOWN_WORDS);
    }

    public static boolean isKnownData(String data, String[] knownWords) {
        for (String kd : knownWords) {
            if (!data.equals(kd)) continue;
            return true;
        }
        return false;
    }
}

