/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.rumen.InputDemuxer;
import org.apache.hadoop.tools.rumen.Pair;
import org.apache.hadoop.tools.rumen.PossiblyDecompressedInputStream;

public class DefaultInputDemuxer
implements InputDemuxer {
    String name;
    InputStream input;

    public void bindTo(Path path, Configuration conf) throws IOException {
        if (this.name != null) {
            this.close();
        }
        this.name = path.getName();
        this.input = new PossiblyDecompressedInputStream(path, conf);
    }

    public Pair<String, InputStream> getNext() throws IOException {
        if (this.name != null) {
            Pair ret = new Pair((Object)this.name, (Object)this.input);
            this.name = null;
            this.input = null;
            return ret;
        }
        return null;
    }

    public void close() throws IOException {
        try {
            if (this.input != null) {
                this.input.close();
            }
        }
        finally {
            this.name = null;
            this.input = null;
        }
    }
}

