/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.tools.rumen.JsonObjectMapperWriter;
import org.apache.hadoop.tools.rumen.Outputter;

public class DefaultOutputter<T>
implements Outputter<T> {
    JsonObjectMapperWriter<T> writer;
    Compressor compressor;

    public void init(Path path, Configuration conf) throws IOException {
        FSDataOutputStream output;
        FileSystem fs = path.getFileSystem(conf);
        CompressionCodec codec = new CompressionCodecFactory(conf).getCodec(path);
        if (codec != null) {
            this.compressor = CodecPool.getCompressor((CompressionCodec)codec);
            output = codec.createOutputStream((OutputStream)fs.create(path), this.compressor);
        } else {
            output = fs.create(path);
        }
        this.writer = new JsonObjectMapperWriter((OutputStream)output, conf.getBoolean("rumen.output.pretty.print", true));
    }

    public void output(T object) throws IOException {
        this.writer.write(object);
    }

    public void close() throws IOException {
        try {
            this.writer.close();
        }
        finally {
            if (this.compressor != null) {
                CodecPool.returnCompressor((Compressor)this.compressor);
            }
        }
    }
}

