/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.tools.rumen.DeskewedJobTraceReader;
import org.apache.hadoop.tools.rumen.JobTraceReader;
import org.apache.hadoop.tools.rumen.LoggedJob;

public class DeskewedJobTraceReader
implements Closeable {
    private final JobTraceReader reader;
    private final int skewBufferLength;
    private final boolean abortOnUnfixableSkew;
    private long skewMeasurementLatestSubmitTime = Long.MIN_VALUE;
    private long returnedLatestSubmitTime = Long.MIN_VALUE;
    private int maxSkewBufferNeeded = 0;
    private TreeMap<Long, Integer> countedRepeatedSubmitTimesSoFar = new TreeMap();
    private TreeSet<Long> submitTimesSoFar = new TreeSet();
    private final PriorityQueue<LoggedJob> skewBuffer;
    private static final Log LOG = LogFactory.getLog(DeskewedJobTraceReader.class);

    public DeskewedJobTraceReader(JobTraceReader reader, int skewBufferLength, boolean abortOnUnfixableSkew) throws IOException {
        this.reader = reader;
        this.skewBufferLength = skewBufferLength;
        this.abortOnUnfixableSkew = abortOnUnfixableSkew;
        this.skewBuffer = new PriorityQueue(skewBufferLength + 1, new JobComparator(null));
        this.fillSkewBuffer();
    }

    public DeskewedJobTraceReader(JobTraceReader reader) throws IOException {
        this(reader, 0, true);
    }

    private LoggedJob rawNextJob() throws IOException {
        LoggedJob result = (LoggedJob)this.reader.getNext();
        if (!(this.abortOnUnfixableSkew && this.skewBufferLength <= 0 || result == null)) {
            long thisTime = result.getSubmitTime();
            if (this.submitTimesSoFar.contains(thisTime)) {
                Integer myCount = (Integer)this.countedRepeatedSubmitTimesSoFar.get(thisTime);
                this.countedRepeatedSubmitTimesSoFar.put(thisTime, myCount == null ? 2 : myCount + 1);
            } else {
                this.submitTimesSoFar.add(thisTime);
            }
            if (thisTime < this.skewMeasurementLatestSubmitTime) {
                Long keyNeedingSkew;
                Iterator endCursor = this.submitTimesSoFar.descendingIterator();
                int thisJobNeedsSkew = 0;
                while (endCursor.hasNext() && (keyNeedingSkew = (Long)endCursor.next()) > thisTime) {
                    Integer keyNeedsSkewAmount = (Integer)this.countedRepeatedSubmitTimesSoFar.get(keyNeedingSkew);
                    thisJobNeedsSkew += keyNeedsSkewAmount == null ? 1 : keyNeedsSkewAmount;
                }
                this.maxSkewBufferNeeded = Math.max(this.maxSkewBufferNeeded, thisJobNeedsSkew);
            }
            this.skewMeasurementLatestSubmitTime = Math.max(thisTime, this.skewMeasurementLatestSubmitTime);
        }
        return result;
    }

    LoggedJob nextJob() throws IOException, OutOfOrderException {
        LoggedJob newJob = this.rawNextJob();
        if (newJob != null) {
            this.skewBuffer.add(newJob);
        }
        LoggedJob result = (LoggedJob)this.skewBuffer.poll();
        while (result != null && result.getSubmitTime() < this.returnedLatestSubmitTime) {
            LOG.error((Object)"The current job was submitted earlier than the previous one");
            LOG.error((Object)("Its jobID is " + result.getJobID()));
            LOG.error((Object)("Its submit time is " + result.getSubmitTime() + ",but the previous one was " + this.returnedLatestSubmitTime));
            if (this.abortOnUnfixableSkew) {
                throw new OutOfOrderException("Job submit time is " + result.getSubmitTime() + ",but the previous one was " + this.returnedLatestSubmitTime);
            }
            result = this.rawNextJob();
        }
        if (result != null) {
            this.returnedLatestSubmitTime = result.getSubmitTime();
        }
        return result;
    }

    private void fillSkewBuffer() throws IOException {
        for (int i = 0; i < this.skewBufferLength; ++i) {
            LoggedJob newJob = this.rawNextJob();
            if (newJob == null) {
                return;
            }
            this.skewBuffer.add(newJob);
        }
    }

    int neededSkewBufferSize() {
        return this.maxSkewBufferNeeded;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

