/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.rumen.PossiblyDecompressedInputStream;

class JsonObjectMapperParser<T>
implements Closeable {
    private final ObjectMapper mapper = new ObjectMapper();
    private final Class<? extends T> clazz;
    private final JsonParser jsonParser;

    public JsonObjectMapperParser(Path path, Class<? extends T> clazz, Configuration conf) throws IOException {
        this.clazz = clazz;
        PossiblyDecompressedInputStream input = new PossiblyDecompressedInputStream(path, conf);
        this.jsonParser = this.mapper.getFactory().createParser((InputStream)input);
    }

    public JsonObjectMapperParser(InputStream input, Class<? extends T> clazz) throws IOException {
        this.clazz = clazz;
        this.jsonParser = this.mapper.getFactory().createParser(input);
    }

    public T getNext() throws IOException {
        try {
            return (T)this.mapper.readValue(this.jsonParser, this.clazz);
        }
        catch (JsonMappingException e) {
            return null;
        }
    }

    @Override
    public void close() throws IOException {
        this.jsonParser.close();
    }
}

