/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.streaming.AutoInputFormat;
import org.junit.Assert;
import org.junit.Test;

public class TestAutoInputFormat {
    private static Configuration conf = new Configuration();
    private static final int LINES_COUNT = 3;
    private static final int RECORDS_COUNT = 3;
    private static final int SPLITS_COUNT = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFormat() throws IOException {
        InputSplit[] splits;
        JobConf job = new JobConf(conf);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path dir = new Path(System.getProperty("test.build.data", ".") + "/mapred");
        Path txtFile = new Path(dir, "auto.txt");
        Path seqFile = new Path(dir, "auto.seq");
        fs.delete(dir, true);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{dir});
        try (OutputStreamWriter txtWriter = new OutputStreamWriter((OutputStream)fs.create(txtFile));){
            for (int i = 0; i < 3; ++i) {
                txtWriter.write("" + 10 * i);
                txtWriter.write("\n");
            }
        }
        try (SequenceFile.Writer seqWriter = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)seqFile, IntWritable.class, LongWritable.class);){
            for (int i = 0; i < 3; ++i) {
                IntWritable key = new IntWritable(11 * i);
                LongWritable value = new LongWritable((long)(12 * i));
                seqWriter.append((Writable)key, (Writable)value);
            }
        }
        AutoInputFormat format = new AutoInputFormat();
        for (InputSplit split : splits = format.getSplits(job, 2)) {
            RecordReader reader = format.getRecordReader(split, job, Reporter.NULL);
            Object key = reader.createKey();
            Object value = reader.createValue();
            try {
                while (reader.next(key, value)) {
                    if (key instanceof LongWritable) {
                        Assert.assertEquals((String)"Wrong value class.", Text.class, value.getClass());
                        Assert.assertTrue((String)"Invalid value", (Integer.parseInt(((Text)value).toString()) % 10 == 0 ? 1 : 0) != 0);
                        continue;
                    }
                    Assert.assertEquals((String)"Wrong key class.", IntWritable.class, key.getClass());
                    Assert.assertEquals((String)"Wrong value class.", LongWritable.class, value.getClass());
                    Assert.assertTrue((String)"Invalid key.", (((IntWritable)key).get() % 11 == 0 ? 1 : 0) != 0);
                    Assert.assertTrue((String)"Invalid value.", (((LongWritable)value).get() % 12L == 0L ? 1 : 0) != 0);
                }
            }
            finally {
                reader.close();
            }
        }
    }
}

