/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.mapred.lib.KeyFieldBasedPartitioner;
import org.apache.hadoop.streaming.StreamJob;
import org.apache.hadoop.streaming.StreamUtil;
import org.apache.hadoop.streaming.TrApp;
import org.apache.hadoop.streaming.UtilTest;
import org.junit.Assert;
import org.junit.Test;

public class TestStreamDataProtocol {
    protected File INPUT_FILE = new File("input_for_data_protocol_test.txt");
    protected File OUTPUT_DIR = new File("out_for_data_protocol_test");
    protected String input = "roses.smell.good\nroses.look.good\nroses.need.care\nroses.attract.bees\nroses.are.red\nroses.are.not.blue\nbunnies.are.pink\nbunnies.run.fast\nbunnies.have.short.tail\nbunnies.have.long.ears\n";
    protected String map = UtilTest.makeJavaCommand(TrApp.class, (String[])new String[]{".", "."});
    protected String reduce = "org.apache.hadoop.streaming.ValueCountReduce";
    protected String outputExpect = "bunnies.are\t1\nbunnies.have\t2\nbunnies.run\t1\nroses.are\t2\nroses.attract\t1\nroses.look\t1\nroses.need\t1\nroses.smell\t1\n";
    private StreamJob job;

    public TestStreamDataProtocol() throws IOException {
        UtilTest utilTest = new UtilTest(this.getClass().getName());
        utilTest.checkUserDir();
        utilTest.redirectIfAntJunit();
    }

    protected void createInput() throws IOException {
        DataOutputStream out = new DataOutputStream(new FileOutputStream(this.INPUT_FILE.getAbsoluteFile()));
        out.write(this.input.getBytes("UTF-8"));
        out.close();
    }

    protected String[] genArgs() {
        return new String[]{"-input", this.INPUT_FILE.getAbsolutePath(), "-output", this.OUTPUT_DIR.getAbsolutePath(), "-mapper", this.map, "-reducer", this.reduce, "-partitioner", KeyFieldBasedPartitioner.class.getCanonicalName(), "-jobconf", "stream.map.output.field.separator=.", "-jobconf", "stream.num.map.output.key.fields=2", "-jobconf", "mapreduce.map.output.key.field.separator=.", "-jobconf", "num.key.fields.for.partition=1", "-jobconf", "mapreduce.job.reduces=2", "-jobconf", "mapreduce.task.files.preserve.failedtasks=true", "-jobconf", "stream.tmpdir=" + System.getProperty("test.build.data", "/tmp")};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCommandLine() throws Exception {
        try {
            FileUtil.fullyDelete((File)this.OUTPUT_DIR.getAbsoluteFile());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.createInput();
            boolean mayExit = false;
            this.job = new StreamJob(this.genArgs(), mayExit);
            this.job.go();
            File outFile = new File(this.OUTPUT_DIR, "part-00000").getAbsoluteFile();
            String output = StreamUtil.slurp((File)outFile);
            outFile.delete();
            System.err.println("outEx1=" + this.outputExpect);
            System.err.println("  out1=" + output);
            System.err.println("  equals=" + this.outputExpect.compareTo(output));
            Assert.assertEquals((Object)this.outputExpect, (Object)output);
        }
        finally {
            this.INPUT_FILE.delete();
            FileUtil.fullyDelete((File)this.OUTPUT_DIR.getAbsoluteFile());
        }
    }

    public static void main(String[] args) throws Exception {
        new TestStreamDataProtocol().testCommandLine();
    }
}

