/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming.io;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.streaming.PipeMapRed;
import org.apache.hadoop.streaming.io.OutputReader;

public class RawBytesOutputReader
extends OutputReader<BytesWritable, BytesWritable> {
    private DataInput clientIn;
    private byte[] bytes;
    private BytesWritable key;
    private BytesWritable value;

    public void initialize(PipeMapRed pipeMapRed) throws IOException {
        super.initialize(pipeMapRed);
        this.clientIn = pipeMapRed.getClientInput();
        this.key = new BytesWritable();
        this.value = new BytesWritable();
    }

    public boolean readKeyValue() throws IOException {
        int length = this.readLength();
        if (length < 0) {
            return false;
        }
        this.key.set(this.readBytes(length), 0, length);
        length = this.readLength();
        this.value.set(this.readBytes(length), 0, length);
        return true;
    }

    public BytesWritable getCurrentKey() throws IOException {
        return this.key;
    }

    public BytesWritable getCurrentValue() throws IOException {
        return this.value;
    }

    public String getLastOutput() {
        if (this.bytes != null) {
            return new BytesWritable(this.bytes).toString();
        }
        return null;
    }

    private int readLength() throws IOException {
        try {
            return this.clientIn.readInt();
        }
        catch (EOFException eof) {
            return -1;
        }
    }

    private byte[] readBytes(int length) throws IOException {
        this.bytes = new byte[length];
        this.clientIn.readFully(this.bytes);
        return this.bytes;
    }
}

