/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.ClusterMapReduceTestCase;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.Utils;
import org.apache.hadoop.streaming.TestStreamingBadRecords;
import org.apache.hadoop.streaming.UtilTest;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestStreamingBadRecords
extends ClusterMapReduceTestCase {
    private static final Log LOG = LogFactory.getLog(TestStreamingBadRecords.class);
    private static final List<String> MAPPER_BAD_RECORDS = Arrays.asList("hey022", "hey023", "hey099");
    private static final List<String> REDUCER_BAD_RECORDS = Arrays.asList("hey001", "hey018");
    private static final String badMapper = UtilTest.makeJavaCommand(BadApp.class, (String[])new String[0]);
    private static final String badReducer = UtilTest.makeJavaCommand(BadApp.class, (String[])new String[]{"true"});
    private static final int INPUTSIZE = 100;

    public TestStreamingBadRecords() throws IOException {
        UtilTest utilTest = new UtilTest(this.getClass().getName());
        utilTest.checkUserDir();
        utilTest.redirectIfAntJunit();
    }

    protected void setUp() throws Exception {
        Properties props = new Properties();
        props.setProperty("mapreduce.jobtracker.retirejobs", "false");
        props.setProperty("mapreduce.jobtracker.persist.jobstatus.active", "false");
        this.startCluster(true, props);
    }

    private void createInput() throws Exception {
        FSDataOutputStream os = this.getFileSystem().create(new Path(this.getInputDir(), "text.txt"));
        OutputStreamWriter wr = new OutputStreamWriter((OutputStream)os);
        String prefix = new String(new byte[20480]);
        for (int i = 1; i <= 100; ++i) {
            String str = "" + i;
            int zerosToPrepend = 3 - str.length();
            for (int j = 0; j < zerosToPrepend; ++j) {
                str = "0" + str;
            }
            wr.write(prefix + "hey" + str + "\n");
        }
        ((Writer)wr).close();
    }

    private void validateOutput(RunningJob runningJob, boolean validateCount) throws Exception {
        LOG.info((Object)runningJob.getCounters().toString());
        TestStreamingBadRecords.assertTrue((boolean)runningJob.isSuccessful());
        if (validateCount) {
            String counterGrp = "org.apache.hadoop.mapred.Task$Counter";
            Counters counters = runningJob.getCounters();
            TestStreamingBadRecords.assertEquals((long)counters.findCounter(counterGrp, "MAP_SKIPPED_RECORDS").getCounter(), (long)MAPPER_BAD_RECORDS.size());
            int mapRecs = 100 - MAPPER_BAD_RECORDS.size();
            TestStreamingBadRecords.assertEquals((long)counters.findCounter(counterGrp, "MAP_INPUT_RECORDS").getCounter(), (long)mapRecs);
            TestStreamingBadRecords.assertEquals((long)counters.findCounter(counterGrp, "MAP_OUTPUT_RECORDS").getCounter(), (long)mapRecs);
            int redRecs = mapRecs - REDUCER_BAD_RECORDS.size();
            TestStreamingBadRecords.assertEquals((long)counters.findCounter(counterGrp, "REDUCE_SKIPPED_RECORDS").getCounter(), (long)REDUCER_BAD_RECORDS.size());
            TestStreamingBadRecords.assertEquals((long)counters.findCounter(counterGrp, "REDUCE_SKIPPED_GROUPS").getCounter(), (long)REDUCER_BAD_RECORDS.size());
            TestStreamingBadRecords.assertEquals((long)counters.findCounter(counterGrp, "REDUCE_INPUT_GROUPS").getCounter(), (long)redRecs);
            TestStreamingBadRecords.assertEquals((long)counters.findCounter(counterGrp, "REDUCE_INPUT_RECORDS").getCounter(), (long)redRecs);
            TestStreamingBadRecords.assertEquals((long)counters.findCounter(counterGrp, "REDUCE_OUTPUT_RECORDS").getCounter(), (long)redRecs);
        }
        ArrayList badRecs = new ArrayList();
        badRecs.addAll(MAPPER_BAD_RECORDS);
        badRecs.addAll(REDUCER_BAD_RECORDS);
        Path[] outputFiles = FileUtil.stat2Paths((FileStatus[])this.getFileSystem().listStatus(this.getOutputDir(), (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter()));
        if (outputFiles.length > 0) {
            FSDataInputStream is = this.getFileSystem().open(outputFiles[0]);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is));
            String line = reader.readLine();
            int counter = 0;
            while (line != null) {
                ++counter;
                StringTokenizer tokeniz = new StringTokenizer(line, "\t");
                String value = tokeniz.nextToken();
                int index = value.indexOf("hey");
                TestStreamingBadRecords.assertTrue((index > -1 ? 1 : 0) != 0);
                if (index > -1) {
                    String heyStr = value.substring(index);
                    TestStreamingBadRecords.assertTrue((!badRecs.contains(heyStr) ? 1 : 0) != 0);
                }
                line = reader.readLine();
            }
            reader.close();
            if (validateCount) {
                TestStreamingBadRecords.assertEquals((int)(100 - badRecs.size()), (int)counter);
            }
        }
    }

    public void testNoOp() {
    }

    static /* synthetic */ List access$000() {
        return MAPPER_BAD_RECORDS;
    }

    static /* synthetic */ List access$100() {
        return REDUCER_BAD_RECORDS;
    }

    static /* synthetic */ Log access$200() {
        return LOG;
    }
}

