/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SkipBadRecords;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.streaming.PipeMapRed;
import org.apache.hadoop.streaming.io.InputWriter;
import org.apache.hadoop.streaming.io.OutputReader;
import org.apache.hadoop.streaming.io.TextInputWriter;

public class PipeMapper
extends PipeMapRed
implements Mapper {
    private boolean ignoreKey = false;
    private boolean skipping = false;
    private byte[] mapOutputFieldSeparator;
    private byte[] mapInputFieldSeparator;
    private int numOfMapOutputKeyFields = 1;

    @Override
    String getPipeCommand(JobConf job) {
        String str = job.get("stream.map.streamprocessor");
        if (str == null) {
            return str;
        }
        try {
            return URLDecoder.decode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("stream.map.streamprocessor in jobconf not found");
            return null;
        }
    }

    @Override
    boolean getDoPipe() {
        return true;
    }

    @Override
    public void configure(JobConf job) {
        super.configure(job);
        SkipBadRecords.setAutoIncrMapperProcCount((Configuration)job, (boolean)false);
        this.skipping = job.getBoolean("mapreduce.job.skiprecords", false);
        if (this.mapInputWriterClass_.getCanonicalName().equals(TextInputWriter.class.getCanonicalName())) {
            String inputFormatClassName = job.getClass("mapred.input.format.class", TextInputFormat.class).getCanonicalName();
            this.ignoreKey = job.getBoolean("stream.map.input.ignoreKey", inputFormatClassName.equals(TextInputFormat.class.getCanonicalName()));
        }
        try {
            this.mapOutputFieldSeparator = job.get("stream.map.output.field.separator", "\t").getBytes("UTF-8");
            this.mapInputFieldSeparator = job.get("stream.map.input.field.separator", "\t").getBytes("UTF-8");
            this.numOfMapOutputKeyFields = job.getInt("stream.num.map.output.key.fields", 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("The current system does not support UTF-8 encoding!", e);
        }
    }

    public void map(Object key, Object value, OutputCollector output, Reporter reporter) throws IOException {
        block7: {
            if (this.outerrThreadsThrowable != null) {
                this.mapRedFinished();
                throw new IOException("MROutput/MRErrThread failed:", this.outerrThreadsThrowable);
            }
            try {
                ++this.numRecRead_;
                this.maybeLogRecord();
                if (this.numExceptions_ == 0) {
                    if (!this.ignoreKey) {
                        this.inWriter_.writeKey(key);
                    }
                    this.inWriter_.writeValue(value);
                    if (this.skipping) {
                        this.clientOut_.flush();
                    }
                } else {
                    ++this.numRecSkipped_;
                }
            }
            catch (IOException io) {
                ++this.numExceptions_;
                if (this.numExceptions_ <= 1 && this.numRecWritten_ >= this.minRecWrittenToEnableSkip_) break block7;
                LOG.info(this.getContext(), (Throwable)io);
                this.mapRedFinished();
                throw io;
            }
        }
    }

    public void close() {
        this.mapRedFinished();
    }

    @Override
    public byte[] getInputSeparator() {
        return this.mapInputFieldSeparator;
    }

    @Override
    public byte[] getFieldSeparator() {
        return this.mapOutputFieldSeparator;
    }

    @Override
    public int getNumOfKeyFields() {
        return this.numOfMapOutputKeyFields;
    }

    @Override
    InputWriter createInputWriter() throws IOException {
        return super.createInputWriter(this.mapInputWriterClass_);
    }

    @Override
    OutputReader createOutputReader() throws IOException {
        return super.createOutputReader(this.mapOutputReaderClass_);
    }
}

