/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.timelineservice;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetricOperation;
import org.junit.Assert;
import org.junit.Test;

public class TestTimelineMetric {
    @Test
    public void testTimelineMetricAggregation() {
        long ts = System.currentTimeMillis();
        TimelineMetric m1 = TestTimelineMetric.getSingleValueMetric("MEGA_BYTES_MILLIS", TimelineMetricOperation.SUM, ts, 10000L);
        TimelineMetric aggregatedMetric = TimelineMetric.aggregateTo((TimelineMetric)m1, null);
        Assert.assertEquals((Object)10000L, (Object)aggregatedMetric.getSingleDataValue());
        TimelineMetric m2 = TestTimelineMetric.getSingleValueMetric("MEGA_BYTES_MILLIS", TimelineMetricOperation.SUM, ts, 20000L);
        aggregatedMetric = TimelineMetric.aggregateTo((TimelineMetric)m2, (TimelineMetric)aggregatedMetric);
        Assert.assertEquals((Object)30000L, (Object)aggregatedMetric.getSingleDataValue());
        HashMap<String, TimelineMetric> state = new HashMap<String, TimelineMetric>();
        state.put("PREV_METRIC", m2);
        TimelineMetric m2New = TestTimelineMetric.getSingleValueMetric("MEGA_BYTES_MILLIS", TimelineMetricOperation.SUM, ts, 10000L);
        aggregatedMetric = TimelineMetric.aggregateTo((TimelineMetric)m2New, (TimelineMetric)aggregatedMetric, state);
        Assert.assertEquals((Object)20000L, (Object)aggregatedMetric.getSingleDataValue());
        TimelineMetric m3 = TestTimelineMetric.getSingleValueMetric("TRANSFER_RATE", TimelineMetricOperation.MAX, ts, 150L);
        TimelineMetric aggregatedMax = TimelineMetric.aggregateTo((TimelineMetric)m3, null);
        Assert.assertEquals((Object)150L, (Object)aggregatedMax.getSingleDataValue());
        TimelineMetric m4 = TestTimelineMetric.getSingleValueMetric("TRANSFER_RATE", TimelineMetricOperation.MAX, ts, 170L);
        aggregatedMax = TimelineMetric.aggregateTo((TimelineMetric)m4, (TimelineMetric)aggregatedMax);
        Assert.assertEquals((Object)170L, (Object)aggregatedMax.getSingleDataValue());
        TimelineMetric m5 = TestTimelineMetric.getSingleValueMetric("TRANSFER_RATE", TimelineMetricOperation.AVG, ts, 150L);
        try {
            TimelineMetric.aggregateTo((TimelineMetric)m5, null);
            Assert.fail((String)"Taking average among metrics is not supported! ");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private static TimelineMetric getSingleValueMetric(String id, TimelineMetricOperation op, long timestamp, long value) {
        TimelineMetric m = new TimelineMetric();
        m.setId(id);
        m.setType(TimelineMetric.Type.SINGLE_VALUE);
        m.setRealtimeAggregationOp(op);
        HashMap<Long, Long> metricValues = new HashMap<Long, Long>();
        metricValues.put(timestamp, value);
        m.setValues(metricValues);
        return m;
    }

    private static TimelineMetric getTimeSeriesMetric(String id, TimelineMetricOperation op, Map<Long, Number> metricValues) {
        TimelineMetric m = new TimelineMetric();
        m.setId(id);
        m.setType(TimelineMetric.Type.TIME_SERIES);
        m.setRealtimeAggregationOp(op);
        m.setValues(metricValues);
        return m;
    }
}

