/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import org.apache.hadoop.yarn.util.UnitsConversionUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestUnitsConversionUtil {
    @Test
    public void testUnitsConversion() {
        int value = 5;
        String fromUnit = "";
        long test = value;
        Assert.assertEquals((String)"pico test failed", (long)((long)value * 1000L * 1000L * 1000L * 1000L), (long)UnitsConversionUtil.convert((String)fromUnit, (String)"p", (long)test));
        Assert.assertEquals((String)"nano test failed", (long)((long)value * 1000L * 1000L * 1000L), (long)UnitsConversionUtil.convert((String)fromUnit, (String)"n", (long)test));
        Assert.assertEquals((String)"micro test failed", (long)((long)value * 1000L * 1000L), (long)UnitsConversionUtil.convert((String)fromUnit, (String)"u", (long)test));
        Assert.assertEquals((String)"milli test failed", (long)((long)value * 1000L), (long)UnitsConversionUtil.convert((String)fromUnit, (String)"m", (long)test));
        test = (long)value * 1000L * 1000L * 1000L * 1000L * 1000L;
        fromUnit = "";
        Assert.assertEquals((String)"kilo test failed", (long)(test / 1000L), (long)UnitsConversionUtil.convert((String)fromUnit, (String)"k", (long)test));
        Assert.assertEquals((String)"mega test failed", (long)(test / 1000000L), (long)UnitsConversionUtil.convert((String)fromUnit, (String)"M", (long)test));
        Assert.assertEquals((String)"giga test failed", (long)(test / 1000000000L), (long)UnitsConversionUtil.convert((String)fromUnit, (String)"G", (long)test));
        Assert.assertEquals((String)"tera test failed", (long)(test / 1000000000000L), (long)UnitsConversionUtil.convert((String)fromUnit, (String)"T", (long)test));
        Assert.assertEquals((String)"peta test failed", (long)(test / 1000000000000000L), (long)UnitsConversionUtil.convert((String)fromUnit, (String)"P", (long)test));
        Assert.assertEquals((String)"nano to pico test failed", (long)((long)value * 1000L), (long)UnitsConversionUtil.convert((String)"n", (String)"p", (long)value));
        Assert.assertEquals((String)"mega to giga test failed", (long)value, (long)UnitsConversionUtil.convert((String)"M", (String)"G", (long)((long)value * 1000L)));
        Assert.assertEquals((String)"Mi to Gi test failed", (long)value, (long)UnitsConversionUtil.convert((String)"Mi", (String)"Gi", (long)((long)value * 1024L)));
        Assert.assertEquals((String)"Mi to Ki test failed", (long)(value * 1024), (long)UnitsConversionUtil.convert((String)"Mi", (String)"Ki", (long)value));
        Assert.assertEquals((String)"Ki to base units test failed", (long)5120L, (long)UnitsConversionUtil.convert((String)"Ki", (String)"", (long)5L));
        Assert.assertEquals((String)"Mi to k test failed", (long)1073741L, (long)UnitsConversionUtil.convert((String)"Mi", (String)"k", (long)1024L));
        Assert.assertEquals((String)"M to Mi test failed", (long)953L, (long)UnitsConversionUtil.convert((String)"M", (String)"Mi", (long)1000L));
    }

    @Test
    public void testOverflow() {
        long test = 5000000000000000L;
        try {
            UnitsConversionUtil.convert((String)"P", (String)"p", (long)test);
            Assert.fail((String)"this operation should result in an overflow");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            UnitsConversionUtil.convert((String)"m", (String)"p", (long)0x7FFFFFFFFFFFFFFEL);
            Assert.fail((String)"this operation should result in an overflow");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCompare() {
        String unitA = "P";
        long valueA = 1L;
        String unitB = "p";
        long valueB = 2L;
        Assert.assertEquals((long)1L, (long)UnitsConversionUtil.compare((String)unitA, (long)valueA, (String)unitB, (long)valueB));
        Assert.assertEquals((long)-1L, (long)UnitsConversionUtil.compare((String)unitB, (long)valueB, (String)unitA, (long)valueA));
        Assert.assertEquals((long)0L, (long)UnitsConversionUtil.compare((String)unitA, (long)valueA, (String)unitA, (long)valueA));
        Assert.assertEquals((long)-1L, (long)UnitsConversionUtil.compare((String)unitA, (long)valueA, (String)unitA, (long)valueB));
        Assert.assertEquals((long)1L, (long)UnitsConversionUtil.compare((String)unitA, (long)valueB, (String)unitA, (long)valueA));
        unitB = "T";
        Assert.assertEquals((long)1L, (long)UnitsConversionUtil.compare((String)unitA, (long)valueA, (String)unitB, (long)valueB));
        Assert.assertEquals((long)-1L, (long)UnitsConversionUtil.compare((String)unitB, (long)valueB, (String)unitA, (long)valueA));
        Assert.assertEquals((long)0L, (long)UnitsConversionUtil.compare((String)unitA, (long)valueA, (String)unitB, (long)1000L));
        unitA = "p";
        unitB = "n";
        Assert.assertEquals((long)-1L, (long)UnitsConversionUtil.compare((String)unitA, (long)valueA, (String)unitB, (long)valueB));
        Assert.assertEquals((long)1L, (long)UnitsConversionUtil.compare((String)unitB, (long)valueB, (String)unitA, (long)valueA));
        Assert.assertEquals((long)0L, (long)UnitsConversionUtil.compare((String)unitA, (long)1000L, (String)unitB, (long)valueA));
    }
}

