/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import org.apache.hadoop.yarn.util.WindowsResourceCalculatorPlugin;
import org.junit.Assert;
import org.junit.Test;

public class TestWindowsResourceCalculatorPlugin {
    @Test(timeout=30000L)
    public void parseSystemInfoString() {
        WindowsResourceCalculatorPluginTester tester = new WindowsResourceCalculatorPluginTester();
        tester.infoStr = "17177038848,8589467648,15232745472,6400417792,1,2805000,6261812\r\n";
        tester.getAvailablePhysicalMemorySize();
        Assert.assertTrue((tester.vmemSize == 17177038848L ? 1 : 0) != 0);
        Assert.assertTrue((tester.memSize == 8589467648L ? 1 : 0) != 0);
        Assert.assertTrue((tester.vmemAvailable == 15232745472L ? 1 : 0) != 0);
        Assert.assertTrue((tester.memAvailable == 6400417792L ? 1 : 0) != 0);
        Assert.assertTrue((tester.numProcessors == 1 ? 1 : 0) != 0);
        Assert.assertTrue((tester.cpuFrequencyKhz == 2805000L ? 1 : 0) != 0);
        Assert.assertTrue((tester.cumulativeCpuTimeMs == 6261812L ? 1 : 0) != 0);
        Assert.assertTrue((tester.cpuUsage == -1.0f ? 1 : 0) != 0);
    }

    @Test(timeout=20000L)
    public void refreshAndCpuUsage() throws InterruptedException {
        WindowsResourceCalculatorPluginTester tester = new WindowsResourceCalculatorPluginTester();
        tester.infoStr = "17177038848,8589467648,15232745472,6400417792,1,2805000,6261812\r\n";
        tester.getAvailablePhysicalMemorySize();
        Assert.assertTrue((tester.memAvailable == 6400417792L ? 1 : 0) != 0);
        Assert.assertTrue((tester.cpuUsage == -1.0f ? 1 : 0) != 0);
        tester.infoStr = "17177038848,8589467648,15232745472,5400417792,1,2805000,6261812\r\n";
        tester.getAvailablePhysicalMemorySize();
        Assert.assertTrue((tester.memAvailable == 6400417792L ? 1 : 0) != 0);
        Assert.assertTrue((tester.cpuUsage == -1.0f ? 1 : 0) != 0);
        Thread.sleep(1500L);
        tester.infoStr = "17177038848,8589467648,15232745472,5400417792,1,2805000,6286812\r\n";
        tester.getAvailablePhysicalMemorySize();
        Assert.assertTrue((tester.memAvailable == 5400417792L ? 1 : 0) != 0);
        Assert.assertTrue(((double)tester.cpuUsage >= 0.1 ? 1 : 0) != 0);
    }

    @Test(timeout=20000L)
    public void errorInGetSystemInfo() {
        WindowsResourceCalculatorPluginTester tester = new WindowsResourceCalculatorPluginTester();
        tester.infoStr = null;
        tester.getAvailablePhysicalMemorySize();
    }

    class WindowsResourceCalculatorPluginTester
    extends WindowsResourceCalculatorPlugin {
        private String infoStr = null;

        WindowsResourceCalculatorPluginTester() {
        }

        String getSystemInfoInfoFromShell() {
            return this.infoStr;
        }
    }
}

